#include "common/basic.h"

static char (*prim_input)() = 0;
static int *yylineno;
     /* passed into reset_lex_input */


#define STACKDEPTH 100

static char stack[STACKDEPTH];
static int sp = 0;
static bool lock = FALSE;

void start_lex_input(char (*pi)(), int *lineno)
{
    sp = 0;
    prim_input = pi;
    yylineno = lineno;
    *yylineno = 1;
    assert(!lock);
    lock = TRUE;
}

void finish_lex_input()
{
    assert(lock);
    lock = FALSE;
}

char lex_input()
{
    char c;
    if (sp == 0) {
	c = (*prim_input)();
    } else {
	c = stack[sp--];
    }
    if (c == '\n') (*yylineno)++;
    return c;
}

void lex_unput(char c)
{
    stack[++sp] = c;
    if (c == '\n') (*yylineno)--;
}
