#ifndef _SPECS_H
#define _SPECS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "common/basic.h"
#include "runtime/obj.h"
#include "types/dict_def.h"

extern char const builtinSpecs[];
/* Textual specifications for all the builtin types and classes. */

struct builtinObj {
    char const *name;
    obj *object;
    bool primitive;
    int oref;
    void (*init_func)();
};

extern struct builtinObj const builtinObjs[];
/* The last entry in "builtinObjs" is a sentinel. Its "name" field
   is 0.
*/

extern dict init_builtin_types();
/* Initialize builtin types, which are mentioned in "type.h".
 * "initialize_wellknowns" must be called before this.  Returns dict
 * usable as a typeEnv containing mappings for the built-in type names.
 */

#ifdef __cplusplus
}
#endif

#endif
