
/*  A Bison parser, made from ti_grammar.y  */

#define YYBISON 1  /* Identify Bison output.  */

#define	CLASS	258
#define	COLON	259
#define	COMMA	260
#define	DOLLAR	261
#define	DOT	262
#define	DOTDOT	263
#define	END	264
#define	FIELDS	265
#define	HAS	266
#define	IMPLEMENTS	267
#define	INHERITS	268
#define	TYPE	269
#define	Id	270
#define	LBRACK	271
#define	LexErr	272
#define	RBRACK	273
#define	RETURNS	274
#define	LPAREN	275
#define	RPAREN	276
#define	SIGNALS	277
#define	WHERE	278
#define	YIELDS	279
#define	EQ	280
#define	VISIBLE	281
#define	SPECIAL	282
#define	EXTENSION	283
#define	Comment	284

#line 1 "ti_grammar.y"


#include "types/class_class.h"
#include "types/list.h"
#include "types/any.h"
#include "types/stdlist.h"
#include "types/vec.h"
#include "types/dict.h"
#include "types/ptype.h"
#include "types/instn.h"
#include "types/str.h"
#include "types/string_class.h"
#include "specs.h"
#include "runtime/alloc.h"
#include "types/pclass_class.h"
#include "types/param_class.h"
#include "types/vec_class.h"
#include "types/vec_instns.h"
#include "common/th_assert.h"
#include <stdio.h>
/*
    The previous include lines are prefixed with H because of the
    extra preprocessing step that is used to split the file into
    ti_grammar.y and pass1_grammar.y. The preprocessor converts
    them into normal #include's, so that actual file inclusion
    does not happen until the .c file is compiled.
*/

extern int linenumber;
extern dict global_newEnv;
extern dict global_typeEnv;
dict local_typeEnv;





extern vec set_self(type t, vec v);

extern vec bundleVec(type T, list l);
/* Bundle the items in the "l" up into a "vec[T]". If "l == 0", then
   the vec is made to have zero length. */

extern obj findType(string name, dict typeEnv);
/* Given that "name" maps to a type in "typeEnv", return that type.
   Otherwise, raise the exception "not_found".
*/

extern type lookup_type(string id);
/* Perform the usual type lookup for a type, class, or parameterized
   type or class with name "id".
*/

extern void handleSupertypes(objtype t, vec as_parsed);
/* Attach the supertype list "as_parsed" to "t", modifying it as
   necessary if "as_parsed" is empty. */

void makeParamEnv(vec ids);
/* Create a bunch of "param"s with the names "ids" and initialize
   "local_typeEnv" as a new dictionary containing those params.
    Types are first looked up in "local_typeEnv", so this has the
    effect of pushing a new environment for doing lookups. */
  
extern vec processParams(vec ids);
/* Return a "vec" containing "param"s with names from "ids" */

extern void processWhere(string name, vec decls);
/* Attach the method specs of "decls" to the parameter named "name" */

void finishParams(ptype pt);
/* Link the params of "pt" to point to it as their ptype */
  
struct ry {
    vec types;
    bool is_iter;
};

struct ry *new_ry()
  {
      return THOR_MALLOC(struct ry);
  }

struct fields {
    bool is_special;
    vec v;
    string special;
};

struct fields *new_fields()
{
    return THOR_MALLOC(struct fields);
}

struct viz {
    bool is_visible;
};









#line 118 "ti_grammar.y"
typedef union {
    any interface;
    bool b;
    char c;
    string s;
    list lst;
    vec vec;
    method methd;
    signal_ sig;
    param param_;
    formal frml;
    type type_;
    class_ class__;
    struct ry *ry;
    struct fields *fields;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct ti_ltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  ti_ltype;

#define YYLTYPE ti_ltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		115
#define	YYFLAG		-32768
#define	YYNTBASE	30

#define YYTRANSLATE(x) ((unsigned)(x) <= 284 ? ti_translate[x] : 67)

static const char ti_translate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29
};

#if YYDEBUG != 0
static const short ti_prhs[] = {     0,
     0,     3,     4,     6,     8,     9,    23,    33,    34,    36,
    37,    40,    43,    44,    50,    52,    54,    55,    60,    65,
    66,    71,    73,    75,    77,    78,    80,    82,    87,    89,
    91,    95,    97,    99,   103,   105,   110,   111,   112,   118,
   120,   121,   124,   130,   132,   134,   138,   140,   142,   146,
   148,   152,   156,   163,   169,   172,   176,   179,   184,   186,
   190,   191
};

#endif

static const short ti_rhs[] = {    30,
    31,     0,     0,    32,     0,    34,     0,     0,    39,    25,
    35,    44,     3,    53,    33,    64,    36,    66,    37,     9,
    39,     0,    39,    25,    35,    14,    53,    66,    37,     9,
    39,     0,     0,    48,     0,     0,    13,    46,     0,    37,
    38,     0,     0,    39,    63,    41,    42,    66,     0,    15,
     0,    39,     0,     0,    19,    20,    48,    21,     0,    24,
    20,    48,    21,     0,     0,    22,    20,    50,    21,     0,
    39,     0,    47,     0,    45,     0,     0,    26,     0,    39,
     0,    40,    16,    48,    18,     0,    49,     0,    43,     0,
    49,     5,    43,     0,    51,     0,    52,     0,    51,     5,
    52,     0,    39,     0,    39,    20,    48,    21,     0,     0,
     0,    16,    60,    18,    54,    55,     0,    56,     0,     0,
    56,    57,     0,    23,    39,    11,    58,     9,     0,    59,
     0,    38,     0,    59,     5,    38,     0,    61,     0,    39,
     0,    61,     5,    39,     0,    65,     0,    62,     5,    65,
     0,    20,    62,    21,     0,    20,    62,     8,     4,    43,
    21,     0,    20,     8,     4,    43,    21,     0,    20,    21,
     0,    20,    62,    21,     0,    20,    21,     0,    27,    16,
    66,    18,     0,    27,     0,    61,     4,    43,     0,     0,
    66,    29,     0
};

#if YYDEBUG != 0
static const short ti_rline[] = { 0,
   157,   158,   159,   160,   162,   179,   274,   318,   322,   326,
   330,   338,   342,   346,   358,   362,   367,   373,   379,   385,
   389,   393,   404,   408,   409,   413,   417,   428,   458,   462,
   467,   471,   475,   479,   483,   492,   499,   504,   513,   515,
   519,   520,   521,   525,   529,   534,   539,   543,   549,   554,
   558,   574,   581,   591,   601,   608,   615,   622,   629,   638,
   656,   660
};

static const char * const ti_tname[] = {   "$","error","$illegal.","CLASS","COLON",
"COMMA","DOLLAR","DOT","DOTDOT","END","FIELDS","HAS","IMPLEMENTS","INHERITS",
"TYPE","Id","LBRACK","LexErr","RBRACK","RETURNS","LPAREN","RPAREN","SIGNALS",
"WHERE","YIELDS","EQ","VISIBLE","SPECIAL","EXTENSION","Comment","interfaces",
"interface","class_intf","@1","type_intf","otypes","oclass","_decls","decl",
"id","typeid","oretsyields","osigs","type","ovisible","visible","class","instance",
"types","_types","sigs","_sigs","sig","oparams","@2","wheres","_wheres","where",
"declsc","_declsc","ids","_ids","_formals","procformals","fields","formal","_spec",
""
};
#endif

static const short ti_r1[] = {     0,
    30,    30,    31,    31,    33,    32,    34,    35,    35,    36,
    36,    37,    37,    38,    39,    40,    41,    41,    41,    42,
    42,    43,    43,    44,    44,    45,    46,    47,    48,    49,
    49,    50,    51,    51,    52,    52,    53,    54,    53,    55,
    56,    56,    57,    58,    59,    59,    60,    61,    61,    62,
    62,    63,    63,    63,    63,    64,    64,    64,    64,    65,
    66,    66
};

static const short ti_r2[] = {     0,
     2,     0,     1,     1,     0,    13,     9,     0,     1,     0,
     2,     2,     0,     5,     1,     1,     0,     4,     4,     0,
     4,     1,     1,     1,     0,     1,     1,     4,     1,     1,
     3,     1,     1,     3,     1,     4,     0,     0,     5,     1,
     0,     2,     5,     1,     1,     3,     1,     1,     3,     1,
     3,     3,     6,     5,     2,     3,     2,     4,     1,     3,
     0,     2
};

static const short ti_defact[] = {     2,
     0,    15,     1,     3,     4,     0,     8,    25,    22,     0,
    30,    23,     9,    29,    37,    26,     0,    24,     0,     0,
     0,    61,    37,     0,    31,    48,     0,    47,    13,     5,
    28,    38,     0,    62,     0,     0,    41,    49,     0,    12,
     0,     0,    59,    10,    39,    40,     7,     0,    17,    57,
     0,     0,    50,    61,     0,    61,     0,    42,     0,    55,
     0,     0,     0,    20,     0,     0,    56,     0,    27,    11,
    13,     0,     0,     0,    52,     0,     0,     0,    61,    60,
    51,    58,     0,     0,     0,     0,     0,     0,     0,    14,
     0,    45,     0,    44,    54,     0,    18,    19,    35,     0,
    32,    33,     6,    43,     0,    53,     0,    21,     0,    46,
     0,    34,    36,     0,     0
};

static const short ti_defgoto[] = {     1,
     3,     4,    36,     5,     8,    56,    35,    40,     9,    10,
    64,    79,    11,    17,    18,    70,    12,    13,    14,   100,
   101,   102,    22,    37,    45,    46,    58,    93,    94,    27,
    51,    52,    49,    44,    53,    29
};

static const short ti_pact[] = {-32768,
    10,-32768,-32768,-32768,-32768,    -8,    18,    -7,     0,    23,
-32768,-32768,-32768,    37,    27,-32768,    41,-32768,    18,    18,
    18,-32768,    27,    28,-32768,-32768,    30,    45,    24,-32768,
-32768,-32768,    18,-32768,    20,    -9,-32768,-32768,    18,-32768,
    31,    15,    36,    42,-32768,    38,-32768,     6,    21,-32768,
     8,     3,-32768,-32768,    18,-32768,    18,-32768,    56,-32768,
     1,    43,    44,    40,    18,    18,-32768,    -3,-32768,-32768,
    24,    55,    18,    63,-32768,    18,    18,    48,-32768,-32768,
-32768,-32768,    22,    18,    50,    18,    51,    52,    18,    24,
    18,-32768,    60,    69,-32768,    54,-32768,-32768,    57,    58,
    71,-32768,-32768,-32768,    18,-32768,    18,-32768,    18,-32768,
    59,-32768,-32768,    78,-32768
};

static const short ti_pgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    13,   -82,    -1,-32768,
-32768,-32768,   -16,-32768,-32768,-32768,-32768,   -18,-32768,-32768,
-32768,   -28,    62,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    65,    39,-32768,-32768,    25,   -51
};


#define	YYLAST		108


static const short ti_table[] = {     6,
    24,    92,    68,    25,    71,    66,    15,    66,    74,   114,
    42,    65,    33,    59,    82,   -16,     7,    43,    16,    26,
     2,    75,   110,    67,     2,    34,    60,    90,    39,     2,
    91,    38,     2,    41,     2,    50,     2,    47,    19,    62,
    26,    20,    21,    23,    63,    31,    26,    32,    80,    33,
    48,    54,    34,    69,    55,    72,    85,    87,    88,    73,
    57,    78,    76,    77,    26,    84,    86,    89,   104,    96,
    95,    97,    98,   105,   106,   109,   107,   115,   108,   113,
   112,    41,    41,    83,    30,    28,    61,    99,   111,   103,
    81,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    41,     0,     0,     0,    99
};

static const short ti_check[] = {     1,
    19,    84,    54,    20,    56,     5,    14,     5,     8,     0,
    20,     4,     5,     8,    18,    16,    25,    27,    26,    21,
    15,    21,   105,    21,    15,    29,    21,    79,     9,    15,
     9,    33,    15,    35,    15,    21,    15,    39,    16,    19,
    42,     5,    16,     3,    24,    18,    48,    18,    65,     5,
    20,    16,    29,    55,    13,    57,    73,    76,    77,     4,
    23,    22,    20,    20,    66,    11,     4,    20,     9,    86,
    21,    21,    21,     5,    21,     5,    20,     0,    21,    21,
   109,    83,    84,    71,    23,    21,    48,    89,   107,    91,
    66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,   105,    -1,    -1,    -1,   109
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 1 "ti_grammar.y"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define ti_errok		(ti_errstatus = 0)
#define ti_clearin	(ti_char = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto ti_errlab1
/* Like YYERROR except do call ti_error.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto ti_errlab
#define YYRECOVERING()  (!!ti_errstatus)
#define YYBACKUP(token, value) \
do								\
  if (ti_char == YYEMPTY && ti_len == 1)				\
    { ti_char = (token), ti_lval = (value);			\
      ti_char1 = YYTRANSLATE (ti_char);				\
      YYPOPSTACK;						\
      goto ti_backup;						\
    }								\
  else								\
    { ti_error ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		ti_lex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		ti_lex(&ti_lval, &ti_lloc)
#else
#define YYLEX		ti_lex(&ti_lval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	ti_char;			/*  the lookahead symbol		*/
YYSTYPE	ti_lval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE ti_lloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int ti_nerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int ti_debug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __ti__bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__ti__bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__ti__bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 1 "ti_grammar.y"
int
ti_parse()
{
  register int ti_state;
  register int ti_n;
  register short *ti_ssp;
  register YYSTYPE *ti_vsp;
  int ti_errstatus;	/*  number of tokens to shift before error messages enabled */
  int ti_char1;		/*  lookahead token as an internal (translated) token number */

  short	ti_ssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE ti_vsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *ti_ss = ti_ssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *ti_vs = ti_vsa;	/*  to allow ti_overflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE ti_lsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *ti_ls = ti_lsa;
  YYLTYPE *ti_lsp;

#define YYPOPSTACK   (ti_vsp--, ti_ssp--, ti_lsp--)
#else
#define YYPOPSTACK   (ti_vsp--, ti_ssp--)
#endif

  int ti_stacksize = YYINITDEPTH;

#ifdef YYPURE
  int ti_char;
  YYSTYPE ti_lval;
  int ti_nerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE ti_lloc;
#endif
#endif

  YYSTYPE ti_val;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int ti_len;

#if YYDEBUG != 0
  if (ti_debug)
    fprintf(stderr, "Starting parse\n");
#endif

  ti_state = 0;
  ti_errstatus = 0;
  ti_nerrs = 0;
  ti_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  ti_ssp = ti_ss - 1;
  ti_vsp = ti_vs;
#ifdef YYLSP_NEEDED
  ti_lsp = ti_ls;
#endif

/* Push a new state, which is found in  ti_state  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
ti_newstate:

  *++ti_ssp = ti_state;

  if (ti_ssp >= ti_ss + ti_stacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *ti_vs1 = ti_vs;
      short *ti_ss1 = ti_ss;
#ifdef YYLSP_NEEDED
      YYLTYPE *ti_ls1 = ti_ls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = ti_ssp - ti_ss + 1;

#ifdef ti_overflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      ti_overflow("parser stack overflow",
		 &ti_ss1, size * sizeof (*ti_ssp),
		 &ti_vs1, size * sizeof (*ti_vsp),
#ifdef YYLSP_NEEDED
		 &ti_ls1, size * sizeof (*ti_lsp),
#endif
		 &ti_stacksize);

      ti_ss = ti_ss1; ti_vs = ti_vs1;
#ifdef YYLSP_NEEDED
      ti_ls = ti_ls1;
#endif
#else /* no ti_overflow */
      /* Extend the stack our own way.  */
      if (ti_stacksize >= YYMAXDEPTH)
	{
	  ti_error("parser stack overflow");
	  return 2;
	}
      ti_stacksize *= 2;
      if (ti_stacksize > YYMAXDEPTH)
	ti_stacksize = YYMAXDEPTH;
      ti_ss = (short *) alloca (ti_stacksize * sizeof (*ti_ssp));
      __ti__bcopy ((char *)ti_ss1, (char *)ti_ss, size * sizeof (*ti_ssp));
      ti_vs = (YYSTYPE *) alloca (ti_stacksize * sizeof (*ti_vsp));
      __ti__bcopy ((char *)ti_vs1, (char *)ti_vs, size * sizeof (*ti_vsp));
#ifdef YYLSP_NEEDED
      ti_ls = (YYLTYPE *) alloca (ti_stacksize * sizeof (*ti_lsp));
      __ti__bcopy ((char *)ti_ls1, (char *)ti_ls, size * sizeof (*ti_lsp));
#endif
#endif /* no ti_overflow */

      ti_ssp = ti_ss + size - 1;
      ti_vsp = ti_vs + size - 1;
#ifdef YYLSP_NEEDED
      ti_lsp = ti_ls + size - 1;
#endif

#if YYDEBUG != 0
      if (ti_debug)
	fprintf(stderr, "Stack size increased to %d\n", ti_stacksize);
#endif

      if (ti_ssp >= ti_ss + ti_stacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (ti_debug)
    fprintf(stderr, "Entering state %d\n", ti_state);
#endif

 ti_backup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* ti_resume: */

  /* First try to decide what to do without reference to lookahead token.  */

  ti_n = ti_pact[ti_state];
  if (ti_n == YYFLAG)
    goto ti_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* ti_char is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (ti_char == YYEMPTY)
    {
#if YYDEBUG != 0
      if (ti_debug)
	fprintf(stderr, "Reading a token: ");
#endif
      ti_char = YYLEX;
    }

  /* Convert token to internal form (in ti_char1) for indexing tables with */

  if (ti_char <= 0)		/* This means end of input. */
    {
      ti_char1 = 0;
      ti_char = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (ti_debug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      ti_char1 = YYTRANSLATE(ti_char);

#if YYDEBUG != 0
      if (ti_debug)
	{
	  fprintf (stderr, "Next token is %d (%s", ti_char, ti_tname[ti_char1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, ti_char, ti_lval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  ti_n += ti_char1;
  if (ti_n < 0 || ti_n > YYLAST || ti_check[ti_n] != ti_char1)
    goto ti_default;

  ti_n = ti_table[ti_n];

  /* ti_n is what to do for this token type in this state.
     Negative => reduce, -ti_n is rule number.
     Positive => shift, ti_n is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (ti_n < 0)
    {
      if (ti_n == YYFLAG)
	goto ti_errlab;
      ti_n = -ti_n;
      goto ti_reduce;
    }
  else if (ti_n == 0)
    goto ti_errlab;

  if (ti_n == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (ti_debug)
    fprintf(stderr, "Shifting token %d (%s), ", ti_char, ti_tname[ti_char1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (ti_char != YYEOF)
    ti_char = YYEMPTY;

  *++ti_vsp = ti_lval;
#ifdef YYLSP_NEEDED
  *++ti_lsp = ti_lloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (ti_errstatus) ti_errstatus--;

  ti_state = ti_n;
  goto ti_newstate;

/* Do the default action for the current state.  */
ti_default:

  ti_n = ti_defact[ti_state];
  if (ti_n == 0)
    goto ti_errlab;

/* Do a reduction.  ti_n is the number of a rule to reduce with.  */
ti_reduce:
  ti_len = ti_r2[ti_n];
  ti_val = ti_vsp[1-ti_len]; /* implement default value of the action */

#if YYDEBUG != 0
  if (ti_debug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       ti_n, ti_rline[ti_n]);

      /* Print the symboles being reduced, and their result.  */
      for (i = ti_prhs[ti_n]; ti_rhs[i] > 0; i++)
	fprintf (stderr, "%s ", ti_tname[ti_rhs[i]]);
      fprintf (stderr, " -> %s\n", ti_tname[ti_r1[ti_n]]);
    }
#endif


  switch (ti_n) {

case 5:
#line 165 "ti_grammar.y"
{
                                 if (ti_vsp[0].vec) {
				   pclass pc = (pclass)findType(ti_vsp[-5].s,
								global_typeEnv);
				   CATCH {
				     ti_error("PClass not found");
				     exc = EXC_NONE; YYABORT;
				   }

				   pc->hdr.inh.params = ti_vsp[0].vec;
				   finishParams(&pc->hdr.inh);
				 }
                            ;
    break;}
case 6:
#line 183 "ti_grammar.y"
{ if (ti_vsp[-7].vec) {
				pclass pc = (pclass)findType(ti_vsp[-12].s,
							     global_typeEnv);
				CATCH {
				    ti_error("PClass not found");
				    exc = EXC_NONE; YYABORT;
				}
				if (!string_equal(ti_vsp[-12].s, ti_vsp[0].s)) {
				    ti_error("id mismatch");
				    YYABORT;
				}
				if (!ti_vsp[-5].fields->is_special) {
				    pc->fields = ti_vsp[-5].fields->v;
				    pc->special = FALSE;
				    pc->specialText = string_empty();
				} else {
				    pc->fields = bundleVec(class_as_type(Formal), 0);
				    pc->special = TRUE;
				    pc->specialText = ti_vsp[-5].fields->special;
				}
				free(ti_vsp[-5].fields);
				if (ti_vsp[-9].b) {
					pc->visible = TRUE;
			        } else {
					pc->visible = FALSE;
				}
				handleSupertypes(&pc->hdr.inh.hdr.inh, ti_vsp[-10].vec);
				pc->hdr.inh.hdr.inh.methods_ = 
				    set_self
				    ((type)(pclass_as_ptype(pc)),
				     bundleVec(class_as_type(Method),ti_vsp[-2].lst));

				CATCH {
				    ti_error("Improper subtype ordering");
				    exc = EXC_NONE;
 				    YYABORT;
				}
				pc->hdr.inh.hdr.inh.overview = ti_vsp[-3].s;
				pc->superclass = bundleVec
				  (class_as_type(Class), ti_vsp[-4].lst);
			      } else {
				  class_ c = (class_)findType(ti_vsp[-12].s,
							      global_typeEnv);
				  CATCH {
				      ti_error("Class not found");
				      exc = EXC_NONE; YYABORT;
				  }

				  if (!string_equal(ti_vsp[-12].s, ti_vsp[0].s)) {
				      ti_error("id mismatch");
				      YYABORT;
				  }
				  if (!ti_vsp[-5].fields->is_special) {
				      c->fields = ti_vsp[-5].fields->v;
				      c->special = FALSE;
				      c->specialText = string_empty();
				  } else {
				      c->fields = bundleVec(class_as_type(Formal), 0);
				      c->special = TRUE;
				      c->specialText = ti_vsp[-5].fields->special;
				  }
				  if (ti_vsp[-9].b) {
					c->visible = TRUE;
				  } else {
					c->visible = FALSE;
				  }
				  c->hdr.inh.name = ti_vsp[-12].s;
				  handleSupertypes(class_as_objtype(c), ti_vsp[-10].vec);

				  c->hdr.inh.methods_ = 
				      set_self
				      (class_as_type(c),
				       bundleVec(class_as_type(Method), ti_vsp[-2].lst));
				      
				      
				  
				  

				  CATCH {
				      ti_error("Improper subtype ordering");
				      exc = EXC_NONE;
				      YYABORT;
				  }
				  c->hdr.inh.overview = ti_vsp[-3].s;
				  c->superclass = bundleVec
				    (class_as_type(Class), ti_vsp[-4].lst);
			      }
			    ;
    break;}
case 7:
#line 278 "ti_grammar.y"
{
				objtype t;
				if (!string_equal(ti_vsp[-8].s, ti_vsp[0].s)) {
				    ti_error("id mismatch");
				    YYABORT;
				}
				if (ti_vsp[-4].vec) {
				    ptype pt = (ptype)findType(ti_vsp[-8].s,
							       global_typeEnv);
				    CATCH {
					ti_error("PType not found");
					exc = EXC_NONE; YYABORT;
				    }
				    pt->params = ti_vsp[-4].vec;
				    finishParams(pt);
				    t = &pt->hdr.inh;
				} else {
				    t = (objtype)findType(ti_vsp[-8].s, global_typeEnv);
				    CATCH {
					ti_error("Type not found");
					exc = EXC_NONE; YYABORT;
				    }
				}
				assert(string_equal(t->name, ti_vsp[-8].s));
				handleSupertypes(t, ti_vsp[-6].vec);
				t->methods_ = 
				    set_self
				    (objtype_as_type(t),
				     bundleVec(class_as_type(Method), ti_vsp[-2].lst));
				  

				CATCH {
				    ti_error("Improper subtype ordering");
				    exc = EXC_NONE;
				    YYABORT;
				}
				t->overview = ti_vsp[-3].s;
			    ;
    break;}
case 8:
#line 320 "ti_grammar.y"
{ ti_val.vec = bundleVec(Type, 0); ;
    break;}
case 9:
#line 324 "ti_grammar.y"
{ ti_val.vec = ti_vsp[0].vec; ;
    break;}
case 10:
#line 328 "ti_grammar.y"
{ ti_val.lst = 0; ;
    break;}
case 11:
#line 332 "ti_grammar.y"
{
				ti_val.lst = cons(obj_as_any(type_as_obj
						     (class_as_type(ti_vsp[0].class__))),
					  empty_list());
			    ;
    break;}
case 12:
#line 340 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any((obj)ti_vsp[0].methd), ti_vsp[-1].lst); ;
    break;}
case 13:
#line 344 "ti_grammar.y"
{ ti_val.lst = empty_list(); ;
    break;}
case 14:
#line 349 "ti_grammar.y"
{ ti_val.methd = ti_vsp[-3].methd;
			      ti_val.methd->name = ti_vsp[-4].s;
			      ti_val.methd->returns = ti_vsp[-2].ry->types;
			      ti_val.methd->iter = ti_vsp[-2].ry->is_iter;
			      free(ti_vsp[-2].ry);
			      ti_val.methd->signals = ti_vsp[-1].vec;
			      ti_val.methd->spec = ti_vsp[0].s;
			    ;
    break;}
case 15:
#line 360 "ti_grammar.y"
{ ti_val.s = ti_vsp[0].s; ;
    break;}
case 16:
#line 365 "ti_grammar.y"
{ ti_val.s = ti_vsp[0].s; ;
    break;}
case 17:
#line 369 "ti_grammar.y"
{ ti_val.ry = new_ry();
			      ti_val.ry->types = make_vec_Type(0, FALSE);
			      ti_val.ry->is_iter = FALSE; ;
    break;}
case 18:
#line 375 "ti_grammar.y"
{ ti_val.ry = new_ry();
			      ti_val.ry->is_iter = FALSE;
			      ti_val.ry->types = ti_vsp[-1].vec; ;
    break;}
case 19:
#line 381 "ti_grammar.y"
{ ti_val.ry = new_ry();
			      ti_val.ry->is_iter = TRUE;
			      ti_val.ry->types = ti_vsp[-1].vec; ;
    break;}
case 20:
#line 387 "ti_grammar.y"
{ ti_val.vec = bundleVec(class_as_type(Signal), 0); ;
    break;}
case 21:
#line 391 "ti_grammar.y"
{ ti_val.vec = ti_vsp[-1].vec; ;
    break;}
case 22:
#line 396 "ti_grammar.y"
{
			    	ti_val.type_ = lookup_type(ti_vsp[0].s);
                                if (exc) {
				    exc = EXC_NONE;
				    YYABORT;
				}
			    ;
    break;}
case 23:
#line 406 "ti_grammar.y"
{ ti_val.type_ = ti_vsp[0].type_; ;
    break;}
case 25:
#line 410 "ti_grammar.y"
{ ti_val.b = FALSE; ;
    break;}
case 26:
#line 414 "ti_grammar.y"
{ ti_val.b = TRUE; ;
    break;}
case 27:
#line 420 "ti_grammar.y"
{ ti_val.class__ = (class_)(findType(ti_vsp[0].s, global_typeEnv));
			      CATCH {
				  ti_error("Class not found");
				  exc = EXC_NONE; YYABORT;
			      }

			  ;
    break;}
case 28:
#line 430 "ti_grammar.y"
{ any a;
			      assert(!exc);
			      a = dict_fetch(global_typeEnv, ti_vsp[-3].s);
			      if (exc) {
			         fprintf(stderr, "%s: not found\n",
					 string_charp(ti_vsp[-3].s));
			      }

			      {
				  ptype pt = (ptype)any_as_obj(a);
				  ti_val.type_ = instn_as_type(
					  ptype_instantiate(pt, ti_vsp[-1].vec));
				  CATCH {
				    char buf[100];
				    fevalue *vals = (fevalue *)exc_value;
				    sprintf(buf,
					    "Could not instantiate: "
					    "because of method %s in"
					    "type parameter %s\n",
					    string_charp((string)vals[0].o),
					    string_charp
					      (type_name((type)vals[1].o)));
				    ti_error(buf);
				    YYABORT;
				  }
	  	              }
			   ;
    break;}
case 29:
#line 460 "ti_grammar.y"
{ ti_val.vec = bundleVec(Type, ti_vsp[0].lst); ;
    break;}
case 30:
#line 464 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any(type_as_obj(ti_vsp[0].type_)),
					empty_list()); ;
    break;}
case 31:
#line 469 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any(type_as_obj(ti_vsp[0].type_)), ti_vsp[-2].lst); ;
    break;}
case 32:
#line 473 "ti_grammar.y"
{ ti_val.vec = bundleVec(class_as_type(Signal), ti_vsp[0].lst); ;
    break;}
case 33:
#line 477 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any((obj)ti_vsp[0].sig), empty_list()); ;
    break;}
case 34:
#line 481 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any((obj)ti_vsp[0].sig), ti_vsp[-2].lst); ;
    break;}
case 35:
#line 486 "ti_grammar.y"
{ ti_val.sig = new_signal();
			      ti_val.sig->name = ti_vsp[0].s;
			      ti_val.sig->returns = bundleVec(class_as_type(Signal),
						      0);
			    ;
    break;}
case 36:
#line 495 "ti_grammar.y"
{ ti_val.sig = new_signal();
			      ti_val.sig->name = ti_vsp[-3].s;
			      ti_val.sig->returns = ti_vsp[-1].vec; ;
    break;}
case 37:
#line 502 "ti_grammar.y"
{ ti_val.vec = 0; ;
    break;}
case 38:
#line 506 "ti_grammar.y"
{
				makeParamEnv(ti_vsp[-1].vec);
			    ;
    break;}
case 39:
#line 513 "ti_grammar.y"
{ ti_val.vec = processParams(ti_vsp[-3].vec); ;
    break;}
case 40:
#line 517 "ti_grammar.y"
{ ;
    break;}
case 43:
#line 523 "ti_grammar.y"
{ processWhere(ti_vsp[-3].s, ti_vsp[-1].vec); ;
    break;}
case 44:
#line 527 "ti_grammar.y"
{ ti_val.vec = bundleVec(class_as_type(Method), ti_vsp[0].lst); ;
    break;}
case 45:
#line 531 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any((obj)ti_vsp[0].methd),
					empty_list()); ;
    break;}
case 46:
#line 536 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any((obj)ti_vsp[0].methd),
					ti_vsp[-2].lst); ;
    break;}
case 47:
#line 541 "ti_grammar.y"
{ ti_val.vec = bundleVec(class_as_type(String), ti_vsp[0].lst); ;
    break;}
case 48:
#line 546 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any(string_as_obj(ti_vsp[0].s)),
					empty_list()); ;
    break;}
case 49:
#line 551 "ti_grammar.y"
{ ti_val.lst = cons(obj_as_any(string_as_obj(ti_vsp[0].s)),
					ti_vsp[-2].lst); ;
    break;}
case 50:
#line 556 "ti_grammar.y"
{ ti_val.lst = stdlist_reverse(ti_vsp[0].lst); ;
    break;}
case 51:
#line 560 "ti_grammar.y"
{
				list l3 = stdlist_reverse(ti_vsp[0].lst);
				ti_val.lst = ti_vsp[-2].lst;
				loop {
				    any a = first(l3);
				    CATCH {
					exc = EXC_NONE;
					break;
				    }
				    l3 = rest(l3);
				    ti_val.lst = cons(a, ti_val.lst);
				}
			    ;
    break;}
case 52:
#line 576 "ti_grammar.y"
{ ti_val.methd = new_method();
			      ti_val.methd->arguments = bundleVec(class_as_type(Formal),
							ti_vsp[-1].lst);
			      ti_val.methd->extra_args = bundleVec(Type, 0); ;
    break;}
case 53:
#line 583 "ti_grammar.y"
{ ti_val.methd = new_method();
			      ti_val.methd->arguments = bundleVec(class_as_type(Formal),
							ti_vsp[-4].lst);
			      ti_val.methd->extra_args = bundleVec(Type,
							 cons(obj_as_any(
						type_as_obj(ti_vsp[-1].type_)),
						empty_list())); ;
    break;}
case 54:
#line 593 "ti_grammar.y"
{ ti_val.methd = new_method();
			      ti_val.methd->arguments = bundleVec(class_as_type(Formal),
							0);
			      ti_val.methd->extra_args = bundleVec(Type,
							 cons(obj_as_any(
						type_as_obj(ti_vsp[-1].type_)),
						empty_list())); ;
    break;}
case 55:
#line 603 "ti_grammar.y"
{ ti_val.methd = new_method();
			      ti_val.methd->arguments = bundleVec(class_as_type(Formal),
							0);
			      ti_val.methd->extra_args = bundleVec(Type, 0); ;
    break;}
case 56:
#line 610 "ti_grammar.y"
{ ti_val.fields = THOR_MALLOC(struct fields);
			      ti_val.fields->is_special = FALSE;
			      ti_val.fields->v = bundleVec(class_as_type(Formal), ti_vsp[-1].lst);
			      ti_val.fields->special = 0; ;
    break;}
case 57:
#line 617 "ti_grammar.y"
{ ti_val.fields = new_fields();
			      ti_val.fields->is_special = FALSE;
			      ti_val.fields->v = bundleVec(class_as_type(Formal), 0);
			      ti_val.fields->special = 0; ;
    break;}
case 58:
#line 624 "ti_grammar.y"
{ ti_val.fields = new_fields();
			      ti_val.fields->is_special = TRUE;
			      ti_val.fields->v = 0;
			      ti_val.fields->special = ti_vsp[-1].s; ;
    break;}
case 59:
#line 631 "ti_grammar.y"
{
				ti_val.fields = new_fields();
				ti_val.fields->is_special = TRUE;
				ti_val.fields->v = 0;
				ti_val.fields->special = string_empty();
			    ;
    break;}
case 60:
#line 640 "ti_grammar.y"
{ list l = ti_vsp[-2].lst, l2 = empty_list();
			      loop {
				 any a = first(l);
				 formal f = new_formal();
				 CATCH {
				    exc = EXC_NONE;
				    break;
				 }
				 f->name = (string)any_as_obj(a);
				 f->t = ti_vsp[0].type_;
				 l2 = cons(obj_as_any((obj)f), l2);
				 l = rest(l);
			      }
			      ti_val.lst = l2;
			    ;
    break;}
case 61:
#line 658 "ti_grammar.y"
{ ti_val.s = string_new(""); ;
    break;}
case 62:
#line 662 "ti_grammar.y"
{ if (string_length(ti_vsp[-1].s) > 0)
				ti_val.s = string_concat(ti_vsp[-1].s, string_ctos('\n'));
			    else
			      ti_val.s = ti_vsp[-1].s;
			      ti_val.s = string_concat(ti_val.s, ti_vsp[0].s); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 1 "ti_grammar.y"

  ti_vsp -= ti_len;
  ti_ssp -= ti_len;
#ifdef YYLSP_NEEDED
  ti_lsp -= ti_len;
#endif

#if YYDEBUG != 0
  if (ti_debug)
    {
      short *ssp1 = ti_ss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != ti_ssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++ti_vsp = ti_val;

#ifdef YYLSP_NEEDED
  ti_lsp++;
  if (ti_len == 0)
    {
      ti_lsp->first_line = ti_lloc.first_line;
      ti_lsp->first_column = ti_lloc.first_column;
      ti_lsp->last_line = (ti_lsp-1)->last_line;
      ti_lsp->last_column = (ti_lsp-1)->last_column;
      ti_lsp->text = 0;
    }
  else
    {
      ti_lsp->last_line = (ti_lsp+ti_len-1)->last_line;
      ti_lsp->last_column = (ti_lsp+ti_len-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  ti_n = ti_r1[ti_n];

  ti_state = ti_pgoto[ti_n - YYNTBASE] + *ti_ssp;
  if (ti_state >= 0 && ti_state <= YYLAST && ti_check[ti_state] == *ti_ssp)
    ti_state = ti_table[ti_state];
  else
    ti_state = ti_defgoto[ti_n - YYNTBASE];

  goto ti_newstate;

ti_errlab:   /* here on detecting error */

  if (! ti_errstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++ti_nerrs;

#ifdef YYERROR_VERBOSE
      ti_n = ti_pact[ti_state];

      if (ti_n > YYFLAG && ti_n < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(ti_tname) / sizeof(char *)); x++)
	    if (ti_check[x + ti_n] == x)
	      size += strlen(ti_tname[x]) + 15, count++;
	  msg = (char *) malloc(size + 100 + strlen(ti_tname[ti_char1]));
	  if (msg != 0)
	    {
	      strcpy(msg, "Found "); strcat(msg, ti_tname[ti_char1]);

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(ti_tname) / sizeof(char *)); x++)
		    if (ti_check[x + ti_n] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, ti_tname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      ti_error(msg);
	      free(msg);
	    }
	  else
	    ti_error ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	ti_error("parse error");
    }

ti_errlab1:   /* here on error raised explicitly by an action */

  if (ti_errstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (ti_char == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (ti_debug)
	fprintf(stderr, "Discarding token %d (%s).\n", ti_char, ti_tname[ti_char1]);
#endif

      ti_char = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  ti_errstatus = 3;		/* Each real token shifted decrements this */

  goto ti_errhandle;

ti_errdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  ti_n = ti_defact[ti_state];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (ti_n) goto ti_default;
#endif

ti_errpop:   /* pop the current state because it cannot handle the error token */

  if (ti_ssp == ti_ss) YYABORT;
  ti_vsp--;
  ti_state = *--ti_ssp;
#ifdef YYLSP_NEEDED
  ti_lsp--;
#endif

#if YYDEBUG != 0
  if (ti_debug)
    {
      short *ssp1 = ti_ss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != ti_ssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

ti_errhandle:

  ti_n = ti_pact[ti_state];
  if (ti_n == YYFLAG)
    goto ti_errdefault;

  ti_n += YYTERROR;
  if (ti_n < 0 || ti_n > YYLAST || ti_check[ti_n] != YYTERROR)
    goto ti_errdefault;

  ti_n = ti_table[ti_n];
  if (ti_n < 0)
    {
      if (ti_n == YYFLAG)
	goto ti_errpop;
      ti_n = -ti_n;
      goto ti_reduce;
    }
  else if (ti_n == 0)
    goto ti_errpop;

  if (ti_n == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (ti_debug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++ti_vsp = ti_lval;
#ifdef YYLSP_NEEDED
  *++ti_lsp = ti_lloc;
#endif

  ti_state = ti_n;
  goto ti_newstate;
}
#line 669 "ti_grammar.y"


/*
    Specs for the procedures defined here are found above.
*/



type lookup_type(string id)
{
    any a;
    type ret;
    if (local_typeEnv &&
	(a = dict_fetch(local_typeEnv, id),
	 !exc)) {
	ret = (type)any_get_obj(a);
    } else  {
	exc = EXC_NONE;
	ret = (type)(findType(id, global_typeEnv));
	CATCH {
	    ti_error("Type not found");
	    return 0;
	}
    }
    /* We don't call "obj_as_type" here because
       it may contain assertion checks that will
       fail due to bootstrap circularities. */
    return ret;
}

int list_length(list l)
{
    int count = 0;
    assert(!exc);
    loop {
	l = rest(l);
	CATCH {
	    exc = EXC_NONE;
	    return count;
	}
	count++;
    }
}

vec bundleVec(type T, list l)
{
    int index;
    vec ret;
    bool saved;
    assert(!exc);
    if (l) {
	index = list_length(l);
    } else {
	index = 0;
    }
    
    assert(!exc);
    saved = normal_heap;
    normal_heap = FALSE;
    ret = make_vec_simple(T, index);
    normal_heap = saved;
    assert(!exc);
    if (index) loop {
	fevalue fv;
	any a = first(l);
	CATCH {
	    exc = EXC_NONE;
	    assert(index == 0);
	    return ret;
	}
	l = rest(l);
	index--;
	vec_store(ret, index, any_as_obj(a));
    } else
      return ret;
}

void makeParamEnv(vec ids)
{
    int i, n = vec_length(ids);
    local_typeEnv = dict_new();
    for (i = 0; i < n; i++) {
	param p = NEW_META(struct param_s);
	string name = UNPV(string, vec_fetch(ids, i));
	init_param(p);
	p->methods_ = 0;
	p->name = name;
	dict_add(local_typeEnv, name, obj_as_any((obj)p));
    }
}

vec processParams(vec ids) {
    int i, n = vec_length(ids);
    vec ret = make_vec_Param(n, FALSE);
    for (i = 0; i < n; i++) {
	param p = (param)any_get_obj(dict_fetch(local_typeEnv,
						UNPV(string,
						     vec_fetch(ids, i))));
	if (!p->methods_) {
	    p->methods_ = make_vec_Method(0, FALSE);
	}
	vec_store(ret, i, PV(p));
    }
    return ret;
}

vec set_self(type t, vec method_v)
{
    method* methods = UNPV(method*, vec_items(method_v));
    int size = vec_length(method_v);
    int i;
    
    for (i=0; i<size; i++) {
	methods[i]->self_type = t;
    }
    return method_v;
}


void finishParams(ptype pt)
{
    vec params = pt->params;
    int i, n = vec_length(params);
    for (i = 0; i < n; i++) {
	param p = UNPV(param, vec_fetch(params, i));
	p->ptype_ = pt;
    }
}
		  
void processWhere(string name, vec decls) {
    param p = (param)any_get_obj(dict_fetch(local_typeEnv, name));
    p->methods_ = decls;
}

void handleSupertypes(objtype t, vec as_parsed)
{
    vec ret;
    if (vec_length(as_parsed) == 0 && t != Any) {
	t->supertypes_ = make_vec_Type(1, FALSE);
	vec_store(t->supertypes_, 0, PV(Any));
    } else {
	t->supertypes_ = as_parsed;
    }
}




