
#include "config/vdefs/NDEBUG.h"

#include "types/dict.h"
#include "types/string_class.h"
#include "types/any.h"
#include "types/vec_class.h"
#include "types/method.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/vec_instns.h"


#include "type_init.h"
#include "runtime/disphdr.h"
#include "runtime/alloc.h"
#include "runtime/except.h"
#include "specs.h"

#include "common/class_code.h"
#include "fe_wk_xref.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <limits.h>

bool types_initted = FALSE;  

extern char ti_fname[PATH_MAX], pass1_fname[PATH_MAX];
extern void complete_incomplete();

obj findType(string name, dict typeEnv)
{
    UNHANDLED_EXC;
    {
	any a = dict_fetch(typeEnv, name);
	CATCH {
	    fprintf(stderr,
		    "\"%s\" does not name a type\n", string_charp(name));
	    return 0;
	}
	return any_get_obj(a);
    }
}


/**********
 * Some grungy Bison stuff */
dict global_typeEnv;
dict global_newEnv;
/* End of Bison stuff
 **********/

/***************************
 * Some grungy Lex stuff (see also main.c)
 */

static char const *inp_posn;
static char const *accepted_inp_posn;

static char string_input()
{
    return *inp_posn++;
}

extern char *ti_text;
extern int ti_lineno;

static int lex() {
    accepted_inp_posn = inp_posn;
    return ti_lex();
}

/**************************/

#ifdef YYDEBUG
extern int ti_debug;
extern int theta_debug;
#endif

extern vec no_slottypes;

void assignMethodIndices(objtype t)
{
    method *methods = UNPV(method *, vec_items(t->methods_));
    int num_methods = vec_length(t->methods_);
    int i;
    int offset = direct_methods_size(t) - num_methods;
    for (i = 0; i<num_methods; i++) {
	methods[i]->index = i + offset;
    }
    if (t->kind == CLASS_KIND ||
	t->kind == CLASS_INSTN_KIND) {
	class_ c = (class_)t;
	computeBitfields(c);
        if (!no_slottypes) {
           no_slottypes = make_vec_ObjType(0, FALSE);
           gc_register_meta_root((obj*)&no_slottypes);
        }
        c->slottypes = no_slottypes;

#if 0
	fprintf(stderr,
		"Bitfield for class %s is 0x%x\n",
		string_charp(c->hdr.inh.name),
		UNPV(int, vec_fetch(c->bitfields, 0)));
#endif
    }
}

struct fut_env {
    dict newEnv;
};
    
void finishUpType(struct fut_env *env, string name)
{
    any a = dict_fetch(env->newEnv, name);
    objtype t;
    UNHANDLED_EXC;
    t = (objtype)any_as_obj(a);
    assignMethodIndices(t);
}

dict processTypeSpecs(char const *spec, dict typeEnv)
{
    any a;
    int lineno;
    bool booting = !Class;
#ifdef YYDEBUG
    ti_debug = TRUE;
    pass1_debug = TRUE;
#endif
    
    dict newEnv = dict_new();
    
    global_typeEnv = typeEnv;
    global_newEnv = newEnv;

    start_lex_input(string_input, &lineno);
    inp_posn = spec;
    if (pass1_parse()) exit(-1);
    finish_lex_input();

    start_lex_input(string_input, &lineno);
    inp_posn = spec;
    if (ti_parse()) exit(-1);
    finish_lex_input();

    {
	method getClass_method = UNPV(method, vec_fetch(Any->methods_, 0));
	getClass_method->parameterized = TRUE;
    }
    {
	struct fut_env env;
	struct closure cl;
	env.newEnv = newEnv;
	cl.env = &env;
	cl.f = (ifunc)finishUpType;
	dict_keys(newEnv, cl);

    }

    return newEnv;
}

dict init_builtin_types()
{
    struct builtinObj const *bt = builtinObjs;
    int wk_index = 0;
    dict typeEnv = dict_new();
    bool saved;

    /* check the orefs to make sure they're sequential. */
    while (bt->name) {
	/* printf("%s\n", bt->name); */
	wk_index++;
	assert(wk_index == (int)bt->oref);
	bt++;
    }

    strcpy(pass1_fname, "specs.pth");
    strcpy(ti_fname, "specs.pth");
    
    saved  = normal_heap;
    normal_heap = FALSE;
    (void)processTypeSpecs(builtinSpecs, typeEnv);
    normal_heap = saved;

    bt = builtinObjs;
    while (bt->name) {
	any a;
	obj o = *bt->object;
#ifndef NDEBUG
	if (!o) fprintf(stderr, "The type %s was not defined in "
	                        "the boot interfaces\n", bt->name);
#endif
	th_assert(o, "undeclared type");
	a = obj_as_any(o);
	add_wellknown(bt->name, bt->object);
	/* printf("adding %s\n", bt->name); */
	if (bt->init_func) {
		/* printf("initting %s\n", bt->name); */
		(*bt->init_func)();
		}
	CATCH {
		o = *bt->object;
		assert(o);
		a = obj_as_any(o);
		}
	RESET_EXC;
	{
	    Xref xref;
	    core c;
	    OREF_SET(xref.oref,0,bt->oref);
	    xref.or = WK_OR;
	    c = BUMP(core, o, *o);
	    c->xref = xref;
	    c->handle_ = 0;
	}
#if 0
	fprintf(stderr, "Initialized %s.\n",
		bt->name);
#endif
	bt++;
    }
#if 0
    {
	string u;
	u = type_unparse(Type);
	fwrite(string_charp(u), string_length(u), 1, stderr);
	u = type_unparse(Int);
	fwrite(string_charp(u), string_length(u), 1, stderr);
    }
#endif
    types_initted = TRUE;
    complete_incomplete();


    return typeEnv;
}

class_ class_from_code(class_code code)
{
    struct builtinObj const *bt;
    objtype t;
    int kind;
    if (code < 1 || code >= WK_LAST_OREF) {
	return 0;
    }
    bt = &builtinObjs[code - 1];
    t = *(objtype *)bt->object;
    

#ifndef NDEBUG
    kind = type_kind(class_as_type(get_obj_class(
			type_as_obj(objtype_as_type(t)))));
    if (kind != CLASS_KIND 
		&& kind != CLASS_INSTN_KIND) return 0;
#endif

    return (class_)t;
}
