#ifndef _TYPE_INIT_H
#define _TYPE_INIT_H

#include "types/type.h"
#include "types/dict.h"

#ifdef __cplusplus
extern "C" {
#endif

extern bool types_initted;
/*
   This variable indicates whether it is okay to use runtime
   type discrimination features such as calling the "getClass"
   method. As the system is bootstrapping, it is FALSE, but
   is set to TRUE once all the builtin types are initialized.
*/

extern dict processTypeSpecs(char const *spec, dict typeEnv);

/* Parse type specifications and create corresponding types. The
   types may be mutually recursive. If the types have names
   corresponding to builtin types, the corresponding type variables
   will be initialized.
   
   XXX Whether it is treated as a builtin should be controlled by
   something other than just the name. XXX

   "spec" must be a valid null-terminated Theta type spec. Type names
   are looked up in "typeEnv". The types created are entered in
   "typeEnv" and in "createdTypes". If an entry already exists in typeEnv,
   "duplicate" is signalled. 

   The return value is a type dictionary containing mappings for just
   the types that were contained in the specification.
*/

extern method getClass_method;
/* A method object describing the "getClass" method, which all objects
   provide. This object is not initialized until the FE is booted.
*/

#ifdef __cplusplus
}
#endif

#endif /* _TYPE_INIT_H */
