#include <string.h>
#include "wellknown.h"
#include "types/string_class.h"
#include "cache/cache.h"
#include "cache/gc_register.h"
#include "runtime/except.h"

#include "common/openhashmap.h"
#include "common/hashfuncs.h"

#define string_compare(s1, s2) (!strcmp(s1, s2))

declareOpenHashMap(String_Map, char *, obj *, hash_string, string_compare)
implementOpenHashMap(String_Map, char *, obj *, hash_string, string_compare)

static String_Map *Wellknowns;

void initialize_wellknowns(){
    Wellknowns = new String_Map;
}

void add_wellknown(char* name, obj *objptr) {
    if (!Wellknowns->contains(name)) {
	char *str = (char *) strdup(name);
	Wellknowns->store(str, objptr);
	if (obj_in_heap(*objptr))
	    gc_register_root(objptr);
        else
	    gc_register_meta_root(objptr);
    }
}

any get_wellknown(string name) {
    char *s = (char *) string_charp(name);
    obj *res;
    if (Wellknowns->fetch(s, res))
	return (any) *res;
    exc = &exc_not_found;
    return 0;
}

void update_wellknown(string name, obj* objptr) {
    char *s = (char *) string_charp(name);
    obj res;
    if (Wellknowns->contains(s)) {
	Wellknowns->store(s, objptr);
    } else
        exc = &exc_not_found;
}
