#ifndef _WELLKNOWN_H
#define _WELLKNOWN_H

#include "runtime/obj.h"
#include "common/iter.h"
#include "common/class_code.h"
#include "types/type_def.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void add_wellknown(char *name, obj* ptr);
/* Registers the pointer value in the GC roots also */


extern any get_wellknown(string name);
/* Signals "not_found" if no such well-known object exists.
*/

extern void update_wellknown(string name, obj* ptr);

extern void initialize_wellknowns();
/*
 * Must be called before any calls to "add_wellknown" or "get_wellknown".
 */

extern class_ class_from_code(class_code cc);
/*
    Return the class with this code, or 0 if no such class exists.
*/

#ifdef __cplusplus
}
#endif

#endif /* _WELLKNOWN_H */
