#ifndef _GC_REGISTER_H
#define _GC_REGISTER_H

#include "runtime/obj.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "config/vdefs/QUIT_ON_THRASH.h"
    
void gc_register_root (obj* root);

  /* register "root" so that it is used as a root for garbage collection.
     This implies that "root" may be mutated whenever the gc can run, since
     the referred-to object may move within the cache.
  */

void gc_register_meta_root (obj* root);
/* Same as gc_register_root except that the root is in the meta object heap */

#ifdef __cplusplus
}
#endif

#endif /* _GC_REGISTER_H */
