// Copyright 1995 Barbara Liskov

#include <string.h>
#include "gen-include-1.h"
#include "runtime/surr.h"

#include "types/type_meth.h"
#include "types/string_class.h"
#include "types/textwr.h"
#include "types/vec.h"
#include "types/vec_class.h"
#include "types/class.h"
#include "types/pclass.h"
#include "types/class_class.h"
extern "C" {
#include "types/int.h"
}

extern void decl_temps_wr(wr w, void *vpn);
extern void decl_locals_wr(wr w, void *vpn);

#include "common/openhashset.h"

#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>

/* 
   These routines are largely naive about adding includes for
   types used in method signatures...
*/

/* Definitions for getting the correct include files. */

#define string_compare(x, y) (!strcmp(x, y))

declareOpenHashSet(TypeNmSet, const char *, hash_string, string_compare)
// implementOpenHashSet(TypeNmSet, const char *, hash_string, string_compare)

static void method_Cname(wr w, objtype t, method m, bool meth);
static void gen_meth_inc_inc(wr w, objtype objt, objtype st);
static string gen_spec_inc(objtype t, objtype t2);
static string gen_mkr_spec_inc(method m);
static string gen_rtn_spec_inc(method m);
static string gen_iter_spec_inc(method m, void *vpn);
static string gen_iter_method_spec_inc(objtype c, method m, void *vpn);
static string gen_def_inc(objtype t, objtype t2, objtype deft, bool is_class);
static string gen_meth_inc(objtype t);
static string gen_class_inc(class_ c, class_ c2, objtype st);
static void gen_sc_methods(wr w, objtype sc, objtype root);
static void gen_st_methods(wr w, objtype st);
static bool is_nonptr_type(type t);
static bool mmember(method m, objtype t);
static void gen_dv_tyobjs(wr w, objtype t);
static void gen_iter_typedefs(wr w, objtype t);
static void gen_iter_structs(wr w, objtype t);

static void structName(wr w, objtype t)
{
    wr_putChars(w, "struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "_f_s ");
}

static void dvName(wr w, objtype t)
{
    wr_putChars(w, "struct ");
    wr_putString(w, t->name);
    wr_putChars(w, "dv_s ");
}

static string gen_ifdef_name(const char *fn)
{
    string ifdef_name;
    {
	textwr tw = textwr_new();
	wr w = textwr_as_wr(tw);
	char const *end = fn + strlen(fn) - 1;
	while (end > fn && *end != '/') end--;
	wr_putChar(w, '_');
	while (*end) {
	    if (*end != '.')
	      wr_putChar(w, toupper(*end));
	    else
	      wr_putChar(w, '_');
	    end++;
	}
	ifdef_name = textwr_toString(tw);
    }
    return ifdef_name;
}

void make_include_1(string filename, string contents)
{
    char const *fn = string_charp(filename);
    string filename2 = filename;
    unlink(string_charp(filename2));
    // if (0>unlink(string_charp(filename2))) perror(string_charp(filename2));
    // trying to live without -th and without backup files...
/*
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
	string bakfile = string_concat(filename2, string_new("~"));
	if (0>rename(string_charp(filename2),
		     string_charp(bakfile))) {
	    perror(string_charp(filename2));

	};
    }
*/
    string ifdef_name = gen_ifdef_name(fn);
    FILE *f = fopen(string_charp(filename2), "w");
    fprintf(f, "#ifndef %s\n#define %s\n\n",
	    string_charp(ifdef_name),
	    string_charp(ifdef_name));
    fputs(string_charp(contents), f);
    fprintf(f, "\n#endif /* %s */\n", string_charp(ifdef_name));
    fclose(f);
}

FILE *start_include_1(string fname)
{
string ifdef_name = gen_ifdef_name(string_charp(fname));

    FILE *f = fopen(string_charp(fname), "w");
    fprintf(f, "#ifndef %s\n#define %s\n\n",
	    string_charp(ifdef_name),
	    string_charp(ifdef_name));
    return f;
}

void end_include_1(string fname, FILE *f)
{
string ifdef_name = gen_ifdef_name(string_charp(fname));

    fprintf(f, "\n#endif /* %s */\n", string_charp(ifdef_name));
    fclose(f);
}

void make_rtn_includes_1(method m)
{
   string contents = gen_rtn_spec_inc(m);
   make_include_1(string_concat(m->name, string_new(".h")),
		contents);
}

void make_mkr_includes_1(method m)
{
   string contents = gen_mkr_spec_inc(m);
   make_include_1(string_concat(m->name, string_new(".h")),
		contents);
}

void make_iter_includes_1(method m, void *rd)
{
   string contents = gen_iter_spec_inc(m, rd);
   make_include_1(string_concat(m->name, string_new(".h")),
		contents);
}

void make_iter_method_includes_1(objtype c, method m, void *rd)
{
   string contents = gen_iter_method_spec_inc(c, m, rd);
   make_include_1(string_concat(c->name, string_concat(string_new("M"),
			string_concat(m->name, string_new(".h")))),
		contents);
}


/* Definitions for getting the correct include files. */
void make_includes_1(objtype t, objtype t2, objtype deft)
{
    bool is_class = (t2 == NULL)? FALSE : TRUE;
    string contents = gen_def_inc(t, t2, deft, is_class);
    make_include_1(string_concat(t->name, string_new("_def.h")),
		 contents);
    contents = gen_spec_inc(t, t2);
    make_include_1(string_concat(t->name, string_new(".h")),
		 contents);
}

string gen_def_inc(objtype t, objtype t2, objtype deft, bool is_class)
{
vec mv;
string nm;

    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "DECLARE_");
    if (is_class) wr_putChars(w, "class(");
    else wr_putChars(w, "type(");
    wr_putString(w, t->name);
    wr_putChars(w, ");\n");
    if (is_class) { mv = t2->methods_; nm = t2->name; }
    else { mv = t->methods_; nm = t->name; }
    int nmeth = vec_length(mv);
    for (int i = 0; i < nmeth; i++) {
	    method m = UNPV(method, vec_fetch(mv, i));
	    if (m->iter) {
    		wr_putChars(w, "typedef struct ");
    		wr_putString(w, nm);
    		wr_putChars(w, "M");
    		wr_putString(w, m->name);
    		wr_putChars(w, "_Iter_State_s *");
    		wr_putString(w, nm);
    		wr_putChars(w, "M");
    		wr_putString(w, m->name);
    		wr_putChars(w, "_Iter_State;\n\n");
	// 	if (deft) {
    	// 		wr_putChars(w, "typedef struct ");
    	// 		wr_putString(w, t2->name);
    	// 		wr_putChars(w, "M");
    	// 		wr_putString(w, m->name);
    	// 		wr_putChars(w, "_Iter_State_s *");
    	// 		wr_putString(w, deft->name);
    	// 		wr_putChars(w, "M");
    	// 		wr_putString(w, m->name);
    	// 		wr_putChars(w, "_Iter_State;\n\n");
	// 		}
		}
	    }
    return textwr_toString(tw);
}

static void type_Cname(wr w, type t)
{
    if (t == (type)Null)
	wr_putChars(w, "null");
    else if (t == (type)Real)
	wr_putChars(w, "real");
    else if (t == (type)Type)
	wr_putChars(w, "type");
    else if (t == (type)Class)
	wr_putChars(w, "class_");
    else wr_putString(w, type_name(t));
}

static void type_Cname_short(wr w, type t)
{
    if (t == (type)Null)
	wr_putChars(w, "null");
    else if (type_kind(t) == PARAM_KIND)
	wr_putChars(w, "Pval");
    else if (t == (type)Real)
	wr_putChars(w, "real");
    else if (t == (type)Type)
	wr_putChars(w, "type");
    else if (t == (type)Class)
	wr_putChars(w, "class_");
    else {
	    string cname = type_name(t);
	    const char *cnm = string_charp(cname);
	    char *cptr = index(cnm, '[');
	    if (cptr) cname = string_newn(cnm, cptr-cnm);
	    wr_putString(w, cname);
	 }
}

static void type_ivar_Cname_short(wr w, type t)
{
    if (t == (type)Null)
        wr_putChars(w, "null");
    else if (type_kind(t) == PARAM_KIND)
        wr_putChars(w, "Pval");
    else if (t == (type)Real)
        wr_putChars(w, "real");
    else if (t == (type)Type)
        wr_putChars(w, "type");
    else if (t == (type)Class)
        wr_putChars(w, "class_");
    else if (t == (type)Bool) {
        wr_putChars(w, "th_bool");
	}
    else {
            string cname = type_name(t);
            const char *cnm = string_charp(cname);
            char *cptr = index(cnm, '[');
            if (cptr) cname = string_newn(cnm, cptr-cnm);
            wr_putString(w, cname);
         }
}


static void method_Cname(wr w, objtype t, method m, bool meth)
{
    int l = string_length(m->name);
    bool ends_bang = string_fetch(m->name, l - 1) == '!';

    if (!meth && t) {
	wr_putString(w, t->name);
        wr_putChar(w, 'M');
    }
    if (ends_bang) {
	wr_putChars(w, "change_");
	l--;
    }
    int i;
    for (i=0; i<l; i++) {
	char c = string_fetch(m->name, i);
	wr_putChar(w, c);
    }
}

static void gen_spec_arg(wr w, formal f)
{
//    if (f->t == class_as_type(Null)) return;
    wr_putChars(w, ", ");
    type_Cname_short(w, f->t);
    wr_putChar(w, ' ');
    wr_putString(w, f->name);
}

static void gen_spec_method_args(wr w, method m)
{
    int num_args = vec_length(m->arguments);
    formal *args = (formal *)vec_items(m->arguments);
    int i;
    for (i=0; i<num_args; i++) {
	gen_spec_arg(w, args[i]);
    }
    if (vec_length(m->extra_args)) {
	wr_putChars(w, ", ...");
    }
}

static void gen_spec_C_args(wr w, method m, objtype t)
/* Write out the C arguments to this method. */
{
    // if (m->parameterized) {
    // 	wr_putChars(w, "void *pblock, ");
    // }
    if (t) {
	type_Cname_short(w, objtype_as_type(t));
	wr_putChars(w, " self");
    } else {
	wr_putChars(w, "struct Obj_s *self");
    }
    int num_rets = vec_length(m->returns);
    if (num_rets > 1 && !m->iter) {
	wr_putChars(w, ", Pval *__retvals");
    }
    // if (m->iter) {
    // 	wr_putChars(w, ", struct closure");
    //  }
    gen_spec_method_args(w, m);
}

static void gen_spec_method(wr w, method m, objtype t, bool meth, bool ext)
{
  if (!m->iter) {
    if (!meth) wr_putChars(w, "extern ");
    else wr_putChars(w, "  ");
    int num_rets = vec_length(m->returns);
    switch (num_rets) {
      case 0:
	wr_putChars(w, "void ");
	break;
      default:
	objtype t = UNPV(objtype, vec_fetch(m->returns, 0));
	type_Cname_short(w, objtype_as_type(t));
	wr_putChar(w, ' ');
    }
    if (meth) wr_putChars(w, "(*");
    method_Cname(w, t, m, meth ^ ext);
    if (meth) wr_putChars(w, ")");
    wr_putChar(w, '(');
    gen_spec_C_args(w, m, t);
    wr_putChars(w, ");\n");
    if (!meth && m->spec && strcmp(string_charp(m->spec), "null")) {
	wr_putChars(w, "/*\n");
	wr_putString(w, m->spec);
	wr_putChars(w, "\n*/\n");
    }
  }
  else {
    	if (!meth) {
		wr_putChars(w, "extern ");
		method_Cname(w, t, m, meth);
		wr_putChars(w, "_Iter_State ");
		method_Cname(w, t, m, meth);
		wr_putChars(w, "_START");
		if (t) wr_putChar(w, '_');
		wr_putChar(w, '(');
    		gen_spec_C_args(w, m, t);
    		wr_putChars(w, ");\n");
		wr_putChars(w, "extern bool ");
		method_Cname(w, t, m, meth);
		wr_putChars(w, "_LOOP");
		if (t) wr_putChar(w, '_');
		if (t) {
			wr_putChars(w, "(");
			wr_putString(w, t->name);
			wr_putChars(w, " self, ");
			}
		else wr_putChars(w, "(struct Obj_s *self, ");
		method_Cname(w, t, m, meth);
		wr_putChars(w, "_Iter_State IState);\n");
		return;
		}
    	wr_putChars(w, "  ");
    	method_Cname(w, t, m, FALSE);
    	wr_putChars(w, "_Iter_State ");
    	if (meth) wr_putChars(w, "(*");
    	method_Cname(w, t, m, meth);
    	if (meth) wr_putChars(w, "_START)");
    	wr_putChar(w, '(');
    	gen_spec_C_args(w, m, t);
    	wr_putChars(w, ");\n");
    	wr_putChars(w, "  int ");
    	if (meth) wr_putChars(w, "(*");
    	method_Cname(w, t, m, meth);
    	if (meth) wr_putChars(w, "_LOOP)(");
        if (t) {
		type_Cname_short(w, objtype_as_type(t));
		wr_putChars(w, " self, ");
		}
    	else wr_putChars(w, "struct Obj_s *self, ");
    	method_Cname(w, t, m, FALSE);
    	wr_putChars(w, "_Iter_State IState);\n");
    	if (!meth && m->spec && strcmp(string_charp(m->spec), "null")) {
		wr_putChars(w, "/*\n");
		wr_putString(w, m->spec);
		wr_putChars(w, "\n*/\n");
    		}
	}
}

static void gen_spec_mkr(wr w, method m)
{
    wr_putChars(w, "extern ");
    wr_putChars(w, "void ");


    method_Cname(w, 0, m, FALSE);
    wr_putChar(w, '(');

    objtype t = UNPV(objtype, vec_fetch(m->returns, 0));
/*
    type_Cname_short(w, objtype_as_type(t));
    wr_putChars(w, " self");
    if (vec_length(m->arguments)) wr_putChars(w, ", ");
*/

    gen_spec_C_args(w, m, t);
    wr_putChars(w, ");\n");
}

static void gen_spec_method_(wr w, method m, objtype t, objtype st, bool meth)
{
    // The usage of this routine should be reviewed...
    // currently only called with meth = FALSE...
    if (m->iter) {
	if (meth) { wr_putChars(w, "losing..."); return; }
	wr_putChars(w, "extern ");
        method_Cname(w, t, m, meth);
        wr_putChars(w, "_Iter_State ");
        method_Cname(w, t, m, meth);
        wr_putChars(w, "_START");
        if (t) wr_putChar(w, '_');
        wr_putChar(w, '(');
    	if (st) gen_spec_C_args(w, m, st);
    	else gen_spec_C_args(w, m, t);
        wr_putChars(w, ");\n");
        wr_putChars(w, "extern bool ");
        method_Cname(w, t, m, meth);
        wr_putChars(w, "_LOOP");
        if (t) wr_putChar(w, '_');
        wr_putChars(w, "(");
  	if (t) {
        	type_Cname_short(w, objtype_as_type(t));
        	wr_putChars(w, " self, ");
    	} else {
       		wr_putChars(w, "struct Obj_s *self, ");
    	}
	// seems superfluous 1/9/97 dwc
        // wr_putChars(w, "self, ");
        method_Cname(w, t, m, meth);
        wr_putChars(w, "_Iter_State IState);\n");
  	}
    else {
    	if (!meth) wr_putChars(w, "extern ");
    	else wr_putChars(w, "  ");
    	int num_rets = vec_length(m->returns);
    	switch (num_rets) {
      	case 0:
		wr_putChars(w, "void ");
		break;
      	default:
		objtype t = UNPV(objtype, vec_fetch(m->returns, 0));
		type_Cname_short(w, objtype_as_type(t));
	wr_putChar(w, ' ');
    	}
    	if (meth) wr_putChars(w, "(*");
    	method_Cname(w, t, m, meth);
    	wr_putChars(w, "_");
    	if (meth) wr_putChars(w, ")");
    	wr_putChar(w, '(');
    	if (st) gen_spec_C_args(w, m, st);
    	else gen_spec_C_args(w, m, t);
    	wr_putChars(w, ");\n");
    	if (!meth && m->spec && strcmp(string_charp(m->spec), "null")) {
		wr_putChars(w, "/*\n");
		wr_putString(w, m->spec);
		wr_putChars(w, "\n*/\n");
    		}
    }
}

string gen_spec_inc(objtype t, objtype t2)
{
int num_methods;
int i;
method *m;

    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "#include \"");
    wr_putString(w, t->name);
    wr_putChars(w, "_def.h\"\n");
    // The following is a hack and should be replaced by
    // 	includes for all types used in signatures...
    objtype tt = t2? t2: t;
    int nst = vec_length(tt->supertypes_);
    objtype st;
    if (nst) st = UNPV(objtype, vec_fetch(tt->supertypes_, 0));
    else st = 0;
    if (st && st != Any) {
      wr_putChars(w, "#include \"");
      wr_putString(w, st->name);
      wr_putChars(w, ".h\"\n");
    }
    exc = EXC_NONE;
    class_ c = objtype_as_class(t);
    if (exc) c = 0;
    exc = EXC_NONE;
    if (c) {
    	class_ sc = class_superclass(c);
    	if (exc) {
		sc = 0;
		exc = EXC_NONE;
    	} else {
		FIX(sc, class_);
    	}
    	if (sc) {
      		wr_putChars(w, "#include \"");
      		wr_putString(w, sc->hdr.inh.name);
      		wr_putChars(w, ".h\"\n\n");
      		}
      	}
    if (t2) {
    	wr_putChars(w, "#include \"");
    	wr_putString(w, t->name);
    	wr_putChars(w, "_inc.h\"\n");
        int num_methods = vec_length(t2->methods_);
    	m = (method *)vec_items(t2->methods_);
    	for (i = 0; i < num_methods; i++) {
		if (!m[i]->iter) continue;
		wr_putChars(w, "#include \"");
    		wr_putString(w, t2->name);
		wr_putChars(w, "M");
    		wr_putString(w, m[i]->name);
		wr_putChars(w, ".h\"\n");
    		}
	}
    gen_meth_inc_inc(w, t, st);
    wr_putChars(w, "\n");
    wr_putChars(w, "#include \"runtime/C/dummy_class.h\"\n");
    wr_putChars(w, "extern ");
    exc = EXC_NONE;
    c = objtype_as_class(t);
    if (exc) wr_putChars(w, "struct Objtype_s *");
    else wr_putChars(w, "struct Class_s *");
    exc = EXC_NONE;
    wr_putString(w, t->name);
    wr_putChars(w, "_V;\n\n");
    if (t2); // removed 12/4/96 dwc gen_iter_typedefs(w, t);
    else gen_iter_structs(w, t);

    num_methods = vec_length(t->methods_);
    m = (method *)vec_items(t->methods_);
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    if (t && t->overview && !string_empty_(t->overview) && 
		strcmp("null", string_charp(t->overview))) {
    	wr_putChars(w, "/*\n");
    	wr_putString(w, t->overview);
    	wr_putChars(w, "\n*/\n");
	}
    for (i = 0; i < num_methods; i++) {
	gen_spec_method(w, m[i], t, FALSE, FALSE);
    }

// relocated from gen_class_inc to be inside extern C clause
    if (t2) {
    	num_methods = vec_length(t2->methods_);
    	m = (method *)vec_items(t2->methods_);
    	for (i = 0; i < num_methods; i++) {
        	gen_spec_method_(w, m[i], t2, 0, FALSE);
		}
	}

    wr_putChars(w, "\nextern void Init_");
    wr_putString(w, t->name);
    wr_putChars(w, "();\n");
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n\n");
    string contents = gen_meth_inc(t);
    wr_putString(w, contents);

    class_ c2 = NULL;
    if (t2) c2 = objtype_as_class(t2);
    exc = EXC_NONE;


    objtype t3 = t2? t2: t;
    wr_putChars(w, "\nstruct ");
    wr_putString(w, t3->name);
    if (t2) wr_putChars(w, "_class_DV {\n");
    else wr_putChars(w, "_DV {\n");
    if (t2) {
	class_ t2c = type_as_class(objtype_as_type(t2));
	vec scs = t2c->superclass;
	objtype sc = scs? UNPV(objtype, vec_fetch(scs, 0)): 0;
    	num_methods = vec_length(t->methods_);
    	m = (method *)vec_items(t->methods_);
    	for (i = 0; i < num_methods; i++) {
      		if (!mmember(m[i], t)) continue;
      		gen_spec_method(w, m[i], t, TRUE, FALSE);
      		}
    	if (sc) gen_sc_methods(w, sc, t2);
	}
    wr_putChars(w, "  struct DV_hdr_s hdr;\n");
    wr_putChars(w, "  struct Class_s *(*get_class)(struct Obj_s *);\n");
    gen_st_methods(w, st);
    for (i = 0; i < num_methods; i++) {
      if (mmember(m[i], t)) continue;
      gen_spec_method(w, m[i], t, TRUE, FALSE);
      }
    if (!t2) {
    	num_methods = vec_length(t->methods_);
    	m = (method *)vec_items(t->methods_);
    	for (i = 0; i < num_methods; i++) {
      		if (!mmember(m[i], t)) continue;
      		gen_spec_method(w, m[i], t, TRUE, FALSE);
      		}
	}
    wr_putChars(w, "};\n");

    if (t2) {
    	wr_putChars(w, "\nstruct ");
    	wr_putString(w, t3->name);
    	wr_putChars(w, "_DV {\n");
    	wr_putChars(w, "  struct DV_hdr_s hdr;\n");
    	wr_putChars(w, "  struct Class_s *(*get_class)(struct Obj_s *);\n");
    	gen_st_methods(w, st);
    	for (i = 0; i < num_methods; i++) {
      		if (mmember(m[i], t)) continue;
		gen_spec_method(w, m[i], t, TRUE, FALSE);
      		}
    	wr_putChars(w, "};\n");
	}

    c = objtype_as_class(t);
    if (exc) {
	exc = EXC_NONE;
	return textwr_toString(tw);
    }

    contents = gen_class_inc(c, c2, st);
    wr_putString(w, contents);

    return textwr_toString(tw);
}

void gen_dv_tyobjs(wr w, objtype t)
{
TypeNmSet types_used;
int i;
const char *slf_nm = string_charp(typeExtNm2SimpleNm(
		type_name(objtype_as_type(t))));

    class_ c = objtype_as_class(t);
    if (exc) {
	exc = EXC_NONE;
	return;
    }

    types_used.insert(string_charp(typeExtNm2SimpleNm(type_name(
			class_as_type(c)))));
    int l = vec_length(c->fields);
    formal *fields = (formal *)vec_items(c->fields);
    for (i = 0; i < l; i++) {
        formal f = fields[i];
        if (!is_nonptr_type(f->t)) {
	        types_used.insert(string_charp(typeExtNm2SimpleNm(
			type_name(f->t))));
		}
    }
    for (TypeNmSet::Elements each(&types_used); each.ok(); each.next()) {
	const char *included_tnm = each.get();
	if (!strcmp(included_tnm, slf_nm)) continue;
        wr_putChars(w, "  struct Class_s *Type_object_");
	wr_putChars(w, included_tnm);
        wr_putChars(w, ";\n");
	}
    
}

void gen_meth_inc_inc(wr w, objtype objt, objtype st)
{
    TypeNmSet types_used;
    int i, j, k;

    int num_methods = vec_length(objt->methods_);
    method *mp = (method *)vec_items(objt->methods_);
    for (i = 0; i < num_methods; i++) {
      method m = mp[i];
      if (vec_length(m->arguments)) {
	for (j = 0; j < vec_length(m->arguments); j++) {
		formal f = UNPV(formal, vec_fetch(m->arguments, j));
		if (type_kind(f->t) == PARAM_KIND) continue;
		objtype ot = type_as_objtype(f->t);
		if (ot == objt || ot == st) continue;
	        types_used.insert(string_charp(typeExtNm2SimpleNm(
			type_name(f->t))));
		}
	}
      if (vec_length(m->returns)) {
	for (j = 0; j < vec_length(m->returns); j++) {
		type t = UNPV(type, vec_fetch(m->returns, j));
		if (type_kind(t) == PARAM_KIND) continue;
		objtype ot = type_as_objtype(t);
		if (ot == objt || ot == st) continue;
	        types_used.insert(string_charp(typeExtNm2SimpleNm(
			type_name(t))));
		}
	}
      if (vec_length(m->signals)) {
	for (j = 0; j < vec_length(m->signals); j++) {
		signal_ s = UNPV(signal_, vec_fetch(m->signals, j));
		if (vec_length(s->returns)) {
			for (k = 0; k < vec_length(s->returns); k++) {
				type t = UNPV(type, vec_fetch(s->returns, k));
				if (type_kind(t) == PARAM_KIND) continue;
				objtype ot = type_as_objtype(t);
				if (ot == objt || ot == st) continue;
	        		types_used.insert(string_charp(
					typeExtNm2SimpleNm( type_name(t))));
				}
			}
		}
	}
    }
    for (TypeNmSet::Elements each(&types_used); each.ok(); each.next()) {
	const char *included_tnm = each.get();
	wr_putChars(w, "#include \"");
	wr_putChars(w, included_tnm);
	wr_putChars(w, ".h\"\n");
	}
}

// seems to have lots its purpose...
string gen_meth_inc(objtype t)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    int nst = vec_length(t->supertypes_);
    objtype st;
    if (nst) st = UNPV(objtype, vec_fetch(t->supertypes_, 0));
    else st = 0;
//    /*
//       Note that as currently defined, the methods of "t" are
//       congruent with the methods of its first direct supertype.
//    */
//    if (st && st != Any) {
//      wr_putChars(w, "#include \"");
//      wr_putString(w, st->name);
//      wr_putChars(w, "_meth.h\"\n");
//    }
//    wr_putChars(w, "#include \"");
//    wr_putString(w, t->name);
//    wr_putChars(w, ".h\"\n");
// seems to be a duplicate for now 8/8/96
//  gen_meth_inc_inc(w, t, st);
//  wr_putChars(w, "#include \"runtime/obj_class.h\"\n\n");
//    wr_putChars(w, "struct ");
//    wr_putString(w, t->name);
//    wr_putChars(w, "_DV {\n");
//    wr_putChars(w, "  struct ");
//    if (st && st != Any) {
//      wr_putString(w, st->name);
//      wr_putChars(w, "_DV hdr;\n");
//    }
//    else {
//      wr_putChars(w, "Obj_DV hdr;\n");
//    }

//  int num_methods = vec_length(t->methods_);
//  method *m = (method *)vec_items(t->methods_);
//  int i;
//  for (i = 0; i < num_methods; i++) {
//    gen_spec_method(w, m[i], t, TRUE);
//  }
//  wr_putChars(w, "};\n");

//    num_methods = vec_length(t->methods_);
//    m = (method *)vec_items(t->methods_);
//    wr_putChars(w, "\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");

    return textwr_toString(tw);
}

string gen_class_inc(class_ c, class_ c2, objtype st)
{
    FIX(c, class_);
    textwr tw = textwr_new();
    objtype t = class_as_objtype(c);
    wr w = textwr_as_wr(tw);
    wr_putChar(w, '\n');
    class_ sc = class_superclass(c);
    if (exc) {
	sc = 0;
	exc = EXC_NONE;
    } else {
	FIX(sc, class_);
    }
    if (sc) {
      wr_putChars(w, "#include \"");
      wr_putString(w, sc->hdr.inh.name);
      wr_putChars(w, ".h\"\n\n");
      }

    if (!c->special) {
	formal *fields = (formal *)vec_items(c->fields);
	int l = vec_length(c->fields);
	int i;
	TypeNmSet types_used;
	for (i = 0; i < l; i++) {
	    formal f = fields[i];
	    types_used.insert(string_charp(typeExtNm2SimpleNm(type_name(f->t))));
	}
        for (TypeNmSet::Elements each(&types_used); each.ok(); each.next()) {
            const char *included_tnm = each.get();
            wr_putChars(w, "#include \"");
	    wr_putChars(w, included_tnm);
            wr_putChars(w, ".h\"\n");
        }
    }

    wr_putChar(w, '\n');
    structName(w, t);
    wr_putChars(w, "{\n");

//    wr_putChars(w, "  union {\n");

    if (sc) {
	wr_putChars(w, "  ");
	structName(w, class_as_objtype(sc));
	wr_putChars(w, " inh;\n");
    } else {
	wr_putChars(w, "  struct Fields_s inh;\n");
    }
//    wr_putChars(w, "    struct ");
//    wr_putString(w, t->name);
//    wr_putChars(w, "dv_s *methods;\n");
//    wr_putChars(w, "  } hdr;\n");
    if (c->special) {
	wr_putString(w, c->specialText);
    } else {
	int l = vec_length(c->fields);
	int i;
	int skip;
	if (sc) {
	    skip = vec_length(sc->fields);
	} else {
	    skip = 0;
	}
	formal *fields = (formal *)vec_items(c->fields);
	// for (i = skip; i < l; i++) {
	for (i = 0; i < l; i++) {
	    formal f = fields[i];
	    wr_putChars(w, "  ");
	    if (is_nonptr_type(f->t)) type_ivar_Cname_short(w, f->t);
	    else wr_putChars(w, "Shortp");
	    wr_putChar(w, ' ');
	    wr_putString(w, f->name);
	    wr_putChars(w, ";\n");
	}
    }
    wr_putChars(w, "};\n\n");

    objtype c3 = c2? class_as_objtype(c2): class_as_objtype(c);

// removed 11/13/96 dcurtis: seems useless and conflicts with other
//	definitions (bothers g++, not gcc)
//     wr_putChars(w, "typedef struct ");
//     wr_putString(w, c3->name);
//     wr_putChars(w, "_DV " );
//     wr_putString(w, c3->name);
//     wr_putChars(w, "_class_DV;\n" );

    return textwr_toString(tw);
}

static string gen_rtn_spec_inc(method m)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "\n#include \"runtime/C/dummy_class.h\"\n\n");
    wr_putChars(w, "DECLARE_class(");
    wr_putString(w, m->name);
    wr_putChars(w, "_Rtn_Class);\n\n");
    wr_putChars(w, "#include \"");
    wr_putString(w, m->name);
    wr_putChars(w, "_inc.h\"\n");
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    gen_spec_method(w, m, 0, FALSE, FALSE);
    wr_putChars(w, "extern ");
    wr_putChars(w, "struct Obj_s *");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_Rtn_Class_Obj;\n");
    wr_putChars(w, "extern void Init_");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_Rtn_class();\n");
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n");
    wr_putChars(w, "struct ");
    wr_putString(w, m->name); 
    wr_putChars(w, "_Rtn_Class_class_DV {\n");
    wr_putChars(w, "  struct DV_hdr_s hdr;\n");
    wr_putChars(w, "  struct Class_s *(*get_class)(struct Obj_s *);\n");
    gen_spec_method(w, m, 0, TRUE, FALSE);
    wr_putChars(w, "};\n");

    return textwr_toString(tw);
}

static string gen_iter_spec_inc(method m, void *rd)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "\n#include \"runtime/C/dummy_class.h\"\n\n");
    wr_putChars(w, "DECLARE_class(");
    wr_putString(w, m->name);
    wr_putChars(w, "_Rtn_Class);\n\n");
    wr_putChars(w, "#include \"");
    wr_putString(w, m->name);
    wr_putChars(w, "_inc.h\"\n");
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    wr_putChars(w, "extern ");
    if (m->self_type) type_Cname_short(w, m->self_type);
    else wr_putChars(w, "struct Obj_s *");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_Rtn_Class_Obj;\n");
    wr_putChars(w, "extern void Init_");
    wr_putString(w, m->name);      // possibly should be methodCname...
    wr_putChars(w, "_Rtn_class();\n\n");
    wr_putChars(w, "struct ");
    wr_putString(w, m->name);
    wr_putChars(w, "_Iter_State_s {\n");
    wr_putChars(w, "int pc;\n");
    wr_putChars(w, "int spare;\n");
    for (int i = 0; i < vec_length(m->returns); i++) {
	type t = UNPV(type, vec_fetch(m->returns, i));
	wr_putString(w, type_name(t));
	wr_putChars(w, " ret_");
	wr_putString(w, int_unparse(i));
	wr_putChars(w, ";\n");
	}
    for (int i = 0; i < vec_length(m->arguments); i++) {
	formal f = UNPV(formal, vec_fetch(m->arguments, i));
	wr_putString(w, type_name(f->t));
	wr_putChars(w, " ");
	wr_putString(w, f->name);
	wr_putChars(w, ";\n");
	}
    decl_locals_wr(w, rd);
    decl_temps_wr(w, rd);
    wr_putChars(w, "};\n");
    wr_putChars(w, "typedef struct ");
    wr_putString(w, m->name);
    wr_putChars(w, "_Iter_State_s *");
    wr_putString(w, m->name);
    wr_putChars(w, "_Iter_State;\n");
    gen_spec_method(w, m, 0, FALSE, FALSE);
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n");
    wr_putChars(w, "struct ");
    wr_putString(w, m->name); 
    wr_putChars(w, "_Rtn_Class_class_DV {\n");
    wr_putChars(w, "  struct DV_hdr_s hdr;\n");
    wr_putChars(w, "  struct Class_s *(*get_class)(struct Obj_s *);\n");
    gen_spec_method(w, m, 0, TRUE, FALSE);
    wr_putChars(w, "};\n");
    return textwr_toString(tw);
}

string gen_mkr_spec_inc(method m)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "\n#include \"");
    type_Cname_short(w,  m->self_type);
    wr_putChars(w, ".h\"\n\n");
    wr_putChars(w, "#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
    gen_spec_mkr(w, m);
    wr_putChars(w, "\n#ifdef __cplusplus\n}\n#endif\n");
    return textwr_toString(tw);
}

static bool is_nonptr_type(type t)
{
	const char *nm = string_charp(type_name(t));
	if (!strcmp(nm, "bool")) return TRUE;
	if (!strcmp(nm, "null")) return TRUE;
	if (!strcmp(nm, "char")) return TRUE;
	if (!strcmp(nm, "int")) return TRUE;
	if (!strcmp(nm, "real")) return TRUE;
	return FALSE;
	}

static bool mmember(method m, objtype t)
{
	int num_methods = vec_length(t->methods_);
	method *mi = (method *)vec_items(t->methods_);
	for (int i = 0; i < num_methods; i++) {
		method ithm = mi[i];
		if (string_equal(m->name, ithm->name)) return TRUE;
		}
	return FALSE;
	}

bool tmember(wr w, method m, objtype root)
{
	if (!root) return FALSE;
	if (root == Any) return FALSE;
	if (root->supertypes_ && vec_length(root->supertypes_)) {
		objtype sst = UNPV(objtype, vec_fetch(root->supertypes_, 0));
        	if (tmember(w, m, sst)) return TRUE;
		}
	if (root->methods_ && vec_length(root->methods_)) {
		int n = vec_length(root->methods_);
		for (int i = 0; i < n; i++) {
			method ithm = UNPV(method, vec_fetch(root->methods_,i));
			if (string_equal(m->name, ithm->name)) return TRUE;
			}
		}
	return FALSE;
	}

bool pmember(wr w, method m, objtype root)
{
	if (!root) return FALSE;
	if (root == Any) return FALSE;
	if (root->supertypes_ && vec_length(root->supertypes_)) {
		objtype sst = UNPV(objtype, vec_fetch(root->supertypes_, 0));
        	if (tmember(w, m, sst)) return TRUE;
		}
/*
	if (root->methods_ && vec_length(root->methods_)) {
		int n = vec_length(root->methods_);
		for (int i = 0; i < n; i++) {
			method ithm = UNPV(method, vec_fetch(root->methods_,i));
			if (string_equal(m->name, ithm->name)) return TRUE;
			}
		}
*/
	return FALSE;
	}

bool fmember(wr w, method m, objtype root, objtype stop)
{
	// wr_putChars(w, "considering ");
        // wr_putString(w, m->name);
	// wr_putChars(w, " with root ");
        // wr_putString(w, root->name);
	// wr_putChars(w, " with stop ");
        // wr_putString(w, stop->name);
	// wr_putChars(w, "\n");
	if (root == stop) return FALSE;
        // wr_putString(w, m->name);
	// wr_putChars(w, " passed stop");
	// wr_putChars(w, "\n");
	if (root && mmember(m, root)) return TRUE;
        // wr_putString(w, m->name);
	// wr_putChars(w, " passed mmember");
	// wr_putChars(w, "\n");
	class_ rootc = root? objtype_as_class(root): 0;
	int num = rootc && rootc->superclass? vec_length(rootc->superclass): 0;
	objtype sprc = num ? UNPV(objtype, vec_fetch(rootc->superclass, 0)): 0;
	if (sprc) {
		// wr_putChars(w, "recursing on ");
        	// wr_putString(w, sprc->name);
		// wr_putChars(w, "\n");
		if (fmember(w, m, sprc, stop)) return TRUE;
		}
	return FALSE;
	}

static void gen_sc_methods(wr w, objtype sc, objtype root)
{
	if (!sc) return;
	if (sc == Any) return;
	// wr_putString(w, type_name(objtype_as_type(sc)));
	// wr_putChars(w, " class name\n");
	exc = EXC_NONE;
	class_ scc = objtype_as_class(sc);
	if (exc) {exc = EXC_NONE; return;}
	if (sc->methods_ && vec_length(sc->methods_)) {
		int n = vec_length(sc->methods_);
		// wr_putString(w, int_unparse(n));
		// wr_putChars(w, " method count\n");
		for (int i = 0; i < n; i++) {
			bool ext = FALSE;
			method m = UNPV(method, vec_fetch(sc->methods_, i));
			if (pmember(w, m, root)) continue;
			if (fmember(w, m, root, sc)) {
				// wr_putChars(w, "ext is true\n");
				ext = TRUE;
				}
			// 3/20/97 dwc: turned this check off so that *all*
			// private methods show up!
			// if (fmember(w, m, root, sc)) continue;
			if (sc == root) continue;
			// The following clause is currently necessary
			// but it suggests that the superclass methods
			// are not being calculated correctly by the
			// compiler.
			if (!strcmp("getClass", string_charp(m->name)))
				continue;
			gen_spec_method(w, m, sc, TRUE, ext);
			}
		}
	if (scc->superclass && vec_length(scc->superclass)) {
		objtype ssc = UNPV(objtype, vec_fetch(scc->superclass, 0));
		// wr_putChars(w, " recursing with ");
		// wr_putString(w, type_name(objtype_as_type(ssc)));
		// wr_putChars(w, " super class name\n");
        	gen_sc_methods(w, ssc, root);
		}
	// wr_putChars(w, "end of gen_sc_m\n");

	}

static void gen_st_methods(wr w, objtype st)
{
	if (!st) return;
	if (st == Any) return;
	if (st->supertypes_ && vec_length(st->supertypes_)) {
		objtype sst = UNPV(objtype, vec_fetch(st->supertypes_, 0));
		// wr_putChars(w, " recursing\n");
        	gen_st_methods(w, sst);
		}
	if (st->methods_ && vec_length(st->methods_)) {
		int n = vec_length(st->methods_);
		for (int i = 0; i < n; i++) {
			method m = UNPV(method, vec_fetch(st->methods_, i));
			gen_spec_method(w, m, st, TRUE, FALSE);
			}
		}
	}

static void gen_iter_typedefs(wr w, objtype t)
{
int nmeths = vec_length(t->methods_);

	for (int i = 0; i < nmeths; i++) {
		method m = UNPV(method, vec_fetch(t->methods_, i));
		if (m->iter) {
			wr_putChars(w, "#include \"");
   			wr_putString(w, t->name);
			wr_putChars(w, "M");
			wr_putString(w, m->name);
			wr_putChars(w, ".h\"\n");
			wr_putChars(w, "typedef struct ");
			method_Cname(w, t, m, FALSE);
			wr_putChars(w, "_Iter_State_s *");
			method_Cname(w, t, m, FALSE);
			wr_putChars(w, "_Iter_State;\n");
			};
		}
	}

static void gen_iter_structs(wr w, objtype t)
{
int nmeths = vec_length(t->methods_);

	for (int i = 0; i < nmeths; i++) {
		method m = UNPV(method, vec_fetch(t->methods_, i));
		if (m->iter) {
			wr_putChars(w, "struct ");
    			wr_putString(w, t->name);
    			wr_putChars(w, "M");
    			wr_putString(w, m->name);
    			wr_putChars(w, "_Iter_State_s {\n");
    			wr_putChars(w, "int pc;\n");
    			wr_putChars(w, "int spare;\n");
    			for (int i = 0; i < vec_length(m->returns); i++) {
				type t = UNPV(type, vec_fetch(m->returns, i));
				wr_putString(w, type_name(t));
				wr_putChars(w, " ret_");
				wr_putString(w, int_unparse(i));
				wr_putChars(w, ";\n");
				}
			wr_putChars(w, "};\n\n");
			}
		}
	}

static string gen_iter_method_spec_inc(objtype c, method m, void *rd)
{
    textwr tw = textwr_new();
    wr w = textwr_as_wr(tw);
    wr_putChars(w, "\n#include \"");
    type_Cname_short(w, objtype_as_type(c));
    wr_putChars(w, "_inc.h\"\n\n");
    wr_putChars(w, "struct ");
    wr_putString(w, c->name);
    wr_putChars(w, "M");
    wr_putString(w, m->name);
    wr_putChars(w, "_Iter_State_s {\n");
    wr_putChars(w, "int pc;\n");
    wr_putChars(w, "int spare;\n");
    for (int i = 0; i < vec_length(m->returns); i++) {
	type t = UNPV(type, vec_fetch(m->returns, i));
	wr_putString(w, type_name(t));
	wr_putChars(w, " ret_");
	wr_putString(w, int_unparse(i));
	wr_putChars(w, ";\n");
	}
    for (int i = 0; i < vec_length(m->arguments); i++) {
	formal f = UNPV(formal, vec_fetch(m->arguments, i));
	wr_putString(w, type_name(f->t));
	wr_putChars(w, " ");
	wr_putString(w, f->name);
	wr_putChars(w, ";\n");
	}
    decl_locals_wr(w, rd);
    decl_temps_wr(w, rd);
    wr_putChars(w, "};\n\n");
    return textwr_toString(tw);
    }
