/*  Copyright 1995 Barbara Liskov */

#ifndef _GEN_INCLUDE_1_H
#define _GEN_INCLUDE_1_H

#ifdef __cplusplus
extern "C" {
#endif

#include "types/str.h"
#include "types/type_def.h"
#include "types/textwr.h"
#include <stdio.h>

/* NUKE: not external interface...
string gen_def_inc(objtype t);
string gen_spec_inc(objtype t);
string gen_meth_inc(objtype t);
string gen_mkr_spec_inc(method m);
string gen_class_inc(class_ c, class_ c2);
string gen_rtn_spec_inc(method m);
string gen_class_impl(class_ c);
*/

void make_includes_1(objtype t, objtype t2, objtype deft);
/*
   Produce the appropriate include files for type "t".
   "t" has only private methods.  "t2" is equivalent but with full methods.
   "deft" is the defining type for a class.
*/

void make_rtn_includes_1(method m);
/*
   Produce the appropriate include files for routine described by method "m".
*/

void make_mkr_includes_1(method m);
/*
   Produce the appropriate include files for maker described by method "m".
*/

void make_iter_includes_1(method m, void *rd);
/*
   Produce the appropriate include files for iter described by method "m".
*/

void make_include(string filename, string contents);
/*
   Produce a specific include file.
*/

void make_iter_method_includes_1(objtype c, method m, void *rd);
/*
  Produce the include file for a class's method that is an iterator.
*/

FILE *start_include_1(string fname);

void end_include_1(string fname, FILE *f);

bool fmember(wr w, method m, objtype root, objtype stop);
/*
  Returns TRUE if m is a member of root, superclass recursion stops
  at stop.  If not a member, returns FALSE.
*/

bool tmember(wr w, method m, objtype root);
/*
  Returns TRUE if m is a member of root (via supertypes).
  If not a member, returns FALSE.
*/

  
#ifdef __cplusplus
}
#endif

#endif /* _GEN_INCLUDE_1_H */
