/*  Copyright 1995 Barbara Liskov */

#ifndef _GEN_INCLUDE_H
#define _GEN_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "types/str.h"
#include "types/type_def.h"

string gen_def_inc(objtype t);
string gen_spec_inc(objtype t);
string gen_meth_inc(objtype t);
string gen_mkr_spec_inc(method m);
string gen_class_inc(class_ c, class_ c2);
string gen_rtn_spec_inc(method m);

/*
   Generate the contents of the four standard kinds of include files for
   a type or class.
*/

string gen_class_impl(class_ c);
/*
   Generate a C source file that partially implements "c".
*/

void make_includes(objtype t, objtype t2);
/*
   Produce the appropriate include files for type "t".
   "t" has only private methods.  "t2" is equivalent but with full methods.
*/

void make_rtn_includes(method m);
/*
   Produce the appropriate include files for routine described by method "m".
*/

void make_mkr_includes(method m);
/*
   Produce the appropriate include files for maker described by method "m".
*/

void make_include(string filename, string contents);
/*
   Produce a specific include file.
*/
  
#ifdef __cplusplus
}
#endif

#endif /* _GEN_INCLUDE_H */
