/*
\section{Bit-Fields of various Sizes}

This file contains definitions of bitfields of various sizes.  The
definitions vary by compiler and architectures.  The unsigned types
defined here are "Ubits8", "Ubits16", "Ubits32", and "Ubits64".  
Note that unsigned arithmetic can lead to unexpected results.

This header file is C-compatible.
*/

#ifndef _BITS_H
#define _BITS_H

#define byte_bits 8
typedef unsigned int  Uint;

typedef unsigned char  Ubits8;
typedef unsigned short Ubits16;
typedef unsigned int   Ubits32;

typedef char  Bits8;
typedef short Bits16;
typedef int   Bits32;

#define bits32 Bits32
#define ubits32 Ubits32
#define bits64 Bits64
#define ubits64 Ubits64

#ifdef __alpha

#define LONG_SIGN_BIT_MASK 0x8000000000000000UL
#define INT_SIGN_BIT_MASK 0x80000000UL

#define INT_BITS 32
#define LONG_BITS 64

#define _BITS_H_OK
#endif

#if defined mips || defined __linux__

#define LONG_SIGN_BIT_MASK 0x80000000UL
#define INT_SIGN_BIT_MASK 0x80000000UL

#define INT_BITS 32
#define LONG_BITS 32



/* XXX _Will we ultimately want an R4000 variant of "bits64"?_ */

#define _BITS_H_OK
#endif

#include "ubits64.h"

#ifndef _BITS_H_OK
#error "bits.h" does not know about this machine architecture.
#endif
#undef _BITS_H_OK

#endif
