/*
\section{Compatibility Header File}

This file isolates Thor source code from incompatibilities between
various operating systems.  The basic idea is that the "configure"
shell script figures out various properties of the operating system
and writes them into the "config.h" file.  We include the "config.h"
file here and use the macros defined in there to provide a common
portable interface to potentially incompatible features.
*/

#ifndef _COMPAT_H
#define _COMPAT_H

/*** define SPARC for sunstations ***/
#if defined(sun) && defined(sparc)
#define SPARC
#define mach_type_known
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <setjmp.h>
#include <netinet/in.h>

#ifdef HAVE_MACHINE_ENDIAN_H
#include <machine/endian.h>
#endif

#include <netdb.h>

#include "config/config.h"

#ifndef SOCK_STREAM
#include <sys/socket.h>
#endif

/* "getclock()" */
#define TIMEOFDAY 1
#ifdef HAVE_GETCLOCK
#include <timers.h>
#else
struct timespec;
#endif /* HAVE_GETCLOCK */
extern int getclock(int clk, struct timespec* sp);

/* "UIO_MAXIOV" */
#ifndef UIO_MAXIOV
#define UIO_MAXIOV 1024
#endif

#ifndef HAVE_GETOPT_PROTO
extern int   getopt(int, char* const*, const char*);
extern char* optarg;
extern int   optind;
extern int   opterr;
#endif

#ifndef HAVE_RANDOM_PROTO
extern int random(void);
#endif

#ifdef __alpha__
#define HAVE_GETHOSTID_PROTO
#endif

#ifndef HAVE_GETHOSTID_PROTO
extern long gethostid(void);
#endif

#ifndef HAVE_GETDTABLESIZE_PROTO
extern int getdtablesize(void);
#endif

#ifndef HAVE_SELECT_PROTO
extern int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif

#ifndef HAVE_FSYNC_PROTO
extern int fsync(int);
#endif

#ifndef HAVE_GETHOSTNAME_PROTO
extern int gethostname(char*, int);
#endif

#ifndef HAVE_WRITEV_PROTO
extern int writev(int, struct iovec*, int);
#endif

#ifndef HAVE_GETTIMEOFDAY_PROTO
extern int gettimeofday(struct timeval*, struct timezone*);
#endif

#ifndef HAVE_SHMGET_PROTO
extern int shmget(key_t, u_int, u_int);
#endif

#ifndef HAVE__SETJMP_PROTO
/* extern int _setjmp(jmp_buf); */
#endif

#ifndef HAVE__LONGJMP_PROTO
extern void _longjmp(jmp_buf, int);
#endif

#ifndef HAVE_STRERROR_PROTO
extern char* strerror(int);
#endif

#ifndef HAVE_BZERO_PROTO
extern void bzero(void*, int);
#endif

#ifndef HAVE_BCOPY_PROTO
extern void bcopy(void*, void*, int);
#endif

#ifndef HAVE_BCMP_PROTO
extern int bcmp(void*, void*, int);
#endif

#ifndef HAVE_HTONL_PROTO
extern unsigned short htons(unsigned short);
extern unsigned long  htonl(unsigned long);
extern unsigned short ntohs(unsigned short);
extern unsigned long  ntohl(unsigned long);
#endif

#ifndef HAVE_SOCKET_PROTO
extern int socket(int, int, int);
#endif

#ifndef HAVE_SETSOCKOPT_PROTO
extern int setsockopt(int, int, int, void*, int);
#endif

#ifndef HAVE_BIND_PROTO
extern int bind(int, struct sockaddr*, int);
#endif

#ifndef HAVE_ACCEPT_PROTO
extern int accept(int, struct sockaddr*, int*);
#endif

#ifndef HAVE_CONNECT_PROTO
extern int connect(int, struct sockaddr*, int);
#endif

#ifndef HAVE_LISTEN_PROTO
extern int listen(int, int);
#endif

#ifndef HAVE_GETSOCKNAME_PROTO
extern int getsockname(int, struct sockaddr*, int*);
#endif

#ifndef HAVE_MAP_VARIABLE
#define HAVE_MAP_VARIABLE
#define MAP_VARIABLE 0
#endif

/* Ultrix POSIX non-compliances */

#ifndef __alpha
#ifndef __linux__
#define EXIT_FAILURE (1)
#define EXIT_SUCCESS 0
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif /* _COMPAT_H */
