#ifndef _ITER_H
#define _ITER_H

typedef void (*ifunc)(void *env, ...);

/* An iterator is a function which takes a "struct closure" as an
   argument.  The value "env" is passed as the first argument to "f",
   and the values being yielded by the iterator are passed as the second
   and following arguments. "env" is usually a pointer to a stack-allocated
   struct.

   The function "setup_arguments" in "invoke.c" is dependent on a
   struct closure have these fields in this order.
*/
struct closure {
    ifunc f;
    void *env;
};

#endif /* _ITER_H */
