/*
\section{Xref Interface}

An "Xref" bundles up an OR identifier and an OR-specific reference.
*/

#ifndef _XREF_H
#define _XREF_H

#ifdef __cplusplus
extern "C" {
#endif

#include "common/bits.h"
#include "common/oref.h"
#include "common/or_num.h"

#include <stddef.h>

typedef struct {
    OR_num or;
    Oref oref;
} Xref;

#define XREF_EQUAL(a,b) (ORNUM_EQUAL((a).or, (b).or) && OREF_EQUAL((a).oref,(b).oref))

#define XREF_HASH(x) \
((int) ((((unsigned int) (x).or) * 1737350766) & 0x7fffffff) ^ \
(int) ((((unsigned int) (x).oref) * 1737350766) & 0x7fffffff)) 

#define SET_NULL_XREF(x) do {(x).or = 0; (x).oref = 0;} while (0)

#define IS_NULL_XREF(x) ((x).or == 0 && OREF_SEGMENT((x).oref) == 0 \
			 && OREF_INDEX((x).oref) == 0)

#ifdef __cplusplus
}
#endif

#endif 
