#ifndef _DISPHDR_H
#define _DISPHDR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "runtime/obj.h"
#include "runtime/surr.h"
#include "types/type_def.h"
#include "types/objtype_class.h"
#include "types/class_class.h"

#include <string.h>

extern void inst_obj_hdr(obj, class_);
/*
    Install the proper dispatch header for a normal object of class "c".
    The object cache uses this after swizzling an object, whether newly
    fetched or not.
*/
  
extern bool is_unswizzled(obj o);
/*
  Returns true iff o is an unswizzled object.
 */

extern int init_hdr_size(objtype t);
/*
  Return the size of the object header for an object of type "t",
  i.e. the value "N" in section~\ref{objformat}.
  This is important for creating surrogates of the proper size.
*/

extern type get_surr_type(surr s);
/*
   Return the type of a surrogate. Note that this is not the same
   thing as the class of the object the surrogate refers to. However,
   the type WILL be a supertype of that class.
*/

extern int hdr_offset(objtype t, objtype st);
/*
   Return the number of words by which a pointer to a value of type "t" must be
   offset to obtain a value of type "st". Signal "not_possible" if "st" is not
   a supertype of "t".
*/

extern int objtype_num_methods (objtype t);
/* 
   Return the total number of methods for an object of type t,
   including those introduced by t's supertypes.
*/

extern int direct_methods_size(objtype t);
/*
  Return the number of direct methods of "t".
  XXX The usage of this should be replaced by "objtype_num_methods"
  once the dh_template is used for all dispatch headers.
*/

#ifdef __cplusplus

static inline int hdr_size(objtype t) {
	return (t->hdr_size >= 0) ? t->hdr_size : init_hdr_size(t);
}

static inline void inst_surr_hdr (surr s, objtype t) {
/*
  Install the proper dispatch header in a newly-created surrogate
  object.
*/
    int dhsize = hdr_size(t);
    th_assert(dhsize > 0, "Nonsense size for dispatch header");
    if (dhsize == 1) oac(s)->methods = *t->surr_DH;
    else memcpy(s, t->surr_DH, dhsize * sizeof(DV));
}


static inline void inst_unsw_hdr(obj u, class_ c) {
/*
  Install the proper dispatch header in a newly-created unswizzled
  object.
*/
  objtype t = &(c->hdr.inh);
  int dhsize = hdr_size(t);
  th_assert(dhsize > 0, "Nonsense size for dispatch header");
  if (dhsize == 1) oac(u)->methods = *t->unswizzled_DH;
  else memcpy(u, t->unswizzled_DH, dhsize * sizeof(DV));
}
#else

#define hdr_size(t) ((t->hdr_size >= 0) ? t->hdr_size : init_hdr_size(t))

#endif

#ifdef __cplusplus
}
#endif

#endif /* _DISPHDR_H */
