#include "common/compat.h"
#include "runtime/except.h"
#include "types/str.h"
#include "cache/gc_register.h"
#include "types/vec_instns.h"

exception exc = 0;
void *exc_value;

jmp_entry failure_jmp = 0;
jmp_buf abort_jmp;
struct jmp_entry_s top_failure;

struct exception_s exc_break;
struct exception_s exc_not_found;
struct exception_s exc_duplicate;
struct exception_s exc_empty;
struct exception_s exc_bounds;
struct exception_s exc_not_possible;
struct exception_s exc_not_a_tag;
struct exception_s exc_missing_tag;
struct exception_s exc_type_error;
struct exception_s exc_type_failure;
struct exception_s exc_unsupported;
struct exception_s exc_failure;
struct exception_s exc_abort;
struct exception_s exc_illegal_char;
struct exception_s exc_negative_exponent;
struct exception_s exc_negative_size;
struct exception_s exc_overflow;
struct exception_s exc_zero_divide;
struct exception_s exc_underflow;
struct exception_s exc_wrong_tag;
struct exception_s exc_wrong_type;


struct exc_entry { char *name;
	 	   exception exc;
	         };

struct exc_entry initial_exception_table[] =
{
    {"break", &exc_break},
    {"not_found", &exc_not_found},
    {"duplicate", &exc_duplicate},
    {"empty", &exc_empty},
    {"bounds", &exc_bounds},
    {"not_possible", &exc_not_possible},
    {"not_a_tag", &exc_not_a_tag},
    {"missing_tag", &exc_missing_tag},
    {"type_error", &exc_type_error},
    {"type_failure", &exc_type_failure},
    {"unsupported", &exc_unsupported},
    {"failure", &exc_failure},
    {"abort", &exc_abort},
    {"illegal_char", &exc_illegal_char},
    {"negative_exponent", &exc_negative_exponent},
    {"negative_size", &exc_negative_size},
    {"overflow", &exc_overflow},
    {"zero_divide", &exc_zero_divide},
    {"underflow", &exc_underflow},
    {"wrong_tag", &exc_wrong_tag},
    {"wrong_type", &exc_wrong_type},
    {0}
};

void initialize_exceptions()
{
    struct exc_entry *excs = initial_exception_table;
    exc = EXC_NONE;
    while (excs->name) {
	excs->exc->name = string_new(excs->name);
	/* gc_register_root((obj *)&(excs->exc->name)); */
	excs++;
    }
}

bool wellknown_exception(string nm)
{
    struct exc_entry *excs = initial_exception_table;
    while (excs->name) {
      if (string_equal(excs->exc->name, nm)) return TRUE;
      excs++;
    }
    return FALSE;
}

exception exception_new(string nm, vec vals)
{
exception ret;

      ret = NEW(struct exception_s);
      ret->name = nm;
      ret->vals = vals;
      return ret;
}

fevalue sig_value;

static string str_failure = 0;
void signal_failure(string s)
{
    vec TMP; 							
    if (!str_failure) {
	str_failure = string_new("failure: ");
	}
    exc = &exc_failure; 						
    sig_value.s = string_concat(str_failure, s);
    exc_value = &sig_value;
    _longjmp(failure_jmp->buf, 1); 
} 

static string STR_no_return_values = 0;
void signal_failure_no_return_values()
{
    if (!STR_no_return_values) {
	STR_no_return_values = string_new("no return values");
	}
    signal_failure(STR_no_return_values);
}
