#include <stdio.h>
#include "common/fail.h"
#include "common/obj_bitfield.h"
#include "common/xref.h"
#include "common/th_assert.h"
#include "types/class_class.h"
#include "types/string_class.h"
#include "types/vec_class.h"
#include "runtime/disphdr.h"
#include "runtime/obj_class.h"
#include "runtime/stats.h"

#define init_hdr(ostart, x, c) do {\
    x->stamp = 0;                                              \
    x->handle_ = 0;                                            \
    SET_NULL_XREF(x->xref);                                    \
    if (c->dhsize == 1) oac(ostart)->methods = *c->dh;         \
    else memcpy(ostart, c->dh, c->dhsize * sizeof(DV));        \
} while(0)

void init_obj_hdr(obj ostart, class_ c)
{
    Obj_bitfield bf;
    fevalue fv;
    core x = (core)(ostart + c->dhsize - 1);
    init_hdr(ostart, x, c);
/* Now do size and bitfield */
    x->size = c->slots;
    fv.o = UNPV(obj, vec_fetch(c->bitfields, 0));
    bf = fv.i;
    if ((bf & OBJ_BF_LONG_BF) == OBJ_BF_LONG_BF) {
	memcpy(&x->bitfields,
	       vec_items(c->bitfields),
	       OBJ_BF_LONGSIZE(bf) * sizeof(Obj_bitfield));
    } else {
	x->bitfields = bf;
    }
}

void inst_obj_hdr(obj ostart, class_ c)
{
/* Must be kept in sync with "init_obj_hdr_prim" */
assert(c); {
    /* x is BUMP(o), which of course we can't compute from o ... */
    core x = (core)(ostart + c->dhsize - 1);
    init_hdr(ostart, x, c);
}}

void init_obj_hdr_prim(core o, int size, Obj_bitfield bf,
		       DV methods)
/* Must be kept in sync with "init_obj_hdr" */
{
    core x = o;
    x->stamp = 0;
    x->handle_ = 0;
    SET_NULL_XREF(x->xref);
    x->size = size;
    x->bitfields = bf;
    x->methods = methods;
}
			     

obj normal_get_address(obj x)
{
    return x;
}

class_ get_obj_class(obj o)
{
    DV __dv = *o;
    return (*__dv->get_class)(BUMP(obj, o, __dv));
}

class_ normal_get_class(obj o) {
    class_ c = (*o)->c;
#ifndef NDEBUG
    if (!c) {
	warn("Object class not initialized in DV. Check Init function.");
	warn("Address of dispatch vector is 0x%lx\n", (*o));
	fail("Check fe symbol table against this address\n");
    }
#endif
    return c;
}

obj get_address(obj o)
{
    DV __dv = *o;
    return (*__dv->get_address)(BUMP(obj, o, __dv));
}

bool same_obj(obj o1, obj o2)
{
    return (BUMP(obj, o1, *o1) == BUMP(obj, o2, *o2)) ? TRUE : FALSE;
}

#ifndef NDEBUG
/* The following routines duplicate macros and should be used 
   only for debugging */

obj obj_start(obj x) {return OBJ_START(x);}
Obj_bitfield obj_bitfield(obj x) {return OBJ_BITFIELD(x);}
int obj_num_slots(obj x) {return OBJ_NUM_SLOTS(x);}

/* Routine to print the class of an object */

extern void print_class(obj o) {
    type tag_;
    string tname;
    char const *s;

    if (!o) {
	printf("Null Object\n");
	return;
    }
    tag_ = (type)get_obj_class(o);
    tname = type_name(tag_);
    s = string_charp(tname);
    fprintf(stderr, "%s\n", s);
}

#endif /* !NDEBUG */


