#include <stdio.h>
#include "common/basic.h"
#include "types/any.h"
#include "runtime/obj.h"
#include "runtime/same_object.h"
#include "types/type.h"

bool same_object(obj null_dummy, any a1, any a2)
{
    // fprintf(stderr, " entering same_objectl\n");
    FIX(a1, any); // XXX Take care of basic values also
    FIX(a2, any);
    core c1 = BUMP(core, a1, *(any_as_obj(a1)));
    core c2 = BUMP(core, a2, *(any_as_obj(a2)));
    if (c1 == c2) return TRUE;
    // fprintf(stderr, " cores not equal\n");
    class_ cl1 = get_any_class(a1);
    class_ cl2 = get_any_class(a2);
    if (cl1 != cl2) return FALSE;
    // fprintf(stderr, " classes equal\n");

    // At this point, objects are of the same class
    fevalue f1 = any_get_value(a1); 
    fevalue f2 = any_get_value(a2); 
    // Check for the basic types
    if (cl1 == Int)
        return (f1.i == f2.i);
    if (cl1 == Char)
        return (f1.c == f2.c);
    if (cl1 == Bool)
        return (f1.b == f2.b);
    if (cl1 == Real)
        return (f1.r == f2.r);
    if (cl1 == Null)
        return TRUE;
    // XXX Is it possible to have two different cores for the same object?
    // fprintf(stderr, " xrefs %X %X\n", c1->xref, c2->xref);
    if (IS_NULL_XREF(c1->xref) && IS_NULL_XREF(c2->xref)) return FALSE;
    return XREF_EQUAL(c1->xref, c2->xref);
    }
