#ifndef _STATS_H
#define _STATS_H
#include "common/basic.h"

#include "config/vdefs/COLLECT_STATS.h"

/* 
     Put code to increment stats counters inside a call to STATS.
     Then it goes away if COLLECT_STATS is FALSE.
*/

#if COLLECT_STATS
#define STATS(x) (x);
#define STATS_EXPR(x) (x)
#else
#define STATS(x)
#define STATS_EXPR(x) 0
#endif

#if COLLECT_STATS

#ifdef __cplusplus
extern "C" {
#endif

/* 
     swizzled_refs is incremented each time a reference in 
         an object is swizzled.

     cache_misses is incremented each time an object must 
         be fetched from an OR.

     fixes is incremented each time the run-time system calls
         FIX or FIX_FAST.

     discovers is incremented each time the run-time system calls
         DISCOVER.

     empty_surrogate_uses is incremented each time an empty surrogate
         has a method called on it.

     surrogate_uses is incremented each time a full surrogate is
         used to reach another object.

     surrogate_creations is incremented each time an empty surrogate
         is created (either because of swizzling or shrinking).

     surrogate_fills is incremented each time a surrogate is changed
         from empty to full.

     ops is incremented at each client-to-FE call.

     fetches_sent is incremented at each fetch request sent to the OR.
*/
     


typedef struct statistics_s {long swizzled_refs;
			     long empty_surrogate_uses;
                             long cache_misses;
			     long fixes;
			     long discovers;
			     long surrogate_uses;
			     long surrogate_creations;
			     long surrogate_fills;
			     long ops;
			     long fetches_sent;
			   } *statistics;

extern statistics stats;

/* Call zero_stats to set all counters to 0 */

extern void zero_stats();

#ifdef __cplusplus
}
#endif

#endif /* COLLECT_STATS */

#endif /* _STATS_H */
