#ifndef _ASSEMBLY_H
#define _ASSEMBLY_H

#include "assembly_def.h"
#include "designobj.h"
#include "int.h"
#include "complexassembly.h"
#include "traversal.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *assembly_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void assemblyMinit_superassembly(assembly self, complexassembly super);
extern complexassembly assemblyMsuperassembly(assembly self);
extern int assemblyMtraverse(assembly self, traversal t);

extern void Init_assembly();

#ifdef __cplusplus
}
#endif


struct assembly_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
};

#endif /* _ASSEMBLY_H */
