#ifndef _ATOMICPART_CLASS_H
#define _ATOMICPART_CLASS_H

#include "atomicpart_class_def.h"
#include "atomicpart.h"
#include "atomicpart_class_inc.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *atomicpart_class_V;

#ifdef __cplusplus
extern "C" {
#endif

extern int atomicpart_classMid_(atomicpart_class self);
extern int atomicpart_classMbuilddate_(atomicpart_class self);
extern void atomicpart_classMset_builddate_(atomicpart_class self, int builddate_);
extern string atomicpart_classMotype_(atomicpart_class self);
extern int atomicpart_classMdocid_(atomicpart_class self);
extern int atomicpart_classMx_(atomicpart_class self);
extern void atomicpart_classMset_x_(atomicpart_class self, int x_);
extern int atomicpart_classMy_(atomicpart_class self);
extern void atomicpart_classMset_y_(atomicpart_class self, int y_);
extern compositepart atomicpart_classMsuperpart_(atomicpart_class self);
extern void atomicpart_classMadd_outconnection_(atomicpart_class self, connection con);
extern void atomicpart_classMadd_inconnection_(atomicpart_class self, connection con);
extern connection atomicpart_classMoutconnection_(atomicpart_class self, int index);
extern connection atomicpart_classMinconnection_(atomicpart_class self, int index);
extern void atomicpart_classMdonothing_(atomicpart_class self);
extern void atomicpart_classMswapxy_(atomicpart_class self);
extern int atomicpart_classMtraverse_(atomicpart_class self, traversal t);

extern void Init_atomicpart_class();

#ifdef __cplusplus
}
#endif


struct atomicpart_class_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  int (*docid)(atomicpart self);
  int (*x)(atomicpart self);
  void (*set_x)(atomicpart self, int val);
  int (*y)(atomicpart self);
  void (*set_y)(atomicpart self, int val);
  compositepart (*superpart)(atomicpart self);
  void (*add_outconnection)(atomicpart self, connection con);
  void (*add_inconnection)(atomicpart self, connection con);
  connection (*outconnection)(atomicpart self, int i);
  connection (*inconnection)(atomicpart self, int i);
  void (*donothing)(atomicpart self);
  void (*swapxy)(atomicpart self);
  int (*traverse)(atomicpart self, traversal t);
};

struct atomicpart_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  int (*docid)(atomicpart self);
  int (*x)(atomicpart self);
  void (*set_x)(atomicpart self, int val);
  int (*y)(atomicpart self);
  void (*set_y)(atomicpart self, int val);
  compositepart (*superpart)(atomicpart self);
  void (*add_outconnection)(atomicpart self, connection con);
  void (*add_inconnection)(atomicpart self, connection con);
  connection (*outconnection)(atomicpart self, int i);
  connection (*inconnection)(atomicpart self, int i);
  void (*donothing)(atomicpart self);
  void (*swapxy)(atomicpart self);
  int (*traverse)(atomicpart self, traversal t);
};

#include "int.h"
#include "compositepart.h"
#include "array.h"
#include "string.h"

struct atomicpart_class_f_s {
  struct Fields_s inh;
  int id_;
  int builddate_;
  Shortp otype_;
  int docid_;
  int x_;
  int y_;
  Shortp super_;
  Shortp from_;
  Shortp to_;
};


#endif /* _ATOMICPART_CLASS_H */
