#ifndef _BASEASSEMBLY_CLASS_H
#define _BASEASSEMBLY_CLASS_H

#include "baseassembly_class_def.h"
#include "baseassembly.h"
#include "baseassembly_class_inc.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *baseassembly_class_V;

#ifdef __cplusplus
extern "C" {
#endif

extern int baseassembly_classMid_(baseassembly_class self);
extern int baseassembly_classMbuilddate_(baseassembly_class self);
extern void baseassembly_classMset_builddate_(baseassembly_class self, int builddate_);
extern string baseassembly_classMotype_(baseassembly_class self);
extern void baseassembly_classMinit_superassembly_(baseassembly_class self, complexassembly super);
extern complexassembly baseassembly_classMsuperassembly_(baseassembly_class self);
extern void baseassembly_classMadd_subpart_(baseassembly_class self, compositepart part);
extern compositepart baseassembly_classMsubpart_(baseassembly_class self, int index);
extern int baseassembly_classMtraverse_(baseassembly_class self, traversal t);

extern void Init_baseassembly_class();

#ifdef __cplusplus
}
#endif


struct baseassembly_class_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subpart)(baseassembly self, compositepart part);
  compositepart (*subpart)(baseassembly self, int i);
};

struct baseassembly_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subpart)(baseassembly self, compositepart part);
  compositepart (*subpart)(baseassembly self, int i);
};

#include "int.h"
#include "array.h"
#include "maybe.h"
#include "string.h"

struct baseassembly_class_f_s {
  struct Fields_s inh;
  int id_;
  int builddate_;
  Shortp otype_;
  Shortp super_;
  Shortp sub_;
};


#endif /* _BASEASSEMBLY_CLASS_H */
