#ifndef _COMPLEXASSEMBLY_H
#define _COMPLEXASSEMBLY_H

#include "complexassembly_def.h"
#include "assembly.h"
#include "int.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *complexassembly_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void complexassemblyMadd_subassembly(complexassembly self, assembly sub);
extern assembly complexassemblyMsubassembly(complexassembly self, int i);

extern void Init_complexassembly();

#ifdef __cplusplus
}
#endif


struct complexassembly_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subassembly)(complexassembly self, assembly sub);
  assembly (*subassembly)(complexassembly self, int i);
};

#endif /* _COMPLEXASSEMBLY_H */
