#ifndef _COMPOSITEPART_CLASS_H
#define _COMPOSITEPART_CLASS_H

#include "compositepart_class_def.h"
#include "compositepart.h"
#include "compositepart_class_inc.h"
#include "atomicpart.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *compositepart_class_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void compositepart_classMinit_rootpart(compositepart_class self, atomicpart part);
extern atomicpart compositepart_classMrootpart(compositepart_class self);
extern int compositepart_classMid_(compositepart_class self);
extern int compositepart_classMbuilddate_(compositepart_class self);
extern void compositepart_classMset_builddate_(compositepart_class self, int builddate_);
extern string compositepart_classMotype_(compositepart_class self);
extern document compositepart_classMdoc_(compositepart_class self);
extern void compositepart_classMadd_superassembly_(compositepart_class self, baseassembly super);
extern baseassembly compositepart_classMsuperassembly_(compositepart_class self, int i);
extern void compositepart_classMinit_rootpart_(compositepart_class self, atomicpart part);
extern atomicpart compositepart_classMrootpart_(compositepart_class self);
extern void compositepart_classMadd_subpart_(compositepart_class self, atomicpart part);
extern atomicpart compositepart_classMsubpart_(compositepart_class self, int index);
extern int compositepart_classMtraverse_(compositepart_class self, traversal t);

extern void Init_compositepart_class();

#ifdef __cplusplus
}
#endif


struct compositepart_class_class_DV {
  void (*init_rootpart)(compositepart_class self, atomicpart part);
  atomicpart (*rootpart)(compositepart_class self);
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  document (*doc)(compositepart self);
  void (*add_superassembly)(compositepart self, baseassembly super);
  baseassembly (*superassembly)(compositepart self, int i);
  void (*add_subpart)(compositepart self, atomicpart part);
  atomicpart (*subpart)(compositepart self, int index);
  int (*traverse)(compositepart self, traversal t);
};

struct compositepart_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  document (*doc)(compositepart self);
  void (*add_superassembly)(compositepart self, baseassembly super);
  baseassembly (*superassembly)(compositepart self, int i);
  void (*add_subpart)(compositepart self, atomicpart part);
  atomicpart (*subpart)(compositepart self, int index);
  int (*traverse)(compositepart self, traversal t);
};

#include "int.h"
#include "string.h"
#include "maybe.h"
#include "document.h"
#include "array.h"

struct compositepart_class_f_s {
  struct Fields_s inh;
  int id_;
  int builddate_;
  Shortp otype_;
  Shortp doc_;
  Shortp super_;
  Shortp sub_;
  Shortp rootpart_;
};


#endif /* _COMPOSITEPART_CLASS_H */
