#ifndef _INTSET_H
#define _INTSET_H

#include "intset_def.h"
#include "int.h"
#include "bool.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *intset_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void intsetMinsert(intset self, int k);
extern bool intsetMmember(intset self, int k);
extern bool intsetMempty(intset self);
extern void intsetMclear(intset self);

extern void Init_intset();

#ifdef __cplusplus
}
#endif


struct intset_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  void (*insert)(intset self, int k);
  bool (*member)(intset self, int k);
  bool (*empty)(intset self);
  void (*clear)(intset self);
};

#endif /* _INTSET_H */
