#ifndef _ATOMICPART_H
#define _ATOMICPART_H

#include "atomicpart_def.h"
#include "designobj.h"
#include "int.h"
#include "compositepart.h"
#include "traversal.h"
#include "connection.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *atomicpart_V;

#ifdef __cplusplus
extern "C" {
#endif

extern int atomicpartMdocid(atomicpart self);
extern int atomicpartMx(atomicpart self);
extern void atomicpartMset_x(atomicpart self, int val);
extern int atomicpartMy(atomicpart self);
extern void atomicpartMset_y(atomicpart self, int val);
extern compositepart atomicpartMsuperpart(atomicpart self);
extern void atomicpartMadd_outconnection(atomicpart self, connection con);
extern void atomicpartMadd_inconnection(atomicpart self, connection con);
extern connection atomicpartMoutconnection(atomicpart self, int i);
extern connection atomicpartMinconnection(atomicpart self, int i);
extern void atomicpartMdonothing(atomicpart self);
extern void atomicpartMswapxy(atomicpart self);
extern int atomicpartMtraverse(atomicpart self, traversal t);

extern void Init_atomicpart();

#ifdef __cplusplus
}
#endif


struct atomicpart_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  int (*docid)(atomicpart self);
  int (*x)(atomicpart self);
  void (*set_x)(atomicpart self, int val);
  int (*y)(atomicpart self);
  void (*set_y)(atomicpart self, int val);
  compositepart (*superpart)(atomicpart self);
  void (*add_outconnection)(atomicpart self, connection con);
  void (*add_inconnection)(atomicpart self, connection con);
  connection (*outconnection)(atomicpart self, int i);
  connection (*inconnection)(atomicpart self, int i);
  void (*donothing)(atomicpart self);
  void (*swapxy)(atomicpart self);
  int (*traverse)(atomicpart self, traversal t);
};

#endif /* _ATOMICPART_H */
