#ifndef _BASEASSEMBLY_H
#define _BASEASSEMBLY_H

#include "baseassembly_def.h"
#include "assembly.h"
#include "compositepart.h"
#include "int.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *baseassembly_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void baseassemblyMadd_subpart(baseassembly self, compositepart part);
extern compositepart baseassemblyMsubpart(baseassembly self, int i);

extern void Init_baseassembly();

#ifdef __cplusplus
}
#endif


struct baseassembly_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subpart)(baseassembly self, compositepart part);
  compositepart (*subpart)(baseassembly self, int i);
};

#endif /* _BASEASSEMBLY_H */
