#ifndef _COMPLEXASSEMBLY_CLASS_H
#define _COMPLEXASSEMBLY_CLASS_H

#include "complexassembly_class_def.h"
#include "complexassembly.h"
#include "complexassembly_class_inc.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *complexassembly_class_V;

#ifdef __cplusplus
extern "C" {
#endif

extern int complexassembly_classMid_(complexassembly_class self);
extern int complexassembly_classMbuilddate_(complexassembly_class self);
extern void complexassembly_classMset_builddate_(complexassembly_class self, int builddate_);
extern string complexassembly_classMotype_(complexassembly_class self);
extern void complexassembly_classMinit_superassembly_(complexassembly_class self, complexassembly super);
extern complexassembly complexassembly_classMsuperassembly_(complexassembly_class self);
extern void complexassembly_classMadd_subassembly_(complexassembly_class self, assembly sub);
extern assembly complexassembly_classMsubassembly_(complexassembly_class self, int index);
extern int complexassembly_classMtraverse_(complexassembly_class self, traversal t);

extern void Init_complexassembly_class();

#ifdef __cplusplus
}
#endif


struct complexassembly_class_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subassembly)(complexassembly self, assembly sub);
  assembly (*subassembly)(complexassembly self, int i);
};

struct complexassembly_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  void (*init_superassembly)(assembly self, complexassembly super);
  complexassembly (*superassembly)(assembly self);
  int (*traverse)(assembly self, traversal t);
  void (*add_subassembly)(complexassembly self, assembly sub);
  assembly (*subassembly)(complexassembly self, int i);
};

#include "int.h"
#include "array.h"
#include "maybe.h"
#include "string.h"

struct complexassembly_class_f_s {
  struct Fields_s inh;
  int id_;
  int builddate_;
  Shortp otype_;
  Shortp super_;
  Shortp sub_;
};


#endif /* _COMPLEXASSEMBLY_CLASS_H */
