#ifndef _COMPOSITEPART_H
#define _COMPOSITEPART_H

#include "compositepart_def.h"
#include "designobj.h"
#include "int.h"
#include "document.h"
#include "traversal.h"
#include "baseassembly.h"
#include "atomicpart.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *compositepart_V;

#ifdef __cplusplus
extern "C" {
#endif

extern document compositepartMdoc(compositepart self);
extern void compositepartMadd_superassembly(compositepart self, baseassembly super);
extern baseassembly compositepartMsuperassembly(compositepart self, int i);
extern void compositepartMadd_subpart(compositepart self, atomicpart part);
extern atomicpart compositepartMsubpart(compositepart self, int index);
extern int compositepartMtraverse(compositepart self, traversal t);

extern void Init_compositepart();

#ifdef __cplusplus
}
#endif


struct compositepart_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  int (*id)(designobj self);
  int (*builddate)(designobj self);
  void (*set_builddate)(designobj self, int date);
  string (*otype)(designobj self);
  document (*doc)(compositepart self);
  void (*add_superassembly)(compositepart self, baseassembly super);
  baseassembly (*superassembly)(compositepart self, int i);
  void (*add_subpart)(compositepart self, atomicpart part);
  atomicpart (*subpart)(compositepart self, int index);
  int (*traverse)(compositepart self, traversal t);
};

#endif /* _COMPOSITEPART_H */
