#ifndef _CONNECTION_H
#define _CONNECTION_H

#include "connection_def.h"
#include "string.h"
#include "int.h"
#include "atomicpart.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *connection_V;

#ifdef __cplusplus
extern "C" {
#endif

extern string connectionMotype(connection self);
extern int connectionMlength(connection self);
extern atomicpart connectionMfrom(connection self);
extern atomicpart connectionMto(connection self);

extern void Init_connection();

#ifdef __cplusplus
}
#endif


struct connection_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*otype)(connection self);
  int (*length)(connection self);
  atomicpart (*from)(connection self);
  atomicpart (*to)(connection self);
};

#endif /* _CONNECTION_H */
