#ifndef _DIRECTORY_H
#define _DIRECTORY_H

#include "directory_def.h"
#include "string.h"
#include "directory_gen.h"
#include "int.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *directory_V;

#ifdef __cplusplus
extern "C" {
#endif

extern any directoryMlookup(directory self, string name);
extern void directoryMinsert(directory self, string name, any objt);
extern void directoryMremove(directory self, string name);
extern directory_gen directoryMnames(directory self);
extern int directoryMsize(directory self);

extern void Init_directory();

#ifdef __cplusplus
}
#endif


struct directory_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  any (*lookup)(directory self, string name);
  void (*insert)(directory self, string name, any objt);
  void (*remove)(directory self, string name);
  directory_gen (*names)(directory self);
  int (*size)(directory self);
};

#endif /* _DIRECTORY_H */
