#ifndef _INSTN_H
#define _INSTN_H

#include "instn_def.h"
#include "object_type.h"
#include "ptype.h"
#include "type_.h"
#include "bool.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *instn_V;

struct instnMarguments_Iter_State_s {
int pc;
int spare;
type_ ret_0;
};

#ifdef __cplusplus
extern "C" {
#endif

extern ptype instnMparam_type(instn self);
extern instnMarguments_Iter_State instnMarguments_START_(instn self);
extern bool instnMarguments_LOOP_(instn self, instnMarguments_Iter_State IState);
extern bool instnMis_real(instn self);
extern void instnMvalidate(instn self);
extern void instnMcomplete(instn self);

extern void Init_instn();

#ifdef __cplusplus
}
#endif


struct instn_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
  ptype (*param_type)(instn self);
  instnMarguments_Iter_State (*arguments_START)(instn self);
  int (*arguments_LOOP)(instn self, instnMarguments_Iter_State IState);
  bool (*is_real)(instn self);
  void (*validate)(instn self);
  void (*complete)(instn self);
};

#endif /* _INSTN_H */
