#ifndef _INSTN_IMPL_H
#define _INSTN_IMPL_H

#include "instn_impl_def.h"
#include "instn.h"
#include "ot_impl.h"

#include "instn_impl_inc.h"
#include "instn_implMarguments.h"
#include "instn_implMsupertypes.h"
#include "type_.h"
#include "param.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *instn_impl_V;

#ifdef __cplusplus
extern "C" {
#endif

extern type_ instn_implMsubst_type(instn_impl self, type_ t);
extern type_ instn_implMsubst_instn(instn_impl self, instn i);
extern type_ instn_implMsubst_param(instn_impl self, param p);
extern ptype instn_implMparam_type_(instn_impl self);
extern bool instn_implMis_real_(instn_impl self);
extern instn_implMarguments_Iter_State instn_implMarguments_START_(instn_impl self);
extern bool instn_implMarguments_LOOP_(instn_impl self, instn_implMarguments_Iter_State IState);
extern string instn_implMname_(instn_impl self);
extern bool instn_implMequal_(instn_impl self, type_ t);
extern instn_implMsupertypes_Iter_State instn_implMsupertypes_START_(instn_impl self);
extern bool instn_implMsupertypes_LOOP_(instn_impl self, instn_implMsupertypes_Iter_State IState);
extern int instn_implMkind_(instn_impl self);
extern method instn_implMget_method_(instn_impl self, string mname);
extern int instn_implMfield_info_(instn_impl self, Pval *__retvals);
extern type_ instn_implMsubst_type_(instn_impl self, type_ t);
extern type_ instn_implMsubst_instn_(instn_impl self, instn i);
extern type_ instn_implMsubst_param_(instn_impl self, param p);
extern void instn_implMvalidate_(instn_impl self);
extern void instn_implMcomplete_(instn_impl self);

extern void Init_instn_impl();

#ifdef __cplusplus
}
#endif


struct instn_impl_class_DV {
  type_ (*subst_type)(instn_impl self, type_ t);
  type_ (*subst_instn)(instn_impl self, instn i);
  type_ (*subst_param)(instn_impl self, param p);
  bool (*get_is_complete)(ot_impl self);
  void (*add_new_method)(ot_impl self, method m);
  sequence (*method_sequence)(ot_impl self);
  sequence (*type_dv_template)(ot_impl self);
  sequence (*class_dv_template)(ot_impl self);
  sequence (*compute_dh_template)(ot_impl self);
  sequence (*merge_type_headers)(ot_impl self, sequence types);
  bool (*can_embed)(ot_impl self, Pval *__retvals, sequence dh1, sequence dh2);
  bool (*dv_match)(ot_impl self, sequence dv1, sequence dv2);
  sequence (*merge_template)(ot_impl self, sequence to_merge, sequence current, int offset);
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
  ptype (*param_type)(instn self);
  instnMarguments_Iter_State (*arguments_START)(instn self);
  int (*arguments_LOOP)(instn self, instnMarguments_Iter_State IState);
  bool (*is_real)(instn self);
  void (*validate)(instn self);
  void (*complete)(instn self);
};

struct instn_impl_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
  ptype (*param_type)(instn self);
  instnMarguments_Iter_State (*arguments_START)(instn self);
  int (*arguments_LOOP)(instn self, instnMarguments_Iter_State IState);
  bool (*is_real)(instn self);
  void (*validate)(instn self);
  void (*complete)(instn self);
};

#include "ot_impl.h"

#include "ptype.h"
#include "sequence.h"
#include "bool.h"

struct instn_impl_f_s {
  struct ot_impl_f_s  inh;
  Shortp ptype_;
  Shortp pargs;
  th_bool real_type;
  th_bool valid;
  Shortp supertypes_;
  Shortp methods_;
};


#endif /* _INSTN_IMPL_H */
