#ifndef _METHOD_H
#define _METHOD_H

#include "method_def.h"
#include "bool.h"
#include "formal.h"
#include "signal_.h"
#include "sequence.h"
#include "int.h"
#include "string.h"
#include "type_.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *method_V;

struct methodMarguments_Iter_State_s {
int pc;
int spare;
formal ret_0;
};

struct methodMsignals__Iter_State_s {
int pc;
int spare;
signal_ ret_0;
};

struct methodMreturns__Iter_State_s {
int pc;
int spare;
type_ ret_0;
};

#ifdef __cplusplus
extern "C" {
#endif

extern bool methodMequal(method self, method m2);
extern bool methodMsimilar(method self, method m2);
extern sequence methodMget_args(method self);
extern sequence methodMget_returns(method self);
extern sequence methodMget_signals(method self);
extern methodMarguments_Iter_State methodMarguments_START_(method self);
extern bool methodMarguments_LOOP_(method self, methodMarguments_Iter_State IState);
extern formal methodMfetch_argument(method self, int i);
extern int methodMnum_arguments(method self);
extern methodMsignals__Iter_State methodMsignals__START_(method self);
extern bool methodMsignals__LOOP_(method self, methodMsignals__Iter_State IState);
extern signal_ methodMfetch_signal(method self, int i);
extern int methodMnum_signals(method self);
extern methodMreturns__Iter_State methodMreturns__START_(method self);
extern bool methodMreturns__LOOP_(method self, methodMreturns__Iter_State IState);
extern type_ methodMfetch_return(method self, int i);
extern int methodMnum_returns(method self);
extern string methodMname(method self);
extern string methodMunparse(method self);
extern method methodMrename(method self, string new_name);
extern bool methodMis_iter(method self);
extern bool methodMis_parameterized(method self);

extern void Init_method();

#ifdef __cplusplus
}
#endif


struct method_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  bool (*equal)(method self, method m2);
  bool (*similar)(method self, method m2);
  sequence (*get_args)(method self);
  sequence (*get_returns)(method self);
  sequence (*get_signals)(method self);
  methodMarguments_Iter_State (*arguments_START)(method self);
  int (*arguments_LOOP)(method self, methodMarguments_Iter_State IState);
  formal (*fetch_argument)(method self, int i);
  int (*num_arguments)(method self);
  methodMsignals__Iter_State (*signals__START)(method self);
  int (*signals__LOOP)(method self, methodMsignals__Iter_State IState);
  signal_ (*fetch_signal)(method self, int i);
  int (*num_signals)(method self);
  methodMreturns__Iter_State (*returns__START)(method self);
  int (*returns__LOOP)(method self, methodMreturns__Iter_State IState);
  type_ (*fetch_return)(method self, int i);
  int (*num_returns)(method self);
  string (*name)(method self);
  string (*unparse)(method self);
  method (*rename)(method self, string new_name);
  bool (*is_iter)(method self);
  bool (*is_parameterized)(method self);
};

#endif /* _METHOD_H */
