#ifndef _METHOD_IMPL_H
#define _METHOD_IMPL_H

#include "method_impl_def.h"
#include "method.h"
#include "method_impl_inc.h"
#include "method_implMarguments.h"
#include "method_implMsignals_.h"
#include "method_implMreturns_.h"
#include "bool.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *method_impl_V;

#ifdef __cplusplus
extern "C" {
#endif

extern bool method_implMparameterized(method_impl self);
extern string method_implMname_(method_impl self);
extern sequence method_implMget_args_(method_impl self);
extern sequence method_implMget_returns_(method_impl self);
extern sequence method_implMget_signals_(method_impl self);
extern bool method_implMis_iter_(method_impl self);
extern bool method_implMequal_(method_impl self, method m2);
extern bool method_implMsimilar_(method_impl self, method m2);
extern method_implMarguments_Iter_State method_implMarguments_START_(method_impl self);
extern bool method_implMarguments_LOOP_(method_impl self, method_implMarguments_Iter_State IState);
extern int method_implMnum_arguments_(method_impl self);
extern formal method_implMfetch_argument_(method_impl self, int i);
extern method_implMsignals__Iter_State method_implMsignals__START_(method_impl self);
extern bool method_implMsignals__LOOP_(method_impl self, method_implMsignals__Iter_State IState);
extern int method_implMnum_signals_(method_impl self);
extern signal_ method_implMfetch_signal_(method_impl self, int i);
extern method_implMreturns__Iter_State method_implMreturns__START_(method_impl self);
extern bool method_implMreturns__LOOP_(method_impl self, method_implMreturns__Iter_State IState);
extern int method_implMnum_returns_(method_impl self);
extern type_ method_implMfetch_return_(method_impl self, int i);
extern string method_implMunparse_(method_impl self);
extern bool method_implMis_parameterized_(method_impl self);
extern method method_implMrename_(method_impl self, string new_name);
extern bool method_implMparameterized_(method_impl self);

extern void Init_method_impl();

#ifdef __cplusplus
}
#endif


struct method_impl_class_DV {
  bool (*parameterized)(method_impl self);
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  bool (*equal)(method self, method m2);
  bool (*similar)(method self, method m2);
  sequence (*get_args)(method self);
  sequence (*get_returns)(method self);
  sequence (*get_signals)(method self);
  methodMarguments_Iter_State (*arguments_START)(method self);
  int (*arguments_LOOP)(method self, methodMarguments_Iter_State IState);
  formal (*fetch_argument)(method self, int i);
  int (*num_arguments)(method self);
  methodMsignals__Iter_State (*signals__START)(method self);
  int (*signals__LOOP)(method self, methodMsignals__Iter_State IState);
  signal_ (*fetch_signal)(method self, int i);
  int (*num_signals)(method self);
  methodMreturns__Iter_State (*returns__START)(method self);
  int (*returns__LOOP)(method self, methodMreturns__Iter_State IState);
  type_ (*fetch_return)(method self, int i);
  int (*num_returns)(method self);
  string (*name)(method self);
  string (*unparse)(method self);
  method (*rename)(method self, string new_name);
  bool (*is_iter)(method self);
  bool (*is_parameterized)(method self);
};

struct method_impl_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  bool (*equal)(method self, method m2);
  bool (*similar)(method self, method m2);
  sequence (*get_args)(method self);
  sequence (*get_returns)(method self);
  sequence (*get_signals)(method self);
  methodMarguments_Iter_State (*arguments_START)(method self);
  int (*arguments_LOOP)(method self, methodMarguments_Iter_State IState);
  formal (*fetch_argument)(method self, int i);
  int (*num_arguments)(method self);
  methodMsignals__Iter_State (*signals__START)(method self);
  int (*signals__LOOP)(method self, methodMsignals__Iter_State IState);
  signal_ (*fetch_signal)(method self, int i);
  int (*num_signals)(method self);
  methodMreturns__Iter_State (*returns__START)(method self);
  int (*returns__LOOP)(method self, methodMreturns__Iter_State IState);
  type_ (*fetch_return)(method self, int i);
  int (*num_returns)(method self);
  string (*name)(method self);
  string (*unparse)(method self);
  method (*rename)(method self, string new_name);
  bool (*is_iter)(method self);
  bool (*is_parameterized)(method self);
};

#include "string.h"
#include "sequence.h"
#include "bool.h"

struct method_impl_f_s {
  struct Fields_s inh;
  Shortp name_;
  Shortp args;
  Shortp rets;
  Shortp sigs;
  th_bool iter_;
};


#endif /* _METHOD_IMPL_H */
