#ifndef _MINSTN_H
#define _MINSTN_H

#include "minstn_def.h"
#include "method.h"
#include "pmethod.h"
#include "bool.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *minstn_V;

#ifdef __cplusplus
extern "C" {
#endif

extern pmethod minstnMparam_method(minstn self);
extern bool minstnMis_real(minstn self);
extern void minstnMvalidate(minstn self);
extern void minstnMcomplete(minstn self);

extern void Init_minstn();

#ifdef __cplusplus
}
#endif


struct minstn_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  bool (*equal)(method self, method m2);
  bool (*similar)(method self, method m2);
  sequence (*get_args)(method self);
  sequence (*get_returns)(method self);
  sequence (*get_signals)(method self);
  methodMarguments_Iter_State (*arguments_START)(method self);
  int (*arguments_LOOP)(method self, methodMarguments_Iter_State IState);
  formal (*fetch_argument)(method self, int i);
  int (*num_arguments)(method self);
  methodMsignals__Iter_State (*signals__START)(method self);
  int (*signals__LOOP)(method self, methodMsignals__Iter_State IState);
  signal_ (*fetch_signal)(method self, int i);
  int (*num_signals)(method self);
  methodMreturns__Iter_State (*returns__START)(method self);
  int (*returns__LOOP)(method self, methodMreturns__Iter_State IState);
  type_ (*fetch_return)(method self, int i);
  int (*num_returns)(method self);
  string (*name)(method self);
  string (*unparse)(method self);
  method (*rename)(method self, string new_name);
  bool (*is_iter)(method self);
  bool (*is_parameterized)(method self);
  pmethod (*param_method)(minstn self);
  bool (*is_real)(minstn self);
  void (*validate)(minstn self);
  void (*complete)(minstn self);
};

#endif /* _MINSTN_H */
