#ifndef _OBJECT_TYPE_H
#define _OBJECT_TYPE_H

#include "object_type_def.h"
#include "type_.h"
#include "int.h"
#include "sequence.h"
#include "method.h"
#include "string.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *object_type_V;

struct object_typeMsupertypes_Iter_State_s {
int pc;
int spare;
object_type ret_0;
};

struct object_typeMnew_methods_Iter_State_s {
int pc;
int spare;
method ret_0;
};

struct object_typeMmethod_renamings_Iter_State_s {
int pc;
int spare;
string ret_0;
};

#ifdef __cplusplus
extern "C" {
#endif

extern void object_typeMset_new_methods(object_type self, sequence new_ms);
extern void object_typeMmake_complete(object_type self);
extern object_typeMsupertypes_Iter_State object_typeMsupertypes_START_(object_type self);
extern bool object_typeMsupertypes_LOOP_(object_type self, object_typeMsupertypes_Iter_State IState);
extern sequence object_typeMsupertypes_seq(object_type self);
extern object_typeMnew_methods_Iter_State object_typeMnew_methods_START_(object_type self);
extern bool object_typeMnew_methods_LOOP_(object_type self, object_typeMnew_methods_Iter_State IState);
extern int object_typeMdv_entry_size(object_type self);
extern int object_typeMmethod_index(object_type self, string name, object_type t);
extern object_typeMmethod_renamings_Iter_State object_typeMmethod_renamings_START_(object_type self, string name);
extern bool object_typeMmethod_renamings_LOOP_(object_type self, object_typeMmethod_renamings_Iter_State IState);
extern sequence object_typeMget_renamings(object_type self);
extern sequence object_typeMget_dh_template(object_type self);
extern sequence object_typeMget_dv_template(object_type self);

extern void Init_object_type();

#ifdef __cplusplus
}
#endif


struct object_type_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
};

#endif /* _OBJECT_TYPE_H */
