#ifndef _OT_IMPL_H
#define _OT_IMPL_H

#include "ot_impl_def.h"
#include "object_type.h"
#include "ot_impl_inc.h"
#include "ot_implMsupertypes.h"
#include "ot_implMmethod_renamings.h"
#include "ot_implMmethods.h"
#include "ot_implMnew_methods.h"
#include "bool.h"
#include "sequence.h"
#include "method.h"
#include "int.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *ot_impl_V;

#ifdef __cplusplus
extern "C" {
#endif

extern bool ot_implMget_is_complete(ot_impl self);
extern void ot_implMadd_new_method(ot_impl self, method m);
extern sequence ot_implMmethod_sequence(ot_impl self);
extern sequence ot_implMtype_dv_template(ot_impl self);
extern sequence ot_implMclass_dv_template(ot_impl self);
extern sequence ot_implMcompute_dh_template(ot_impl self);
extern sequence ot_implMmerge_type_headers(ot_impl self, sequence types);
extern bool ot_implMcan_embed(ot_impl self, Pval *__retvals, sequence dh1, sequence dh2);
extern bool ot_implMdv_match(ot_impl self, sequence dv1, sequence dv2);
extern sequence ot_implMmerge_template(ot_impl self, sequence to_merge, sequence current, int offset);
extern bool ot_implMget_is_complete_(ot_impl self);
extern string ot_implMname_(ot_impl self);
extern sequence ot_implMsupertypes_seq_(ot_impl self);
extern sequence ot_implMget_new_methods_(ot_impl self);
extern int ot_implMkind_(ot_impl self);
extern sequence ot_implMget_renamings_(ot_impl self);
extern bool ot_implMequal_(ot_impl self, type_ t);
extern void ot_implMmake_complete_(ot_impl self);
extern void ot_implMset_new_methods_(ot_impl self, sequence new_ms);
extern void ot_implMadd_new_method_(ot_impl self, method m);
extern ot_implMsupertypes_Iter_State ot_implMsupertypes_START_(ot_impl self);
extern bool ot_implMsupertypes_LOOP_(ot_impl self, ot_implMsupertypes_Iter_State IState);
extern bool ot_implMsubtype_of_(ot_impl self, type_ t);
extern method ot_implMget_method_(ot_impl self, string mname);
extern ot_implMmethod_renamings_Iter_State ot_implMmethod_renamings_START_(ot_impl self, string mname);
extern bool ot_implMmethod_renamings_LOOP_(ot_impl self, ot_implMmethod_renamings_Iter_State IState);
extern ot_implMmethods_Iter_State ot_implMmethods_START_(ot_impl self);
extern bool ot_implMmethods_LOOP_(ot_impl self, ot_implMmethods_Iter_State IState);
extern sequence ot_implMmethod_sequence_(ot_impl self);
extern sequence ot_implMtype_dv_template_(ot_impl self);
extern sequence ot_implMclass_dv_template_(ot_impl self);
extern int ot_implMmethod_index_(ot_impl self, string n, object_type t);
extern string ot_implMunparse_(ot_impl self);
extern int ot_implMfield_info_(ot_impl self, Pval *__retvals);
extern ot_implMnew_methods_Iter_State ot_implMnew_methods_START_(ot_impl self);
extern bool ot_implMnew_methods_LOOP_(ot_impl self, ot_implMnew_methods_Iter_State IState);
extern int ot_implMdv_entry_size_(ot_impl self);
extern sequence ot_implMget_dv_template_(ot_impl self);
extern sequence ot_implMget_dh_template_(ot_impl self);
extern sequence ot_implMcompute_dh_template_(ot_impl self);
extern sequence ot_implMmerge_type_headers_(ot_impl self, sequence types);
extern bool ot_implMcan_embed_(ot_impl self, Pval *__retvals, sequence dh1, sequence dh2);
extern bool ot_implMdv_match_(ot_impl self, sequence dv1, sequence dv2);
extern sequence ot_implMmerge_template_(ot_impl self, sequence to_merge, sequence current, int offset);

extern void Init_ot_impl();

#ifdef __cplusplus
}
#endif


struct ot_impl_class_DV {
  bool (*get_is_complete)(ot_impl self);
  void (*add_new_method)(ot_impl self, method m);
  sequence (*method_sequence)(ot_impl self);
  sequence (*type_dv_template)(ot_impl self);
  sequence (*class_dv_template)(ot_impl self);
  sequence (*compute_dh_template)(ot_impl self);
  sequence (*merge_type_headers)(ot_impl self, sequence types);
  bool (*can_embed)(ot_impl self, Pval *__retvals, sequence dh1, sequence dh2);
  bool (*dv_match)(ot_impl self, sequence dv1, sequence dv2);
  sequence (*merge_template)(ot_impl self, sequence to_merge, sequence current, int offset);
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
};

struct ot_impl_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*equal)(type_ self, type_ t);
  bool (*subtype_of)(type_ self, type_ t);
  type_Mmethods_Iter_State (*methods_START)(type_ self);
  int (*methods_LOOP)(type_ self, type_Mmethods_Iter_State IState);
  string (*unparse)(type_ self);
  method (*get_method)(type_ self, string name);
  int (*field_info)(type_ self, Pval *__retvals);
  sequence (*get_new_methods)(type_ self);
  void (*set_new_methods)(object_type self, sequence new_ms);
  void (*make_complete)(object_type self);
  object_typeMsupertypes_Iter_State (*supertypes_START)(object_type self);
  int (*supertypes_LOOP)(object_type self, object_typeMsupertypes_Iter_State IState);
  sequence (*supertypes_seq)(object_type self);
  object_typeMnew_methods_Iter_State (*new_methods_START)(object_type self);
  int (*new_methods_LOOP)(object_type self, object_typeMnew_methods_Iter_State IState);
  int (*dv_entry_size)(object_type self);
  int (*method_index)(object_type self, string name, object_type t);
  object_typeMmethod_renamings_Iter_State (*method_renamings_START)(object_type self, string name);
  int (*method_renamings_LOOP)(object_type self, object_typeMmethod_renamings_Iter_State IState);
  sequence (*get_renamings)(object_type self);
  sequence (*get_dh_template)(object_type self);
  sequence (*get_dv_template)(object_type self);
};

#include "bool.h"
#include "string.h"
#include "sequence.h"
#include "maybe.h"
#include "int.h"

struct ot_impl_f_s {
  struct Fields_s inh;
  th_bool complete;
  Shortp name_;
  Shortp supertypes_;
  Shortp methods_;
  int kind_;
  Shortp dh;
  Shortp dv;
  Shortp overview;
  Shortp ot_renamings;
};


#endif /* _OT_IMPL_H */
