#ifndef _PTYPE_H
#define _PTYPE_H

#include "ptype_def.h"
#include "meta_object.h"
#include "bool.h"
#include "method.h"
#include "object_type.h"
#include "sequence.h"
#include "param.h"
#include "instn.h"
#include "string.h"

#include "runtime/C/dummy_class.h"
extern struct Objtype_s *ptype_V;

struct ptypeMsupertypes_Iter_State_s {
int pc;
int spare;
object_type ret_0;
};

struct ptypeMparameters_Iter_State_s {
int pc;
int spare;
param ret_0;
};

struct ptypeMmethods_Iter_State_s {
int pc;
int spare;
method ret_0;
};

#ifdef __cplusplus
extern "C" {
#endif

extern bool ptypeMpt_equal(ptype self, ptype pt);
extern ptypeMsupertypes_Iter_State ptypeMsupertypes_START_(ptype self);
extern bool ptypeMsupertypes_LOOP_(ptype self, ptypeMsupertypes_Iter_State IState);
extern instn ptypeMinstantiate(ptype self, sequence args);
extern ptypeMparameters_Iter_State ptypeMparameters_START_(ptype self);
extern bool ptypeMparameters_LOOP_(ptype self, ptypeMparameters_Iter_State IState);
extern ptypeMmethods_Iter_State ptypeMmethods_START_(ptype self);
extern bool ptypeMmethods_LOOP_(ptype self, ptypeMmethods_Iter_State IState);
extern string ptypeMunparse(ptype self);

extern void Init_ptype();

#ifdef __cplusplus
}
#endif


struct ptype_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  string (*name)(meta_object self);
  int (*kind)(meta_object self);
  bool (*pt_equal)(ptype self, ptype pt);
  ptypeMsupertypes_Iter_State (*supertypes_START)(ptype self);
  int (*supertypes_LOOP)(ptype self, ptypeMsupertypes_Iter_State IState);
  instn (*instantiate)(ptype self, sequence args);
  ptypeMparameters_Iter_State (*parameters_START)(ptype self);
  int (*parameters_LOOP)(ptype self, ptypeMparameters_Iter_State IState);
  ptypeMmethods_Iter_State (*methods_START)(ptype self);
  int (*methods_LOOP)(ptype self, ptypeMmethods_Iter_State IState);
  string (*unparse)(ptype self);
};

#endif /* _PTYPE_H */
