#ifndef _TEXTWR_IMPL_H
#define _TEXTWR_IMPL_H

#include "textwr_impl_def.h"
#include "textwr.h"
#include "textwr_impl_inc.h"

#include "runtime/C/dummy_class.h"
extern struct Class_s *textwr_impl_V;

#ifdef __cplusplus
extern "C" {
#endif

extern void textwr_implMput_char_(textwr_impl self, char c);
extern void textwr_implMput_(textwr_impl self, string s);
extern string textwr_implMto_string_(textwr_impl self);
extern int textwr_implMlength_(textwr_impl self);
extern void textwr_implMpredict_(textwr_impl self, int cnt);
extern void textwr_implMflush_(textwr_impl self);
extern void textwr_implMclose_(textwr_impl self);

extern void Init_textwr_impl();

#ifdef __cplusplus
}
#endif


struct textwr_impl_class_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  void (*put_char)(wr self, char c);
  void (*put)(wr self, string s);
  int (*length)(wr self);
  void (*predict)(wr self, int cnt);
  void (*flush)(wr self);
  void (*close)(wr self);
  string (*to_string)(textwr self);
};

struct textwr_impl_DV {
  struct DV_hdr_s hdr;
  struct Class_s *(*get_class)(struct Obj_s *);
  void (*put_char)(wr self, char c);
  void (*put)(wr self, string s);
  int (*length)(wr self);
  void (*predict)(wr self, int cnt);
  void (*flush)(wr self);
  void (*close)(wr self);
  string (*to_string)(textwr self);
};

#include "array.h"
#include "bool.h"

struct textwr_impl_f_s {
  struct Fields_s inh;
  Shortp buf;
  th_bool closed;
};


#endif /* _TEXTWR_IMPL_H */
