/* Copyright 1995 Barbara Liskov */

#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "runtime/except.h"
#include "boot/wellknown.h"
#include "config/vdefs/COMPILER.h"
#include "th_Compiler.h"
#include "compiler.h"
#include <stdio.h>


extern char * theta_set_version(char * nm);
extern char * theta_compile(FILE *src, char *nm);
extern char * theta_parse(FILE *src, char * nm);
extern char * theta_check(FILE *src, char * nm);
extern char * theta_show();
extern char * theta_expunge();
extern char * theta_xcheck(FILE *src, char * nm);


char *Compiler::compile (char *args) {
  char *ret;
  FILE *src;
  char *errs;

  if (strlen(args) == 0) {
 	 ret = "Error: file name missing";
	 return ret;
  }
  if (args[0] == '-') {
	ret = theta_set_version(args);
	return ret;
	}
  src = fopen(args, "r");
  if (!src) {
  	ret = "Error: Line   -1: Can't open file";
  	return ret;
  }
  ret = theta_compile(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

char * Compiler::parse (char * args) {
  char * ret;
  FILE *src;
  char *errs;

  src = fopen(args, "r");
  if (!src) {
  	ret = "Error: Line   -1: Can't open file";
  	return ret;
  }
  ret = theta_parse(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

char * Compiler::check (char * args) {
  char * ret;
  FILE *src;
  char *errs;

  if (strlen(args) == 0) {
 	 ret = "Error: file name missing";
	 return ret;
  }
  src = fopen(args, "r");
  if (!src) {
  	ret = "Error: Line   -1: Can't open file";
  	return ret;
  }
  ret = theta_check(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

char * Compiler::xcheck (char * args) {
  char * ret;
  FILE *src;
  char *errs;

  if (strlen(args) == 0) {
         ret = "Error: file name missing";
         return ret;
  }
  src = fopen(args, "r");
  if (!src) {
        ret = "Error: Line   -1: Can't open file";
        return ret;
  }
  ret = theta_xcheck(src, args);
  fclose(src);
  /* RESIGNAL_ANY_EXC;     Could signal not_found */
  return ret;
}

char * Compiler::show () {
  char * ret;

  ret = theta_show();
  /* RESIGNAL_ANY_EXC; */
  return ret;
}

char * Compiler::expunge () {
  char * ret;

  ret = theta_expunge();
  return ret;
}

