

#include "parse.h"
#ifdef __cplusplus
extern "C" {
#endif
#include <stdio.h>
#include "types/str.h"
#include <unistd.h>
#include <ctype.h>
#include "types/objtype_class.h"
#include "types/vec.h"
#include "types/method.h"
#include "types/ptype.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/class_instn.h"
#include "types/class_instn_class.h"
#include "types/vec_instns.h"
#ifdef __cplusplus
}
#endif

extern int version;
static bool special_inv(string nm, string tnm, Invoc *inv, RoutineId *rid);
extern bool emit_iter_prefix();
extern string typestr2nm(string tnm);
extern bool inlined_fetch(type t, Expr *ex, ParseNodeList *exprs, string tmp,
				string tmpnm);
extern void inv_args_emit(Invoc *inv);
void output_base_method_str(const char *tnc, const char *enmc);


#include "cg.h"

/*
	Various routine to process expressions.
*/

ParseNodeList *exprs_preprocess(ParseNodeList *exprs)
{
   ParseNodeList *new_exprs = new ParseNodeList();
   if (exprs) for (Pix p = exprs->first(); p ; exprs->next(p)){
	Expr *ex = (Expr *)(*exprs)(p);
	Expr *ex2 = expr_preprocess(ex);
	new_exprs->append(ex2);
	}
   return new_exprs;
   }

bool cg_rhs = TRUE;

Expr *expr_preprocess(Expr *ex)
{
   switch (ex->tag()) {
	case Expr::NilT: {
		return ex;
		}
	case Expr::LiteralT: {
		return ex;
		}
	case Expr::InstantiationT: {
		// temporary
		cmp_err("expr_preprocess: instantiation", 0);
		return NULL;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		Expr *prim = de->get_primary();
		enter_forced_prep();
		Expr *new_prim = expr_preprocess(prim);
		leave_forced_prep();
		if (version == 0 || version == 1) {
			DotExpr *new_de = new DotExpr(new_prim, de->get_id());
			new_de->type_ = de->type_;
			fix_fix(new_de);
			return new_de;
			}
		else {
			string c_name;
			Expr *deid = de->get_id();
			IdExpr *deide = (deid->tag() == Expr::IdExprT) ?
						(IdExpr *)deid: 0;
			string nm = deide? deide->get_id()->get_id(): 0;
			bool ivar = nm? is_ivar_1(new_prim, nm, &c_name): 0;
			if (cg_rhs && ivar) {
                        	fix_read_1(new_prim);
				string types_name;   // more like class name...
				string tmp =get_next_temp_and_type(&types_name);
                        	ind();
                        	ps("GET");
                        	if (is_vtypestr(types_name)) ps("V_R(");
                        	else ps("P_IR(");
				emit_iter_prefix();
                        	pstr(tmp);
                        	ps(", ");
				expr_emit(new_prim);
				ps(", ");
                        	pstr(nm);
                        	ps(", ");
				pstr(c_name);
                        	if (!is_vtypestr(types_name)) {
					ps(", ");
					pstr(simple_type_name(types_name));
                                	ps(", ");
                                	pstr(typestr2nm(types_name));
					ps("_V");
                                	}
                        	ps(");\n");
				IdExpr *ide = new IdExpr(new Id(tmp));
				ide->type_ = de->type_;
				return ide;
				}
			else {
				DotExpr *new_de = new DotExpr(new_prim, 
							de->get_id());
				new_de->type_ = de->type_;
				return new_de;
				}
			}
		}
	case Expr::SuperIdT: {
		// Unlikely to get here...
		return ex;
		}
	case Expr::SelfT: {
		return ex;
		}
	case Expr::NewT: {
		// temporary
		cmp_err("expr_preprocess: new", 0);
		return NULL;
		}
	case Expr::ArrayRefT: {
		// temporary
		cmp_err("expr_preprocess: arrayref", 0);
		return NULL;
		}
	case Expr::InvocExprT: {
		InvocExpr *inve = (InvocExpr *)ex;
		Invoc *inv = inve->get_invoc();
		ParseNode *pn = inv_preprocess(inv);
		switch (pn->tag()) {
			case ParseNode::InvocT: {
				Invoc *new_inv = (Invoc *)pn;
				InvocExpr *new_inve = new InvocExpr(new_inv);
				new_inve->type_ = inve->type_;
				return new_inve;
				}
			case ParseNode::ExprT: {
				Expr *e = (Expr *)pn;
				if (e->tag() != Expr::IdExprT) {
					cmp_err("expr_preprocess: inv",0);
					return NULL;
					}
				IdExpr *ide = (IdExpr *)e;
				return ide;
				}
			}
		}
	case Expr::BindingExprT: {
		// temporary
		cmp_err("expr_preprocess: binding", 0);
		return NULL;
		}
	case Expr::SelectorConstrT: {
		SelectorConstr *sc = (SelectorConstr *)ex;
		// do allocation
		string types_name;	// more like class name...
		string tmp = get_next_temp_and_type(&types_name);
		types_name = simple_type_name(types_name);
		if (string_equal(types_name, string_new("maybe"))) {
			FieldInit *fi = (FieldInit *)(sc->get_fields()
								->front());
			Expr *new_ex = expr_preprocess(fi->get_expr());
			bool full = string_equal(fi->get_id()->get_id(),
						string_new("full"));
			ind();
			emit_iter_prefix();
			pstr(tmp);
			ps(" = (");
			pstr(types_name);
			ps(")(");
			if (version == 0 || version == 1) {
			if (full) ps("maybe_make(0, ");
			else ps("maybe_none(0, empty_");
			pstr(type2nm(sc->get_type()->get_type()));
			if (version == 2) ps("_");
			ps("V");
			if (full) {
				ps(", PV(");
				expr_emit(new_ex);
				ps(")");
				}
			ps("));\n");
			    }
			else {
			    if (full) {
				ps("MAKE_FULL_MAYBE(");
				type et = get_one_type(new_ex->get_type(), 88);
				if (is_vtype(et)) {
					pstr(type_name(et));
					ps("_wrap(");
					}
				else ps("Obj_as_PV(");
				expr_emit(new_ex);
				ps(")));\n");
				}
			    else ps("MAKE_EMPTY_MAYBE());\n");
			    }
			}
		else {
			bool select = string_equal(types_name, string_new("record"))||
			      string_equal(types_name, string_new("struct"))||
			      string_equal(types_name, string_new("oneof")) ||
			      string_equal(types_name, string_new("variant"));
			string supername = string_new("");
			ParseNodeList *fields = sc->get_fields();
			Invoc *inv = sc->get_invoc();
			if (version == 0 || version == 1) {
				ind();
				emit_iter_prefix();
				pstr(tmp);
				ps(" = (");
				pstr(types_name);
				ps(")NEW(struct ");
				pstr(types_name);
				ps("_s);\n");
				ind();
				ps("init_obj_hdr((obj)");
				emit_iter_prefix();
				pstr(tmp);
				ps(", ");
				pstr(types_name);
				if (version == 2) ps("_");
				ps("V);\n");
				// initialize fields
				if (!select) {
				   type t = sc->get_type()->get_type();
				   t = UNPV(type,vec_fetch(type_as_class(t)
						->superclass, 0));
				   supername = simple_type_name(type_name(t));
				   init_emit(select, types_name, supername,
					tmp, fields, inv);
				   }
				}
			else {
				ind();	
				ps("ALLOC_OBJ_I(");
				emit_iter_prefix();
				pstr(tmp);
				ps(", ");
				pstr(types_name);
				ps(", ");
				pstr(types_name);
				ps("_V);\n");
				if (!select) {
				   type t = sc->get_type()->get_type();
				   class_ ct = type_as_class(t);
				   if (vec_length(ct->superclass) > 0) {
					t = UNPV(type,vec_fetch(ct
						->superclass, 0));
					}
				   if (t) supername = simple_type_name(type_name(t));
				   init_emit_1(select, types_name, supername,
					tmp, fields, inv);
				   }
				}
			}
		// return temp used for allocation	
		IdExpr *ide = new IdExpr(new Id(tmp));
		ide->type_ = sc->type_;
		return ide;
		return NULL;
		}
	case Expr::ArrayConstrT: {
		// temporary
		cmp_err("expr_preprocess: arrayconstr", 0);
		return NULL;
		}
	case Expr::IdExprT: {
		if (cg_rhs) {
		    const char *dummy = "";
		    IdExpr *ide = (IdExpr *)ex;
		    string nm = ide->get_id()->get_id();
		    bool ivar = is_ivar(0, nm, &dummy);
		    if (ivar) {
			type t = ide->get_type()->get_type();
			if (version == 0 || version  == 1) {
				fix_read(nm, t, (char*)dummy);
				}
			else {
				fix_read_1(0);
	            		string tmp = get_next_temp();
		    		ind();
				ps("GET");
				if (is_vtype(t)) ps("V_F(");
				else ps("P_IF(");
				emit_iter_prefix();
				pstr(tmp);
				ps(", Fp_self, ");
				pstr(nm);
				ps(", ");
				pcname();
				if (!is_vtype(t)) {
					ps(", ");
					pstr(simple_type_name(type_name(t)));
					ps(", ");
					pstr(type2nm(t));
					ps("_V");
					}
				ps(");\n");
		    		IdExpr *nide = new IdExpr(new Id(tmp));
		    		nide->type_ = ide->type_;
				return nide;
				}
			}
		    }
		return ex;
		}
	case Expr::BinaryT: {
		Binary *b = (Binary *)ex;
		Expr *ex1 = expr_preprocess(b->get_op1());
		if (simple_expr(b->get_op2())) {
		    Binary *b2;
		    if (b->tag() == Binary::AndT)
		    	b2 = new Binary(Binary::AndT, ex1, b->get_op2());
		    else b2 = new Binary(Binary::OrT, ex1, b->get_op2());
		    b2->type_ = b->type_;
		    return b2;
		    }
		else {
	            string tmp = get_next_temp();
		    ps("\n");
		    ind();
		    if (b->tag() == Binary::AndT) {
		    	ps("if (");
		    	expr_emit(ex1);
		    	ps(") {\n");
			inc_ind();
			ind();
		    	Expr *ex2 = expr_preprocess(b->get_op2());
			emit_iter_prefix();
		    	pstr(tmp);
		    	ps(" = ");
		    	expr_emit(ex2);
		    	ps(";\n");
			ind();
			ps("}\n");
			dec_ind();
		    	ind();
		    	ps("else ");
			emit_iter_prefix();
		    	pstr(tmp);
		    	ps(" = FALSE;\n");
			}
		    else {
		    	ps("if (");
		    	expr_emit(ex1);
		    	ps(") ");
			emit_iter_prefix();
		    	pstr(tmp);
		    	ps(" = TRUE;\n");
		    	ind();
		    	ps("else {\n");
		    	inc_ind();
			ind();
		    	Expr *ex2 = expr_preprocess(b->get_op2());
		    	ind();
			emit_iter_prefix();
		    	pstr(tmp);
		    	ps(" = ");
		    	expr_emit(ex2);
		    	ps(";}\n");
		    	dec_ind();
			}
		    IdExpr *ide = new IdExpr(new Id(tmp));
		    ide->type_ = b->type_;
		    return ide;
		    }
		}
	case Expr::UnaryT: {
		// shouldn't occur
		cmp_err("expr_preprocess: unary", 0);
		return NULL;
		}
	case Expr::BracketRefT: {
		BracketRef *br = (BracketRef *)ex;
		bool parmd = inv_result_parmd(ex);
		Expr *new_prim = expr_preprocess(br->get_primary());
		type t = get_one_type(new_prim->get_type(), 
				new_prim->get_line());
		ParseNodeList *new_exprs = exprs_preprocess(br->get_exprs());
		string tname;
		string tmp = get_next_temp_and_type(&tname);
		if (cg_rhs) {
		    if (version == 0 || version == 1) {
			ind();
			emit_iter_prefix();
			pstr(tmp);
			ps(" = ");
			if (parmd) {
				ps("UNPV(");
				pstr(tname);
				ps(", ");
				}
			if (t && string_equal(
					string_new("string"), type_name(t))) {
				ps("string_fetch_(");
				}
			else {
				ps("(*");
				expr_emit(new_prim);
				ps(")");
				ps("->fetch(");
				}
			// if (parmd) ps("PBLOCK, ");
			expr_emit(new_prim);
			ps(", ");
			exprs_emit(new_exprs);
			if (parmd) ps(")");
			ps(");\n");
			// possibly make this optional
   			ind();
   			ps("if(exc) ");
   			exc_goto_exc(FALSE);
			IdExpr *ide = new IdExpr(new Id(tmp));
			ide->type_ = br->type_;
			return ide;
			}
		   else {
		     if (inlined_fetch(t, new_prim, new_exprs, tmp, tname)) {}
		     else {
			ind();
			emit_iter_prefix();
			pstr(tmp);
			ps(" = ");
			if (parmd) {
				if (is_vtypestr(tname)) ps("PV_as_prim(");
				else ps("PV_as_obj(");
				pstr(simple_type_name(tname));
				ps(", ");
				}
			if (t && !strcmp("string",string_charp(type_name(t)))) {
			      	ps("string_fetch_(");
				expr_emit(new_prim);
				ps(", ");
				exprs_emit(new_exprs);
				ps(");\n");
			      	}
			else {
				ps("((DISPATCH_D(");
				expr_emit(new_prim);
				ps(", fetch, ");
				pstr(simple_type_name(type_name(t)));
				ps("))(");
				expr_emit(new_prim);
				ps(", ");
				exprs_emit(new_exprs);
				if (parmd) ps(")");
				ps("));\n");
				}
			}
			ind();
			ps("if(Exc) ");
			exc_goto_exc(FALSE);
			IdExpr *ide = new IdExpr(new Id(tmp));
			ide->type_ = br->type_;
			return ide;
			}
		    }
		return NULL;
		}
	case Expr::BraceRefT: {
		// temporary
		cmp_err("expr_preprocess: braceref", 0);
		return NULL;
		}
	}
   }

Expr *inv_preprocess_lastarg(ParseNodeList *lastarg, method m);

ParseNode *inv_preprocess(Invoc *inv)
{
   RoutineId* rid = inv->get_routineId();
   RoutineId* nrid;
   method m = rid->get_type()->get_method();
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		Expr *new_ex = expr_preprocess(ex);
		nrid = new SimpleRoutineId(new_ex);
		nrid->type_ = srid->type_;
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		ComplexRoutineId *crid = (ComplexRoutineId *)rid;
		Expr *ex = crid->get_primary();
		ParseNodeList *actuals = crid->get_parms();
		Expr *new_ex = expr_preprocess(ex);
		nrid = new ComplexRoutineId(new_ex, actuals);
		nrid->type_ = crid->type_;
		break;
		}
	case RoutineId::SuperClassRoutineIdT: {
		SuperClassRoutineId *scid = (SuperClassRoutineId *)rid;
		nrid = scid;
		break;
		}
	default: {
		cmp_err("inv_preprocess ignoring complex rid or superc rid",
			inv->get_line());
		}
	}
   ParseNodeList *exprs = inv->get_exprs();
   ParseNodeList *new_exprs = exprs_preprocess(exprs);
   ParseNodeList *lastarg = inv->get_lastarg();
   ParseNodeList *new_lastarg = 0;
   if (lastarg) new_lastarg = exprs_preprocess(lastarg);
   if (new_lastarg) {
		Expr *ex = inv_preprocess_lastarg(new_lastarg, m);
		new_exprs->append(ex);
		}
   Invoc *new_inv = new Invoc(nrid, new_exprs, 0, 0);
   new_inv->type_ = inv->type_;
   type t;
   // 9/22/95: added test on t, because inv_signalling now returns true if
   //			inv signals and need to test t to see if there's a ret val.
   if (!m->mkr && !m->iter && (inv_signalling(new_inv, &t)
			|| forced_prep()) && t) {
	string types_name;
	string temp = get_next_temp_and_type(&types_name);
	if (special_inv(temp, types_name, new_inv, nrid)) {}
	else {
		ind();
		emit_iter_prefix();
		pstr(temp);
		ps(" = ");
		inv_emit(new_inv, NULL, NULL);
		ps(";\n");
		}
	inv_check_emit(new_inv);
	Expr *new_id = new IdExpr(new Id(temp));
	new_id->type_ = inv->type_;
	return new_id;
	}
   else {
	return new_inv;
	}
   }

static method method_being_invoked;
Expr *inv_preprocess_lastarg(ParseNodeList *lastarg, method m)
{
string atype;
string stype;
string atmp = get_next_temp_and_type(&atype);
string stmp = get_next_temp_and_type(&stype);
bool prim = is_vtypestr(atype);

   ind();
   emit_iter_prefix();
   pstr(atmp);
   ps(" = ");
   if (prim) ps("PV_as_prim");
   else ps("PV_as_obj");
   ps("(array, array_new_predict(array_new_predict_FOR_");
   pstr(typestr2nm(atype));
   ps("_V, ");
   pint(lastarg->length());
   ps("));\n");
   for (Pix p = lastarg->first(); p; lastarg->next(p)) {
	Expr *ex = (Expr*)(*lastarg)(p);
	ind();
	ps("ARRAY_APPEND(");
   	emit_iter_prefix();
	pstr(atmp);
	ps(", ");
	if (prim) ps("Prim_as_PV(");
	else ps("Obj_as_PV(");
	expr_emit(ex);
	ps("));\n");
	}
   ind();
   emit_iter_prefix();
   pstr(stmp);
   ps(" = ");
   ps("move_array_to_sequence(move_array_to_sequence_FOR_");
   pstr(typestr2nm(atype));
   ps("_V, ");
   emit_iter_prefix();
   pstr(atmp);
   ps(");\n");
   vec args = m->arguments;
   int nargs = vec_length(args);
   formal f = UNPV(formal, vec_fetch(args, nargs-1));
   type ft = f->t;
   Expr *new_id = new IdExpr(new Id(stmp));
   new_id->type_ = new TypeInterface(ft);
   return new_id;
   }

static bool special_inv(string temp_nm, string types_name, Invoc *inv, 
			RoutineId *rid)
{
   if (version == 0 || version == 1) return FALSE;
	
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		switch (ex->tag()) {
		    case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			TypeInterface *ti = de->get_primary()->get_type();
			type t = get_one_type(ti, de->get_line());
			if (!t) return FALSE;
			const char *tn = string_charp(simple_type_name(
							type_name(t)));
			if (!strcmp(tn, "int")) {
				Expr *deid = de->get_id();
				string enm;
				switch (deid->tag()) {
					case Expr::IdExprT: {
					IdExpr *ide = (IdExpr *)deid;
					enm = ide->get_id()->get_id();
					const char *mnm = string_charp(enm);
					if (!strcmp(mnm, "add") ||
					    !strcmp(mnm, "subtract") ||
					    !strcmp(mnm, "negate") ||
					    !strcmp(mnm, "multiply") ||
					    !strcmp(mnm, "divide") ||
					    !strcmp(mnm, "mod") ||
					    !strcmp(mnm, "abs")) {
						ParseNodeList *exprs = 
							inv->get_exprs();
						ind();
						psc(tn);
						ps("_");
						psc(mnm);
						ps("(");
						emit_iter_prefix();
						pstr(temp_nm);
						ps(", ");
						expr_emit(de->get_primary());
						if (exprs && exprs->length()) {
							ps(", ");
							exprs_emit(exprs);
							}
						ps(");\n");
						return TRUE;
						}
					}
				}
			   }
			if (!strcmp(tn, "array") || !strcmp(tn, "vector") ||
					!strcmp(tn, "sequence")) {
				Expr *deid = de->get_id();
				string enm;
				switch (deid->tag()) {
					case Expr::IdExprT: {
					IdExpr *ide = (IdExpr *)deid;
					enm = ide->get_id()->get_id();
					const char *mnm = string_charp(enm);
					if (!strcmp(mnm, "fetch")) {
						ParseNodeList *exprs = 
							inv->get_exprs();
						ind();
						if (version == 0 || 
							version == 1) {
							psc(tn);
							ps("_");
							psc(mnm);
							}
						else {
							output_base_method_str(
								tn,mnm);
							}
						ps("(");
						emit_iter_prefix();
						ps("MT_1, ");
						expr_emit(de->get_primary());
						if (exprs && exprs->length()) {
							inv_args_emit(inv);
							}
						ps(");\n");
						ind();
						pstr(temp_nm);
						ps(" = ");
						if (is_vtypestr(types_name))
						     	ps("PV_as_prim(");
						else ps("PV_as_obj(");
						pstr(simple_type_name(
							types_name));
						ps(", MT_1);\n");	
						return TRUE;
						}
					}
				}
			   }
			}
		   }
		}
	   }
    return FALSE;
    }

static Invoc *inv_being_processed;
void pn_emit(ParseNode *pn)
{
	switch (pn->tag()) {
		case ParseNode::InvocT: {
			Invoc *inv = (Invoc *)pn;
			inv_emit(inv, NULL, NULL);
			break;
			}
		case ParseNode::ExprT: {
			Expr *ex = (Expr *)pn;
			expr_emit(ex);
			break;
			}
		case ParseNode::RoutineIdT: {
			RoutineId *rid = (RoutineId *)pn;
			// DO NOT EXPAND THIS CODE: split off the relevant
			// stuff from inv_emit!!!!!!
   			switch (rid->tag()) {
			    case RoutineId::SimpleRoutineIdT: {
				SimpleRoutineId *srid = (SimpleRoutineId *)rid;
				Expr *ex = srid->get_primary();
				// NOT COOL
				method_being_invoked = 
					srid->get_type()->get_method();
   				// is_parmd = inv_parmd(method_being_invoked);
				switch (ex->tag()) {
		   		    case Expr::IdExprT: {
					IdExpr *ide = (IdExpr *)ex;
					string iname = ide->get_id()->get_id();
					bool is_meth = is_method(iname);
					string rtn_nm = string_concat(iname,
						string_new("_Rtn_Class_Obj"));
					expr_emit(ex);
					break;
					}
				    default: {
					cmp_err("pn_emit: don't like this ex",
							200);
					}
				    }
				break;
				}
			    default: {
				cmp_err("pn_emit: don't like this rid", 200);
				}
			    }
			break;
			}
		default: {
			cmp_err("Unexpected node in pn_emit", 0);
			}
	}
   }

static inside_inv = FALSE;
static int nth_expr = 0;

bool parmd_site()
{

// The purpose of this routine is to determine whether the expr
//	about to be emitted should be converted to a pval.
//	This is true, for instance, for the store method of of
//	an array.

// if the type of the nth_expr arg of current method is derived from
//	a parameter return true
type slft;
fevalue tgm_ret[2];

	if (inside_inv == 0) return FALSE;
	slft = method_being_invoked->self_type;
        if (!slft) { // routine, not method
		if (!method_being_invoked->parameterized) return FALSE;
		RoutineId *rid = inv_being_processed->get_routineId();
		ComplexRoutineId *crid = (ComplexRoutineId*)rid;
		Expr *prim = crid->get_primary();
		TypeInterface *ti = prim->get_type();
		method m = ti->get_pmethod();
		vec args = m->arguments;
		formal f = UNPV(formal, vec_fetch(args, nth_expr));
		type ft = f->t;
		if (type_kind(ft) == PARAM_KIND) return TRUE;
		return FALSE;
		}
	ptype pt = 0;
	if (type_kind(slft) == INSTN_KIND) {
		instn ins = type_as_instn(slft);
		if (ins) pt = instn_ptype(ins);
		}
	else if (type_kind(slft) == CLASS_INSTN_KIND) {
		class_instn ci = type_as_class_instn(slft);
		if (ci) pt = ci->hdr.methods->get_ptype(ci);
		}
	if (pt == 0) return FALSE;
	string nm = method_being_invoked->name;
	RESET_EXC
	getMethod(type_as_objtype(ptype_as_type(pt)), tgm_ret, nm);
	CATCH { return FALSE; }
	method m = (method)tgm_ret[0].o;
	vec args = m->arguments;
	formal f = UNPV(formal, vec_fetch(args, nth_expr));
	type ft = f->t;
	if (type_kind(ft) == PARAM_KIND) return TRUE;
	return FALSE;
	}

bool anyize_site(Expr *ex)
{
// The purpose of this routine is to determine whether the expr
//	about to be emitted should be converted to an any.

// if the type of the nth_expr arg of current method is an any
//	anyize it (except if it's already an any)

	// ? appropriate?
	if (inside_inv == 0) return FALSE;

	vec args = method_being_invoked->arguments;
	formal f = UNPV(formal, vec_fetch(args, nth_expr));
	type ft = f->t;
// 6/17/97: dwc: well, the formal type *is* any for same object...
// so do the simple cast and no subroutine call (TRUE would mean a closing
// paren should be emitted by the caller...
	if (!strcmp(string_charp(method_being_invoked->name), "same_object")
		&& nth_expr == 1) {
		ps("(any)");
		return FALSE;
		}
	if (!strcmp(string_charp(method_being_invoked->name), "same_object"))
			return anyize_it(ft);
	if (ft == objtype_as_type(Any)) return anyize_it(ft);
	return FALSE;
	}

bool cast_site(Expr *ex)
{
// The purpose of this routine is to determine whether the expr
//	about to be emitted should be cast to some other type.

	// ? appropriate?
	if (inside_inv == 0) return FALSE;

	TypeInterface *ti = ex->get_type();
	type t = ti->get_type();
	if (!t) {
		vec v = ti->get_mult();
		if (vec_length(v) > 0) {
			t = UNPV(type, vec_fetch(v, 0));
			}
		}
	if (!t) return FALSE;	// possibly simplistic
	// RESET_EXC
	// class_ c = type_as_class(t);
	// CATCH { return FALSE; }
	// else {
		vec args = method_being_invoked->arguments;
		formal f = UNPV(formal, vec_fetch(args, nth_expr));
		type ft = f->t;
		if (ft == objtype_as_type(Any)) return FALSE;
		string ftnm = type_name(ft);
		if (t && string_equal(ftnm, type_name(t))) return FALSE;
		ps("((");
		pstr(type_name(ft));
		ps(") ");
		return TRUE;
	  //    }
	}

bool assn_cast_site(ParseNode *pn, type rt)
{
    type lt = 0;
    switch (pn->tag()) {
      case ParseNode::ExprT: {
	Expr *lhex = (Expr *)pn;
	lt = get_one_type(lhex->get_type(), lhex->get_line());
	break;
	}
      case ParseNode::DeclT: {
	Decl *d = (Decl *)pn;
	TypeInterface *ti = pn->get_type();
	lt = get_one_type(ti, d->get_line());
	break;
 	}
      case ParseNode::IdT: {
	Id *id = (Id *)pn;
	TypeInterface *ti = id->get_type();
	lt = get_one_type(ti, pn->get_line());
	break;
	}
     }

// so we already know that rt isSubtype of lt, but
//	we need to figure out if they are exactly the
//	same type or not.  if not, a cast needs to be done.
//	so, emit the cast if necessary and return the bool
	if (!lt) {
		cmp_err("Missing type info", pn->get_line());
		return FALSE;
		}
	if (rt && isSubtype(lt, rt)) return FALSE;
	ps("((");
	pstr(simple_type_name(type_name(lt)));
	ps(")");
	return TRUE;
   }

type get_nth_return_type(int nth)
{
   vec v = method_being_invoked->returns;
   if (v && nth < vec_length(v)) {
	return UNPV(type, vec_fetch(v, nth));
	}
   return class_as_type(Null);
   }

void emit_supers(Expr *prim, string mname, const char **casting)
{
fevalue tgm_ret[2];

    /* find objtype (if any) for private search */
    objtype ot = 0;
    type t = 0;
    ClassDef *save_cd = get_save_class();
    if (prim)  {
	t = get_one_type(prim->get_type(), prim->get_line());
        if (!t) {
            cmp_err("Losing in emit_supers (1)", prim?prim->get_line():0);
	    return;
	    }
	if (type_kind(t) == PARAM_KIND) return;
        if (save_cd && (t == save_cd->get_type()->get_type())) 
			ot = class_as_objtype(save_stripped_class);
	else ot = type_as_objtype(t);
	}
    else {
	if (!save_cd) {
           cmp_err("Losing in emit_supers (2)", prim?prim->get_line():0);
	   return;
	   }
	t = save_cd->get_type()->get_type();
	ot = class_as_objtype(save_stripped_class);
	}

// Temporary hack to decrease warning messages 12/9/96
//	- turned off the following segment
//	- swapped segments 2 & 3: look at type &st first

    /* look for private method if ot exists
    if (ot)
	{
	vec save_supers = ot->supertypes_;
    	ot->supertypes_ = make_vec_simple(Type, 0);
	RESET_EXC;
    	getMethod(ot, tgm_ret, mname);
    	CATCH {ot->supertypes_ = save_supers; exc = EXC_NONE;}
    	else {
		ot->supertypes_ = save_supers; 
		method m = (method)tgm_ret[0].o;
		*casting = string_charp(simple_type_name(
				type_name(m->self_type)));
		return;
		}
	}
    */

    /* look at full ot... */
    if (ot)
	{
	RESET_EXC;
    	getMethod(ot, tgm_ret, mname);
    	CATCH {exc = EXC_NONE;}
    	else {
		method m = (method)tgm_ret[0].o;
		*casting = string_charp(simple_type_name(
				type_name(m->self_type)));
		return;
		}
	}

    /* this method belongs to the supertype (only appears to be one of them) */
    if (version == 0 || version == 1) ps("super.");
    type st = 0;
    if (t) {
	RESET_EXC;
    	getMethod(type_as_objtype(t), tgm_ret, mname);
    	CATCH {
		exc = EXC_NONE; 
		cmp_err("Losing in emit_supers (3)", prim?prim->get_line():0); 
		return;
		}
	else {
		method m = (method)tgm_ret[0].o;
		*casting = string_charp(simple_type_name(
				type_name(m->self_type)));
		return;
	// ot = type_as_objtype(t);
	// if (ot->supertypes_ && vec_length(ot->supertypes_)) {
		// st = UNPV(type, vec_fetch(ot->supertypes_, 0));
		// *casting = string_charp(type_name(st));
		// }
		}
	}
    else cmp_err("Losing in emit_supers (4)", prim?prim->get_line():0);
    }

string parms2nm(ParseNodeList *l);
string crid2instn(ComplexRoutineId *crid)
{
    // Completely arbitrary == Total Hack...
    string nm = string_empty();
    char *tnm = "";
    Expr *ex = crid->get_primary();
    switch (ex->tag()) {
	case Expr::IdExprT: {
		IdExpr *ide = (IdExpr *)ex;
		nm = ide->get_id()->get_id();
		const char *nmc = string_charp(nm);
		if (version == 0 || version == 1) {
		    if (string_equal(nm, string_new("array_new")))
			nm = string_new("array");
		    if (string_equal(nm, string_new("vector_fill")))
			nm = string_new("vector");
		    if (string_equal(nm, string_new("vector_create")))
			nm = string_new("vector");
		    if (string_equal(nm, string_new("sequence_create")))
			nm = string_new("sequence");
			}
		else {
		    if (string_equal(nm, string_new("array_new")))
			tnm = "array";
		    if (string_equal(nm, string_new("array_new_predict")))
			tnm = "array";
		    if (string_equal(nm, string_new("vector_fill")))
			tnm = "vector";
		    if (string_equal(nm, string_new("vector_create")))
			tnm = "vector";
		    if (string_equal(nm, string_new("sequence_create")))
			tnm = "sequence";
		    if (!strcmp(nmc, "array_to_sequence"))
			tnm = "array";
		    if (!strcmp(nmc, "move_array_to_sequence"))
			tnm = "array";
		    if (!strcmp(nmc, "move_array_to_vector"))
			tnm = "array";
		    if (!strcmp(nmc, "array_to_vector"))
			tnm = "array";
		    if (!strcmp(nmc, "vector_to_sequence"))
			tnm = "vector";
		    if (!strcmp(nmc, "vector_to_array"))
			tnm = "vector";
		    if (!strcmp(nmc, "sequence_to_array"))
			tnm = "sequence";
		    if (!strcmp(nmc, "sequence_to_vector"))
			tnm = "sequence";
			}
		break;
		}
	default: {
		cmp_err("crid2instn: unexpected expr", crid->get_line());
		}
	}
    ActualParm *ap = (ActualParm*)crid->get_parms()->front();
    TypeInterface *ti = ap->get_type();
    type t = ti->get_type();
    // The following does not reflect version 0 or version 1...
    nm = string_concat(nm, string_concat(string_new("_FOR_"), 
		string_concat(string_new(tnm), 
		string_concat(string_new("_OF_"),
		string_concat(type2nm(t), string_new("_V"))))));
    return nm;
    }

bool rid_emit(Invoc *inv, RoutineId *rid, int pass, Expr **prim, bool *is_supercm, 
	bool *is_meth, const char **casting, string *supercnm, string *rtn_nm)
{
   method m = rid->get_type()->get_method();
   bool parmd_result = inv_result_parmd(inv);
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		m = srid->get_type()->get_method();
		switch (ex->tag()) {
		    case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			*prim = de->get_primary();
			if (base_inv_emit(inv, de, parmd_result, pass)) return TRUE;
			Expr *deid = de->get_id();
   			Id *meth = NULL;
			switch (deid->tag()) {
				case Expr::IdExprT: {
					IdExpr *ide = (IdExpr *) deid;
					meth = ide->get_id();
					string mname = meth->get_id();
					if (version == 0 || version == 1) {
						ps("(*");
						expr_emit(*prim);
						ps(")");
						ps("->");
						emit_supers(*prim, mname, 
							casting);
						pstr(mname);
						}
					else {
					   if ((*prim)->tag() == Expr::SelfT) {
						emit_supers(*prim,mname,casting);
						ps("(DISPATCH_SELF(");
						pstr(mname);
						if (m->iter) {
					  	    if (pass == 0) ps("_START");
						    if (pass == 1) ps("_LOOP");
					 	    }
						ps("))");
						}
					   else {
						ps("(DISPATCH_D(");
						expr_emit(*prim);
						ps(", ");
						// the following computes
						// "casting" but doesn't emit...
						emit_supers(*prim, mname, 
							casting);
						pstr(mname);
						if (m->iter) {
					  	    if (pass == 0) ps("_START");
						    if (pass == 1) ps("_LOOP");
					 	    }
						ps(", ");
						type t = get_one_type(
							(*prim)->get_type(), 99);
						pstr(simple_type_name(
							type_name(t)));
						ps("))");
						}
					    }
					break;
					}
				case Expr::SuperIdT: {
					SuperId *sid = (SuperId *) deid;
					meth = sid->get_id();
					*is_supercm = TRUE;
					type t = get_one_type((*prim)->get_type(),
							99);
					class_ c = type_as_class(t);
					if (c->superclass && 
						vec_length(c->superclass)) {
						c = UNPV(class_, vec_fetch(
							c->superclass, 0));
						*supercnm = type_name(
							class_as_type(c));
						pstr(*supercnm);
						if (version == 0||version == 1)
						     ps("_");
						else ps("M");
						pstr(meth->get_id());
						ps("_");
						}
					break;
					}
				}
			break;
			}
		   case Expr::IdExprT: {
			IdExpr *ide = (IdExpr *)ex;
			string iname = ide->get_id()->get_id();
			*is_meth = is_method(iname);
			if (version == 0 || version == 1) {
				if (*is_meth) {
					ps("(*self");
					ps(")");
					ps("->");
					emit_supers(0, iname, casting);
					}
				expr_emit(ex);
				}
			else {
				if (*is_meth) {
					ps("(DISPATCH_SELF(");
					emit_supers(0, iname, casting);
					expr_emit(ex);
					if (m->iter) {
					    if (pass == 0) ps("_START");
					    if (pass == 1) ps("_LOOP");
					    }
					/*
					ps(", ");
					if (casting) psc(*casting);
					else {
						type t = get_save_class()->
							get_type()-> get_type();
						pstr(type_name(t));
						}
					*/
					ps("))");
					}
				else {
					*rtn_nm = string_concat(iname,
						string_new("_Rtn_Class_Obj"));
					pstr(iname);
					// The following is more general, but doesn't
					// do the right thing for globally known rtns
					// (because it adds the iter prefix...)
					// expr_emit(ex);
					if (m->iter) {
					    if (pass == 0) ps("_START");
					    if (pass == 1) ps("_LOOP");
					    }
					}
				}
			break;
			}
		   default: {
			cmp_err("inv_emit not dealing", ex->get_line());
			}
		   }
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		ComplexRoutineId *crid = (ComplexRoutineId *)rid;
		m = crid->get_type()->get_method();
		if (m->parameterized) *rtn_nm = crid2instn(crid);
		Expr *ex = crid->get_primary();
		expr_emit(ex);
		// probably needs work to do something about actuals
		break;
		}
	case RoutineId::SuperClassRoutineIdT: {
		SuperClassRoutineId *scid = (SuperClassRoutineId *)rid;
		*is_meth = TRUE;
		ClassDef *cd = get_save_class();
		type t = cd->get_type()->get_type();
		class_ c = type_as_class(t);
		class_ sc = UNPV(class_, vec_fetch(c->superclass, 0));
		*is_supercm = TRUE;
		*supercnm = type_name(class_as_type(sc));
		pstr(*supercnm);
		if (version == 0 || version == 1) ps("_");
		else ps("M");
		Id *id = scid->get_id();
		pstr(id->get_id());
		ps("_");
		break;
		}
	default: {
		cmp_err("inv_emit ignoring complex rid or superc rid",
			inv->get_line());
		}
	}
   return FALSE;
   }

void self_obj_emit(const char *casting, bool is_supercm, string supercnm,
			Expr *prim, bool is_meth, string mkslfnm,
			string mkslfst, string rtn_nm)
{
   if (casting) { ps("(("); psc(casting); ps(")"); }
   if (is_supercm) {
	ps("(");
	pstr(supercnm);
	ps(")");
	}
   if (prim) expr_emit(prim);
   else {
	if (is_meth) ps("self");
        else { // not method
	     if (mkslfnm) {
		ps("(");
		pstr(mkslfst);
		ps(")");
		pstr(mkslfnm);
		}
	     else {
		if ((version == 0 || version == 1) && !rtn_nm) ps("0");
		if (rtn_nm) {
			if (version == 0 || version == 1) ps(", ");
			pstr(rtn_nm);
			if (version == 0 || version == 1) ps("V");
			}
		}
	     }
	}
   if (casting) ps(")");
   }

void inv_args_emit(Invoc *inv)
{
   RoutineId* rid = inv->get_routineId();
   method m = rid->get_type()->get_method();
   ParseNodeList *exprs = inv->get_exprs();
   method_being_invoked = m;
   inv_being_processed = inv;
   bool save_inside_inv = inside_inv;
   inside_inv = TRUE;
   // if more than one result, put in buffer for other results here.
   if (!m->iter && m->returns && vec_length(m->returns) > 1) {
	ps(", ");
	emit_iter_prefix();
	ps("__extravals");
	}
   if (exprs && exprs->length() > 0) ps(", ");
   exprs_emit(exprs);
   inside_inv = save_inside_inv;
   }

void inv_emit(Invoc *inv, string mkslfst, string mkslfnm)
{
   RoutineId* rid = inv->get_routineId();
   Expr *prim = NULL;
   method m = rid->get_type()->get_method();
   bool is_supercm = FALSE;
   bool is_meth = FALSE;
   // bool is_parmd = FALSE;
   bool parmd_result = inv_result_parmd(inv);
   const char *casting = 0;
   string supercnm = 0;
   string rtn_nm = 0;
   if (parmd_result) {
	type rett = UNPV(type, vec_fetch(m->returns, 0));
	string rettnm = simple_type_name(type_name(rett));
	if (version == 0 || version == 1) {
		ps("UNPV(");
		pstr(rettnm);
		ps(", ");
		}
	else {
		if (is_vtypestr(rettnm)) ps("PV_as_prim(");
		else ps("PV_as_obj(");
		pstr(rettnm);
		ps(", ");
		}
	}
   if (rid_emit(inv, rid, 0, &prim, &is_supercm, &is_meth, &casting, 
		&supercnm, &rtn_nm)) return;
   ps("(");
   // if (is_parmd) ps("PBLOCK, ");
   self_obj_emit(casting, is_supercm, supercnm, prim, is_meth, mkslfnm,
		mkslfst, rtn_nm);
   inv_args_emit(inv);
   ps(")");
   if (parmd_result) ps(")");
   }

void inv_check_emit(Invoc *inv)
{
   type dummy;
   if (inv_signalling(inv, &dummy)) {
   	ind();
	if (version == 0 || version == 1) ps("if(exc) ");
	else ps("if(Exc) ");
   	exc_goto_exc(FALSE);
	}
   }

void pn_check_emit(ParseNode *pn)
{
   // can arrive here with either Invoc or IdExpr
   // 	don't do anything for IdExpr
   switch (pn->tag()) {
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		inv_check_emit(inv);
		}
	}
   }

bool base_inv_emit(Invoc *inv, DotExpr *de, bool parmd_result, int pass)
{
	TypeInterface *ti = de->get_primary()->get_type();
	type t = get_one_type(ti, de->get_line());
	if (!t) return FALSE;
   	RoutineId* rid = inv->get_routineId();
	method m = rid->get_type()->get_method();
	string tn = simple_type_name(type_name(t));
	const char *tnc = string_charp(tn);
	if (!strcmp(tnc, "int") || !strcmp(tnc, "char") ||
		!strcmp(tnc, "bool") || !strcmp(tnc, "real") ||
		!strcmp(tnc, "null") || !strcmp(tnc, "maybe") ||
		// Technically, string doesn't need to be here
		//	except for maybe some inconsistency of
		//	the string*.h files w.r.t. assumptions
		//	about whether foo points to methods or class...
		!strcmp(tnc, "string") || !strcmp(tnc, "array") ||
		!strcmp(tnc, "vector") || !strcmp(tnc, "sequence")) {
		Expr *deid = de->get_id();
		string enm;
		switch (deid->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)deid;
				enm = ide->get_id()->get_id();
				break;
				}
			case Expr::SuperIdT: {
				// really shouldn't happen because
				// base types only have "any" as a
				// superclass and "any" doesn't have
				// inheritable methods.
				SuperId *sid = (SuperId *)deid;
				enm = sid->get_id()->get_id();
				break;
				}
			}
		const char *enmc = string_charp(enm);
		// only inline some methods (store/append) of array/vector/seq
		if (!strcmp(tnc, "array"))  {
			if (!strcmp(enmc, "store") || !strcmp(enmc, "append")) {}
			else return FALSE;
			}
		if (!strcmp(tnc, "vector")) {
			if (!strcmp(enmc, "store")) {}
			else return FALSE;
			}
		if (strcmp(tnc, "maybe")) {
			// Handle everything except maybes here...
			if (version == 0 || version == 1) {
				pstr(tn);
				ps("_");
				pstr(enm);
				}
			else {
				output_base_method_str(tnc, enmc);
				}
			// Yuck...
			if (!strcmp(tnc, "string") &&
				(!strcmp(enmc, "empty") ||
				 !strcmp(enmc, "fetch"))) ps("_");
			if (m->iter) {
				if (pass == 0) ps("_START");
				if (pass == 1) ps("_LOOP");
				return TRUE;
				}
			ps("(");
			expr_emit(de->get_primary());
			ParseNodeList *exprs = inv->get_exprs();
			if (exprs && exprs->length()) {
				inv_args_emit(inv);
				}
			if (parmd_result) ps(")");
			ps(")");
			return TRUE;
			}
		else {	// handle ugly old maybe's
			TypeInterface *ti = inv->get_type();
			type t = get_one_type(ti, inv->get_line());
			// if (is_vtype(t)) {
			// 	cmp_err("Maybe's of value types not "
			// 		"supported in Thor1", inv->get_line());
			// 	}
			if (is_vtype(t) && !strcmp(enmc, "value_full")) {
				pstr(type_name(t));
				ps("_unwrap((");
				pftname(t);
				ps(")");
				}
			pstrup(tn);
			ps("_");
			pstrup(enm);
			ps("(");
			expr_emit(de->get_primary());
			// ps(", ");
			// pstr(simple_type_name(type_name(t)));
			if (is_vtype(t) && !strcmp(enmc, "value_full"))
				ps(")");
			if (parmd_result) ps(")");
			ps(")");
			return TRUE;
			}
	     	}
	return FALSE;
	}

void exprs_emit(ParseNodeList *exprs)
{
bool do_comma = FALSE;

   method save_method = method_being_invoked;
   Invoc *save_inv = inv_being_processed;
   int save_nth_expr = 0;
   if (exprs) for (Pix p = exprs->first(); p ; exprs->next(p)) {
	nth_expr = save_nth_expr;
	method_being_invoked = save_method;
        inv_being_processed = save_inv;
	if (do_comma) ps(", ");
	Expr *ex = (Expr *)(*exprs)(p);
	bool do_pv = parmd_site();
   	if (do_pv) {
		if (version == 0 || version == 1) ps("PV(");
		else {
			type t = get_one_type(ex->get_type(), 88);
			if (is_vtype(t)) ps("Prim_as_PV(");
			else ps("Obj_as_PV(");
			}
		}
	// 12/10/96 dwc: moved these calls after pv stuff to cure
	//	warning about 3rd arg to vector_fill
	bool close_cast = cast_site(ex);
	bool close_any = anyize_site(ex);
	expr_emit(ex);
   	if (do_pv) ps(")");
	if (close_any) ps(")");
	if (close_cast) ps(")");
	do_comma = TRUE;
	save_nth_expr++;
	}
   }

extern char *print_version(char c);
extern void print_version(string s);

/* this routine emits exprs without the iter prefix.  used in opt code. */
void expr_emit_local(Expr *ex)
{
   if (ex) switch (ex->tag()) {
	case Expr::IdExprT: {
		const char *c_name = "";
		IdExpr *ie = (IdExpr *)ex;
		string nm  = ie->get_id()->get_id();
		bool ivar = is_ivar(0, nm, &c_name);
		if (ivar) {
			if (version == 2) {
				cmp_err("Shouldn't get here..", 87);
				}
			ps("((");
			psc(c_name);
			ps("_C)self)->");
			pstr(nm);
			}
		else {
			pstr(nm);
			}
		break;
		}
	default: {
		cmp_err("Unexpected expr in expr_emit_local.", 500);
		}
	}
    }

void expr_emit(Expr *ex)
{
   if (ex) switch (ex->tag()) {
	case Expr::NilT: {
		ps("0");
		break;
		}
	case Expr::LiteralT: {
	    Literal *lit = (Literal *)ex;
	    switch (lit->tag()) {
		case Literal::IntLiteralT: {
			IntLiteral *i = (IntLiteral *)lit;
			char oneint[30];
			sprintf(oneint, "%d", i->get_i());
			ps(oneint);
			break;
			}
		case Literal::BoolLiteralT: {
			BoolLiteral *b = (BoolLiteral *)lit;
			if (b->get_b()) ps("TRUE"); else ps("FALSE");
			break;
			}
		case Literal::CharLiteralT: {
			CharLiteral *c = (CharLiteral *)lit;
			char *pchar = print_version(c->get_c());
			ps("'");
			ps(pchar);
			ps("'");
			break;
			}
		case Literal::StringLiteralT: {
			StringLiteral *s = (StringLiteral *)lit;
			ps("string_newn(\"");
			print_version(s->get_s());
			ps("\",");
			pint(string_length(s->get_s()));
			ps(")");
			break;
			}
		case Literal::RealLiteralT: {
			RealLiteral *r = (RealLiteral *)lit;
			char onereal[30];
			sprintf(onereal, "%f", r->get_r());
			ps(onereal);
			break;
			}
		   }
		}
	case Expr::InstantiationT: {
		break;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		Expr *prim = de->get_primary();
		Expr *deid = de->get_id();
		string nm;
		switch (deid->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)deid;
				nm = ide->get_id()->get_id();
				break;
				}
			case Expr::SuperIdT: {
				// review when there are proctype objects.
				cmp_err("Dot Expr: incorrect code gen", 99);
				SuperId *sid = (SuperId*)deid;
				nm = sid->get_id()->get_id();
				break;
				}
			}
		const char *c_name = "";
		bool ivar = is_ivar(prim, nm, &c_name);
		if (version == 0 || version == 1) {
			if (ivar) { ps("(("); psc(c_name); ps("_C)"); }
			expr_emit(prim);
			if (ivar) ps(")");
			ps("->");
			pstr(nm);
			}
        	break;
		}
	case Expr::SuperIdT: {
		break;
		}
	case Expr::SelfT: {
		ps("self");
		break;
		}
	case Expr::NewT: {
		break;
		}
	case Expr::ArrayRefT: {
		break;
		}
	case Expr::InvocExprT: {
		InvocExpr *inv = (InvocExpr *)ex;
		inv_emit(inv->get_invoc(), NULL, NULL);
		break;
		}
	case Expr::BindingExprT: {
		break;
		}
	case Expr::SelectorConstrT: {
		break;
		}
	case Expr::ArrayConstrT: {
		break;
		}
	case Expr::IdExprT: {
		const char *c_name = "";
		IdExpr *ie = (IdExpr *)ex;
		string nm  = ie->get_id()->get_id();
		bool ivar = is_ivar(0, nm, &c_name);
		if (ivar) {
			if (version == 2) {
				cmp_err("Shouldn't get here..", 87);
				}
			ps("((");
			psc(c_name);
			ps("_C)self)->");
			pstr(nm);
			}
		else {
			// XXX short term hack
			if (ex->get_type()->tag() != TypeInterface::MethodT &&
				ex->get_type()->tag() != TypeInterface::PMethodT)
				emit_iter_prefix();
			pstr(nm);
			}
		break;
		}
	case Expr::BinaryT: {
		Binary *b = (Binary *)ex;
		if (b->tag() == Binary::AndT) {
		    ps("(");
		    expr_emit(b->get_op1());
		    ps(" ? ");
		    expr_emit(b->get_op2());
		    ps(" : FALSE)");
		    }
		else {
		    ps("(");
		    expr_emit(b->get_op1());
		    ps(" ? TRUE : ");
		    expr_emit(b->get_op2());
		    ps(")");
		    }
		break;
		}
	case Expr::UnaryT: {
		// shouldn't occur
		break;
		}
	case Expr::BracketRefT: {
		break;
		}
	case Expr::BraceRefT: {
		break;
		}
	}
   }


/* seems unused... */
void decls_emit(ParseNodeList *decls)
{
   bool do_comma = FALSE;
   if (decls) for (Pix p = decls->first(); p ; decls->next(p)) {
	if (do_comma) ps(", ");
	Decl *d = (Decl *)(*decls)(p);
	decl_emit(d);
   	do_comma = TRUE;
	}
   }

void decl_emit(Decl *d)
{
   bool do_comma = FALSE;
   switch (d->tag()) {
	case Decl::RegDeclT: {
		RegDecl *rd = (RegDecl *)d;
   		ParseNodeList *ids = rd->get_ids();
   		if (ids) for (Pix p = ids->first(); p ; ids->next(p)) {
			const char *dummy = "";
			Id *id = (Id *)(*ids)(p);
			/* seems a little wierd to me... */
			/* shouldn't be decling an ivar... */
			if (is_ivar(0, id->get_id(), &dummy)) fix_write(id);
			}
   		if (ids) for (Pix p = ids->first(); p ; ids->next(p)) {
			if (!do_comma) ind();
			if (do_comma) ps(", ");
			Id *id = (Id *)(*ids)(p);
			pstr(id->get_id());
   			do_comma = TRUE;
			}
		break;
		}
//	case Decl::VarArgsDeclT: {
//		}
	}
   }

void idorivar_emit(IdOrIvar *idv)
{
   Expr *ex = idv->get_primary();
   if (ex != 0) {
	cmp_err("Time to fix IdOrIvar", idv->get_line());
	}
   Id *id = idv->get_id();
   pstr(id->get_id());
   }

#define MAXEQ 500
static int eq_saved_count = 0;
static Equate *eq_saved[MAXEQ];

void eq_clear()
{
   eq_saved_count = 0;
   }

void eq_save(Equate *eq)
{
   if(eq_saved_count >= MAXEQ) {
	th_fail("cg_expr.cc: increase MAXEQ");
	}
   eq_saved[eq_saved_count] = eq;
   eq_saved_count++;
   }

void eq_emit_saved()
{
int i;
	for (i = 0; i < eq_saved_count; i++) {
		eq_emit(eq_saved[i]);
		}
  }

void eq_emit(Equate *eq)
{
   switch (eq->tag()) {
	case (Equate::ExprEquateT): {
		ExprEquate *eeq = (ExprEquate *)eq;
		ps("#define ");
		pstr(eeq->get_id()->get_id());
		ps(" ");
		expr_emit(eeq->get_expr());
		ps("\n");
		break;
		}
	}
   }


void print_version(string s)
{
int size = string_length(s);
char c;

	for (int i = 0; i < size ; i++) {
		c = string_charp(s)[i];
		ps(print_version(c));
		}
	}

static char chars[8];
char *print_version(char c)
{
int temp;
	chars[0] = '\\';
	if (isprint(c)) {
		if (c == '"') {
			chars[0] = '\\';
			chars[1] = c;
			chars[2] = '\0';
			return chars;
			}
		if (c == '\'' || c == '\\') {
			chars[1] = c;
			chars[2] = '\0';
			return chars;
			}
		chars[0] = c;
		chars[1] = '\0';
		return chars;
		}
	if (c == '\0') {
		chars[1] = '0';
		chars[2] = '0';
		chars[3] = '0';
		chars[4] = '\0';
		return chars;
		}
	temp = c;
	temp &= 0xff;
	sprintf(&chars[1], "%-3.3o", temp);
	return chars;
	}

void init_emit(bool castit, string cname, string supername, string objname, ParseNodeList *fields,
							Invoc *inv)
{
        if (fields) for (Pix p = fields->first(); p; fields->next(p)) {
              // this isn't quite right if several fields can
              //      have the same value
              FieldInit *fi = (FieldInit *)(*fields)(p);
              Expr *new_ex = expr_preprocess(fi->get_expr());
              type t = get_one_type(new_ex->get_type(),88);
              ind();
              if (!castit) {
                  ps("((");
                  pstr(cname);
                  ps("_C)");
                  }
              pstr(objname);
              if (!castit) ps(")");
              ps("->");
              pstr(fi->get_id()->get_id());
              ps(" = ");
              bool needs_cast = assn_cast_site(fi->get_id(), t);
              bool is_any = anyize(fi->get_id(), t);
              expr_emit(new_ex);
              if (is_any) ps(")");
              if (needs_cast) ps(")");
              ps(";\n");
              }
         // subclass constructors will have invocation of
         // superclass's maker
         if (inv) {
              ParseNode *pn = inv_preprocess(inv);
              ind();
              switch (pn->tag()) {
                 case ParseNode::InvocT: {
                    Invoc *inv = (Invoc *)pn;
		    // string slfnm = string_concat(string_new("("), supername);
		    // slfnm = string_concat(slfnm, string_new(")"));
		    // slfnm = string_concat(slfnm, objname);
                    inv_emit(inv, supername, objname);
                    ps(";\n");
                    pn_check_emit(pn);
                    }
                 }

             }
	}

void init_emit_1(bool castit, string cname, string supername, string objname,
			ParseNodeList *fields, Invoc *inv)
{
    if (fields) {
	ps("{\n");
	// ps("Core_p Cp_");
	// pstr(objname);
	// ps(" = OBJ_CORE(");
	// pstr(objname);
	// ps(");\n");
	// ps("Field_p Fp_");
	// pstr(objname);
	// ps(" = FIELDS(Cp_");
	// pstr(objname);
	// ps(");\n");
	ps("struct ");
	pstr(cname);
	ps("_f_s *Fp_");
	pstr(objname);
	ps(" = FIX_FIELDS(");
	pstr(objname);
	ps(", ");
	pstr(cname);
	ps(");\n");
        for (Pix p = fields->first(); p; fields->next(p)) {
              // this isn't quite right if several fields can
              //      have the same value
              FieldInit *fi = (FieldInit *)(*fields)(p);
              Expr *new_ex = expr_preprocess(fi->get_expr());
              type t = get_one_type(new_ex->get_type(),88);
	      // NOTE: casting and anyizing has been omitted for the
	      //	short term...
              ind();
	      ps("PUT");
	      if (is_vtype(t)) ps("V_F(Fp_");
	      else ps("P_F(Fp_");
	      pstr(objname);
	      ps(", ");
	      pstr(fi->get_id()->get_id());
	      ps(", ");
	      expr_emit(new_ex);
	      ps(", ");
	      pstr(simple_type_name(type_name(t)));
              ps(");\n");
              }
	ps("}\n");
        }
         // subclass constructors will have invocation of
         // superclass's maker
         if (inv) {
              ParseNode *pn = inv_preprocess(inv);
              ind();
              switch (pn->tag()) {
                 case ParseNode::InvocT: {
                    Invoc *inv = (Invoc *)pn;
		    // string slfnm = string_concat(string_new("("), supername);
		    // slfnm = string_concat(slfnm, string_new(")"));
		    // slfnm = string_concat(slfnm, objname);
                    inv_emit(inv, supername, objname);
                    ps(";\n");
                    pn_check_emit(pn);
                    }
                 }

             }
	}

bool emit_iter_prefix()
{
bool temp = get_iter_active();

	if (temp) {
		ps("IState->");
		}
	return temp;
	}

bool inlined_fetch(type t, Expr *new_prim, ParseNodeList *new_exprs, string tmp,
			string tname)
{
int flag = 0;

     if (t && !strcmp("vector",string_charp(
                simple_type_name(type_name(t)))))
	flag = 1;
     if (t && !strcmp("array",string_charp(
                simple_type_name(type_name(t)))))
	flag = 2;
     if (t && !strcmp("sequence",string_charp(
                simple_type_name(type_name(t)))))
	flag = 3;
     if (flag) {
        ind();
	if (version == 0 || version == 1) {
		switch (flag) {
			case 1: { ps("vector_fetch("); break; }
			case 2: { ps("array_fetch("); break; }
			case 3: { ps("sequence_fetch("); break; }
			}
		}
	else {
		switch (flag) {
			case 1: { ps("VECTOR_FETCH("); break; }
			case 2: { ps("ARRAY_FETCH("); break; }
			case 3: { ps("SEQUENCE_FETCH("); break; }
			}
		}
        emit_iter_prefix();
        ps("MT_1, ");
        expr_emit(new_prim);
        ps(", ");
        exprs_emit(new_exprs);
        ps(");\n");
        ind();
        emit_iter_prefix();
        pstr(tmp);
        ps(" = ");
        if (is_vtypestr(tname)) ps("PV_as_prim(");
        else ps("PV_as_obj(");
        pstr(simple_type_name(tname));
        ps(", MT_1);\n");
	return TRUE;
        }
    return FALSE;
    }

bool inlined_store(type t, Expr *new_prim, ParseNodeList *new_index, 
                        ParseNodeList *new_exprs)
{
int flag = 0;

   if (t && !strcmp("vector",string_charp(simple_type_name(type_name(t)))))
	flag = 1;
   if (t && !strcmp("array",string_charp(simple_type_name(type_name(t)))))
	flag = 2;
   if (flag) {
        ind();
	if (version == 0 || version == 1) {
		if (flag == 1) ps("vector_store(");
		else ps("array_store(");
		}
	else {
		if (flag == 1) ps("VECTOR_STORE(");
		else ps("ARRAY_STORE(");
		}
        expr_emit(new_prim);
        ps(", ");
	exprs_emit(new_index);
        ps(", ");
	Expr *ex = (Expr *)new_exprs->front();
	type et = get_one_type(ex->get_type(), 87);
	// might need a wrap call here...
	if (is_vtype(et)) ps("Prim_as_PV(");
	else ps("Obj_as_PV(");
	expr_emit(ex);
        ps("));\n");
    	return TRUE;
    	}
    return FALSE;
    }

void output_base_method_str(const char *tnc, const char *enmc)
{
	if (!strcmp(tnc, "array")) {
		if (!strcmp(enmc, "store")) {
			ps("ARRAY_STORE");
			return;
			}
 		if (!strcmp(enmc, "fetch")) {
			ps("ARRAY_FETCH");
			return;
			}
 		if (!strcmp(enmc, "append")) {
			ps("ARRAY_APPEND");
			return;
			}
		}
	if (!strcmp(tnc, "vector")) {
		if (!strcmp(enmc, "store")) {
			ps("VECTOR_STORE");
			return;
			}
 		if (!strcmp(enmc, "fetch")) {
			ps("VECTOR_FETCH");
			return;
			}
		}
	if (!strcmp(tnc, "sequence")) {
 		if (!strcmp(enmc, "fetch")) {
			ps("SEQUENCE_FETCH");
			return;
			}
		}
	psc(tnc);
	ps("_");
	psc(enmc);
	}
