// Copyright 1995 Barbara Liskov

#include "parse.h"
#include <stdio.h>
#ifdef __alpha__
#include "string.h"
#endif
#ifdef __linux__
#include "local_string.h"
#endif
#include <unistd.h>
#include <ctype.h>
#include "types/objtype_class.h"
#include "types/vec.h"
#include "types/method.h"
#include "types/ptype.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/vec_instns.h"
#include "client/gen-include-1.h"

#include "cg.h"

static void do_supers_meth_incls(objtype t);
static void do_supers(objtype ot, char *ditty);
static void do_supersm1(objtype ot, char *ditty);
static void type_methods_emit(objtype ot);
static void class_methods_emit(class_ c, objtype root);
static void pmsigtype(method m, const char *name);
extern int count_lhs(ParseNodeList *lp);
extern string ts2nm(TypeSpec *ts, int line);
extern void new_computeBitfields(int bps, class_ c);
bool fmember(wr w, method m, objtype root, objtype stop);
bool tmember(wr w, method m, objtype root);

extern FILE *f;
extern const char *tname;
extern const char *cname;
extern const char *rname;
extern const char *th_name;
extern char *opt_name;
// objtype the_obj;
extern method the_method;

/*
	Various routines to create files and do file i/o
*/

// fopen's need more error checking........

void do_type_file_1(string filename, string Tname, objtype t, ParseNode *pn)
{

    tname = string_charp(Tname);
    the_obj = t;
    char const *fn = string_charp(filename);
    string filename2 = filename;
    unlink(string_charp(filename2));
//    string filename2 = string_concat(filename, string_new("-th"));
//    if (0 == access(string_charp(filename2), F_OK)) {
//        string bakfile = string_concat(filename2, string_new("~"));
//        if (0>rename(string_charp(filename2),
//                     string_charp(bakfile))) {
//            perror(string_charp(filename2));
//
//        };
//    }
    f = fopen(string_charp(filename2), "w");
    ps("\n/* This file was automatically generated by the Theta compiler */\n");
    ps("/*     from input file: ");
    psc(th_name);
    ps(" */\n\n");
    ps("#include \"runtime/C/fixups.h\"\n");
    ps("#include \"runtime/C/compiler.h\"\n");
    ps("#include \"types1/builtin_types.h\"\n");

    clear_types();
    clear_pts();
    do_supers_meth_incls(the_obj);
    srch_pn_for_types(pn);
    output_types();

    ps("struct Objtype_s *");
    ptname();
    ps("_V;\n");

    ps("void Init_");
    ptname();
    ps("()\n{\n");
    ind();
    ps("if (");
    ptname();
    ps("_V != 0) return;\n");
    ind();
    ptname();
    ps("_V = NEW_OBJTYPE();\n");
    ptname();
    ps("_V->primitive = 0;\n");
    ptname();
    ps("_V->dhsize = 1;\n");
    ps("}\n");

    tname = 0;

    fclose(f);
}

void begin_class_file_1(string filename, string Tname, string Cname,
		objtype t, ParseNode *pn)
{

    if (Tname) tname = string_charp(Tname);
    else tname = 0;
    cname = string_charp(Cname);
    the_obj = t;
    char const *fn = string_charp(filename);
    string filename2 = filename;
    unlink(string_charp(filename2));
//    string filename2 = string_concat(filename, string_new("-th"));
//    if (0 == access(string_charp(filename2), F_OK)) {
//        string bakfile = string_concat(filename2, string_new("~"));
//        if (0>rename(string_charp(filename2),
//                     string_charp(bakfile))) {
//            perror(string_charp(filename2));
//        };
//    }

    string inc_filename = string_concat(Cname, string_new("_inc.h"));
    f = start_include_1(inc_filename);
    clear_types();
    clear_pts();
    do_supers_meth_incls(the_obj);
    srch_pn_for_types(pn);
    output_types();
    output_pts_externs();
    end_include_1(inc_filename, f);

    f = fopen(string_charp(filename2), "w");
    ps("#include \"runtime/C/compiler.h\"\n");
    ps("#include \"types1/builtin_types.h\"\n");
    ps("#include \"");
    pcname();
    ps(".h\"\n");

    ps("struct Class_s *");
    pcname();
    ps("_V;\n");

}


// we don't have meth files any more: should this get types or go away
void do_supers_meth_incls(objtype t)
{
    int nst = t && t->supertypes_ ? vec_length(t->supertypes_) : 0;
    for (int j = nst-1 ; j > -1 ; j--) {
	type st = UNPV(type, vec_fetch(t->supertypes_, j));
	do_supers_meth_incls(type_as_objtype(st));
	const char *tn = string_charp(simple_type_name(type_name(st)));
	if (!strcmp(tn, "any")) continue;
	if (!strcmp(tn, "vec")) continue;
    	fputs("#include \"", f);
    	fputs(tn, f);
    	fputs(".h\"\n", f);
	}
    }

/* Not used
void make_rtn_include(string filename, ParseNode *rd);
{
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
        string bakfile = string_concat(filename2, string_new("~"));
        if (0>rename(string_charp(filename2),
                     string_charp(bakfile))) {
            perror(string_charp(filename2));

        };
    }
    f = fopen(string_charp(filename2), "w");
   }
*/

void begin_rtn_file_1(string filename, ParseNode *pn, string nm, method m)
{

    the_method = m;
    rname = string_charp(nm);
    char const *fn = string_charp(filename);
    string filename2 = filename;
    unlink(string_charp(filename2));
//    string filename2 = string_concat(filename, string_new("-th"));
//    if (0 == access(string_charp(filename2), F_OK)) {
//        string bakfile = string_concat(filename2, string_new("~"));
//        if (0>rename(string_charp(filename2),
//                     string_charp(bakfile))) {
//            perror(string_charp(filename2));
//
//        };
//    }
    string inc_filename = string_concat(nm, string_new("_inc.h"));
    f = start_include_1(inc_filename);
    clear_types();
    clear_pts();
    srch_pn_for_types(pn);
    output_types();
    output_pts_externs();
    end_include_1(inc_filename, f);

    f = fopen(string_charp(filename2), "w");
    ps("#include \"runtime/C/compiler.h\"\n");
    ps("#include \"types1/builtin_types.h\"\n");
    // clear_types();
    // clear_pts();
    // srch_pn_for_types(pn);
    // output_types();
    // output_pts_externs();
    ps("#include \"");
    prname();
    ps(".h\"\n");
    ps("struct Obj_s *");
    pstr(nm);
    ps("_Rtn_Class_Obj;\n");
    ps("struct Class_s *");
    pstr(nm);
    ps("_Rtn_Class_V;\n");
    // ps("struct ");
    // prname();
    // ps("_Rtn_Class_class_DV {\n");
    // inc_ind();
    // ind();
    // ps("struct DV_hdr_s hdr;\n");
    // ind();
    // ps("struct Class_s *(*get_class)(struct Obj_s *);\n");
    // pmsigtype(the_method, "struct Obj_s *");
    // dec_ind();
    // ps("};\n");
}

// static void ps(char *s)
// {
// 	fputs(s, f);
// 	}
// 
// static void psc(const char *s)
// {
// 	fputs(s, f);
// 	}
// 
// static void pstr(string s)
// {
// 	fputs(string_charp(s), f);
// 	}
// 
// static void pint(int i)
// {
// char buf[20];
// 
// 	sprintf(buf, "%d", i);
// 	fputs(buf, f);
// 	}
// 
// static void ptname()
// {
// 	fputs(tname, f);
// 	}
// 
// static void pcname()
// {
// 	fputs(cname, f);
// 	}
// 
// static void prname()
// {
// 	fputs(rname, f);
// 	}
// 
// static void popt()
// {
// 	fputs(opt_name, f);
// 	}

void pmsig_1(method m)
{
int i;

   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   pcname();
   ps("M");
   pstr(m->name);
   ps("_ (");
   // if (m->parameterized) ps("void *pblock, ");
   pcname();
   ps(" self");
   if (vec_length(m->returns) > 1 && !m->iter) ps(", Pval *__retvals");
   // if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n");
   }

void prsig_1(method m)
{
int i;

   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   pstr(m->name);
   ps("(");
   // if (m->parameterized) ps("void *pblock, ");
   ps("struct Obj_s *self");
   if (vec_length(m->returns) > 1 && !m->iter) ps(", Pval *__retvals");
   // if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n");
   }


void pitersig_1(method m, RoutineDef *rd)
{
int i;

//   if (rd) {
//    	ps("struct ");
//    	if (cname) {pcname(); ps("M");}
//    	pstr(m->name);
//    	ps("_Iter_State_s {\n");
//    	ps("int pc;\n");
//    	ps("int spare;\n");
//    	decl_locals(rd);
//    	decl_temps(rd);
//    	for (int i = 0; i < vec_length(m->arguments); i++) {
//        	formal f = UNPV(formal, vec_fetch(m->arguments, i));
//        	pstr(type_name(f->t));
//        	ps(" ");
//        	pstr(f->name);
//        	ps(";\n");
//        	}
//   	for (i = 0; i < vec_length(m->returns); i++) {
//        	type t = UNPV(type, vec_fetch(m->returns, i));
//        	pstr(type_name(t));
//        	ps(" ret_");
//        	pint(i);
//        	ps(";\n");
//        	}
//   	ps("};\n");
//   	}
   if (cname) {pcname(); ps("M");}
   pstr(m->name);
   ps("_Iter_State ");
   if (cname) {pcname(); ps("M");}
   pstr(m->name);
   ps("_START");
   if (cname) { ps("_("); pcname(); ps(" self"); }
   else ps("(struct Obj_s *self");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
	ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n{\n ");
   if (cname) {pcname(); ps("M");}
   pstr(m->name);
   ps("_Iter_State new_state = NEW(struct ");
   if (cname) {pcname(); ps("M");}
   pstr(m->name);
   ps("_Iter_State_s);\n");
   inc_ind();
   ind();
   ps("new_state->pc = 0;\n");
   ind();
   ps("new_state->spare = 0;\n");
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
   	ind();
	ps("new_state->");
        pstr(f->name);
	ps(" = ");
        pstr(f->name);
	ps(";\n");
        }
   ind();
   ps("return new_state;\n");
   dec_ind();
   ps("}\n\n");

   // if (vec_length(m->returns) == 0) ps("void ");
   // else {
        // type t = UNPV(type, vec_fetch(m->returns, 0));
        // pstr(simple_type_name(type_name(t))); ps(" ");}
   ps("bool ");
   if (cname) {pcname(); ps("M");}
   pstr(m->name);
   ps("_LOOP");
   if (cname) { ps("_("); pcname(); ps(" self"); }
   else ps("(struct Obj_s *self");
   // if (vec_length(m->returns) > 1) ps(", Pval *__retvals");
   if (m->iter) {
	ps(", ");
   	if (cname) {pcname(); ps("M");}
	pstr(m->name);
	ps("_Iter_State IState");
	}
   ps(")\n");
   }

void pmkrsig_1(method m)
{
int i;

   ps("void ");
   pstr(m->name);
   ps("(");
   type t = UNPV(type, vec_fetch(m->returns, 0));
   pstr(simple_type_name(type_name(t)));
   ps(" self");
   // if (m->parameterized) ps("void *pblock, ");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n");
   }

static void ptsig(method m)
{
int i, j;

   ind();
   pstr(m->name);
   ps("(");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        pstr(f->name);
        ps(": ");
        pstr(type_name(f->t));
	if (i != vec_length(m->arguments)-1) ps(", ");
        }
   ps(")");
   if (vec_length(m->returns) > 0) {
   	if (m->iter) ps("yields (");
   	else ps(" returns (");
	}
   for (i = 0; i < vec_length(m->returns); i++ ) {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(type_name(t));
	if (i != vec_length(m->returns)-1) ps(", ");
	}
   if (vec_length(m->returns) > 0)  ps(")");
   if (vec_length(m->signals) > 0) {
	ps(" signals (");
	for (i = 0; i < vec_length(m->signals); i++) {
		signal_ s = UNPV(signal_, vec_fetch(m->signals, i));
		pstr(s->name);
		if (vec_length(s->returns)) {
			ps("(");
			for (j = 0; j < vec_length(s->returns); j++) {
				type t = UNPV(type, vec_fetch(s->returns, 0));
        			pstr(type_name(t));
				if (j != vec_length(s->returns)-1) ps(", ");
				}
			ps(")");
			}
		if (i != vec_length(m->signals)-1) ps(", ");
		}
	ps(")\n");
	}
   ps("\n");
   }

static void ptivar(type t, string name)
{
   ind();
   pstr(name);
   ps(": ");
   pstr(type_name(t));
   }

static void ptgetsig(type gt, string name, string gname, bool parmd)
{
int i;

   ind();
   pstr(gname);
   ps("() returns (");
   pstr(type_name(gt));
   ps(")\n");
   }

static void ptsetsig(type st, string name, string sname, bool parmd)
{
int i;

   ind();
   pstr(sname);
   ps("(");
   pstr(name);
   ps(": ");
   pstr(type_name(st));
   ps(")\n");
   }

static void pmsigcast(method m, const char *name)
{
int i;

   ps("(");
   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   // ptname();
   // ps("_");
   // pstr(m->name);
   // ps("_ (");
   ps("(*)(");
   // if (m->parameterized) ps("void *pblock, ");
   ps((char *)name);
   ps(" self");
   if (vec_length(m->returns) > 1 && !m->iter) ps(", Pval *__retvals");
   // if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")) ");
   }

static void pitersigcast(method m, const char *def_name, const char *name, int pass)
{
int i;

    if (pass == 0) {
       ps("(");
       // if (name) {psc(name); ps("M");}
       // else if (def_name) {psc(def_name); ps("M");}
       if (def_name) {psc(name); ps("M");}
       pstr(m->name);
       ps("_Iter_State ");
       ps("(*)(");
       psc(name);
       ps(" self");
       // if (tname) {ptname(); ps(" self");}
       // else {
       		// if (cname) {pcname(); ps(" self");}
       		// else ps("struct Obj_s *self");
	    // }
       int nargs = vec_length(m->arguments);
       for (i=0; i<nargs; i++) {
            formal f = UNPV(formal, vec_fetch(m->arguments, i));
            ps(", ");
            pstr(simple_type_name(type_name(f->t)));
            ps(" ");
            pstr(f->name);
            }
       ps(")) ");
       }
    else {
       ps("(int (*)(");
       psc(name);
       ps(" self, ");
       // if (tname) {ptname(); ps(" self, ");}
       // else {
	    // if (cname) 
		// {pcname(); ps(" self, ");}
       	    // else ps("struct Obj_s *self, ");
  	    // }
       // if (name) {psc(name); ps("M");}
       // else if (def_name) {psc(def_name); ps("M");}
       if (def_name) {psc(name); ps("M");}
       pstr(m->name);
       ps("_Iter_State IState)) ");
       }
    }


static void pmsigtype(method m, const char *name)
{
int i;

   ind();
   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   ps("(*");
   pstr(m->name);
   ps(")(");
   ps((char *)name);
   ps(" self");
   if (vec_length(m->returns) > 1 && !m->iter) ps(", Pval *__retvals");
   // if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(");\n");
   }


static int indent_sp = 0;
static char spaces[120] = "                                       "
	"                                        "
	"                                        ";

// static void inc_ind()
// {
// 	indent_sp += 3;
// 	}
// static void dec_ind()
// {
// 	indent_sp -= 3;
// 	}
// 
// static void ind()
// {
// //int i;
// //
// //  for (i = 0 ; i < indent_sp; i++) {
// //	ps(" ");
// //	}
//    spaces[indent_sp] = '\0';
//    ps(spaces);
//    spaces[indent_sp] = ' ';
//    }

// Probably obsolete...
static void method_emit_1(method m, const char *cast_nm, const char *def_nm)
{
    const char *m_name = string_charp(method_name(m));
    if (!strcmp(m_name, "getClass")) return;
    ps("dv->");
    psc(m_name);
    ps(" = ");
    if (cname) {
	pcname();
    	ps("M");
	}
    psc(m_name);
    ps("_");
    ps(";\n");
   }

static void method_emit(method m, const char *cast_nm, const char *def_nm)
{
    const char *m_name = string_charp(method_name(m));
    if (!strcmp(m_name, "getClass")) return;
    ps("    ");
    if (m->iter) pitersigcast(m, def_nm, cast_nm, 0);
    else pmsigcast(m, cast_nm);
    if (def_nm) {psc(def_nm); ps("M");}
    psc(m_name);
    if (m->iter) ps("_START");
    if (def_nm) ps("_ ");
    if (m->iter) {
    	ps(",\n    ");
	pitersigcast(m, def_nm, cast_nm, 1);
    	if (def_nm) {psc(def_nm); ps("M");}
    	psc(m_name);
    	if (m->iter) ps("_LOOP");
    	if (def_nm) ps("_ ");
	}
   }

static void iter_methods_emit(method m, const char *cast_nm, const char *def_nm)
{
    const char *m_name = string_charp(method_name(m));
    if (!strcmp(m_name, "getClass")) return;
    ps("    ");
    pitersigcast(m, def_nm, cast_nm, 0);
    if (def_nm) {psc(def_nm); ps("M");}
    psc(m_name);
    ps("_START");
    // reinstated 11/21/96 dwc
    if (def_nm) ps("_ ");
    ps(",\n");
    ps("    ");
    pitersigcast(m, def_nm, cast_nm, 1);
    if (def_nm) {psc(def_nm); ps("M");}
    psc(m_name);
    ps("_LOOP");
    // reinstated 11/21/96 dwc
    if (def_nm) ps("_ ");
    // ps("\n");
   }

// static const char *find_class_that_defines_method(method m);

static void do_supers_meths_emit(objtype t)
{
    int nst = t && t->supertypes_ ? vec_length(t->supertypes_) : 0;
    for (int j = nst-1 ; j > -1 ; j--) {
	type st = UNPV(type, vec_fetch(t->supertypes_, j));
	do_supers_meths_emit(type_as_objtype(st));
        int n = vec_length(type_as_objtype(st)->methods_);
	string st_name = type_name(st);
        for(int i = 0; i < n; i++) {
             method m = UNPV(method, 
				vec_fetch(type_as_objtype(st)->methods_, i));
             const char *m_name = string_charp(method_name(m));
	     if (!strcmp(m_name, "getClass")) continue;
	     const char *def_name = find_class_that_defines_method(m);
	     method_emit(m, string_charp(st_name), def_name);
      	     // if (i == n-1) fputs("},\n", f);
	     // else fputs(",\n", f);
	     fputs(",\n", f);
	     }
        }
   }


static void type_methods_emit(objtype ot)
{
    // add supertypes' methods
    do_supers_meths_emit(the_obj);

    // bool need_comma = FALSE;
    // add type's methods
        int n = the_obj ? vec_length(the_obj->methods_) : 0;
        for(int i = 0; i < n; i++) {
             method m = UNPV(method, 
				vec_fetch(the_obj->methods_, i));
	     // figure out which class implements this method...
	     const char *def_name = find_class_that_defines_method(m);
	     // method_emit(m, cname?cname:tname, def_name);
	     if (m->iter) iter_methods_emit(m, tname, def_name);
	     else method_emit(m, tname, def_name);
      	     if (i != n-1) fputs(",\n", f);
	     // fputs(",\n", f);
	     }
     	 // if (the_obj) fputs("    }", f); // need_comma = TRUE; 
	}

static void class_methods_emit(class_ c, objtype root)
{
int nsc = 0;

    // emit methods private to the class...
    if (!c) return;
    if (c == objtype_as_class(Any)) return;
    
    int n = vec_length(class_as_objtype(c)->methods_);
    // if (!n) return;
    for(int i = 0; i < n; i++) {
         method m = UNPV(method, vec_fetch(class_as_objtype(c)->methods_, i));
	 if (tmember(NULL, m, root)) continue;
	 if (fmember(NULL, m, root, class_as_objtype(c))) continue;
         const char *m_name = string_charp(method_name(m));
	 const char *nm = string_charp(c->hdr.inh.name);
	 if (m->iter) iter_methods_emit(m, nm, nm);
	 else method_emit(m, nm, nm);
      	 fputs(",\n", f);
	}

    if (c->superclass && vec_length(c->superclass) > 0) nsc = 1;
    if (nsc) {
	class_ sc = UNPV(class_, vec_fetch(c->superclass, 0));
	class_methods_emit(sc, root);
	}
   }

void do_supersc_1(objtype ot, char *ditty)
{
    int nsc = 0;
    class_ c = (class_)(ot);
    if (c && c->superclass && vec_length(c->superclass) > 0) nsc = 1;
    if (nsc) {
	fputs(ditty, f);
	c = UNPV(class_, vec_fetch(c->superclass, 0));
	do_supersc(type_as_objtype(class_as_type(c)), ditty);
	}
    }

static void do_supers(objtype ot, char *ditty)
{
    int nst = 0;
    if (ot && ot->supertypes_) nst = vec_length(ot->supertypes_);
    for (int i = 0 ; i < nst ; i++) {
	fputs(ditty, f);
	do_supers(type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, i))),
			ditty);
	}
    }

static void do_supersm1(objtype ot, char *ditty)
{
    int nst = 0;
    if (ot->supertypes_) {
	objtype t = type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, 0)));
	if (t == Any) return;
	fputs(ditty, f);
	do_supers(t, ditty);
	}
    }

void end_class_file_1()
{

    class_ c = save_stripped_class;

    ps("static struct ");
    pcname();
    ps("_class_DV The_");
    pcname();
    ps("_DV = {\n");
    class_methods_emit(save_stripped_class, the_obj);
    ps("{\n");
    ps("0,0,0,0,0,Normal_get_address\n");
    ps("},\n");
    ps("Normal_get_class,\n");
    type_methods_emit(the_obj);
    ps("\n");
    ps("};\n\n");

    ps("\n\n");
//     ps("void Link_");
//     pcname();
//     ps("(void *dummy)\n{\n");
//     output_pts_instns();
//     ps("}\n");
    ps("\n\n");
    ps("void Init_");
    pcname();
    ps("()\n{\n");
    // ps("struct ");
    // pcname();
    // ps("_class_DV *dv;\n\n");
    ps("if (");
    pcname();
    ps("_V != 0) return;\n");
    pcname();
    ps("_V = NEW_CLASS();\n");
    pcname();
    ps("_V->dhsize = 1;\n");
    ps("#if SMALL_SLOTS\n");
    new_computeBitfields(4, c);
    pcname();
    ps("_V->num_slots = ");
    pint(c->slots);
    ps(";\n");
    pcname();
    ps("_V->bf = 0x");
    long bf = UNPV(long, vec_fetch(c->bitfields, 0));
    phex(bf);
    ps(";\n");
    ps("#else\n");
    new_computeBitfields(8, c);
    pcname();
    ps("_V->num_slots = ");
    pint(c->slots);
    ps(";\n");
    pcname();
    ps("_V->bf = 0x");
    bf = UNPV(long, vec_fetch(c->bitfields, 0));
    phex(bf);
    ps(";\n");
    ps("#endif\n");
    pcname();
    ps("_V->primitive = 0;\n");
    pcname();
    ps("_V->class_name = \"");
    pcname();
    ps("\";\n");
    ps("CREATE_DV(");
    pcname();
    ps(");\n");
    // ps("dv = (struct ");
    //  pcname();
    // ps("_class_DV *) ");
    // pcname();
    // ps("_V->dv;\n");
    // ps("dv->hdr.head_offset = 0;\n");
    // ps("dv->hdr.core_offset = 0;\n");
    // ps("dv->hdr.num_slots = ");
    // pcname();
    // ps("_V->num_slots;\n");
    // ps("dv->hdr.bf = ");
    // pcname();
    // ps("_V->bf;\n");
      ps("SET_CLASS_DV_ENTRY(");
      pcname();
      ps(", hdr.head_offset, 0);\n");
      ps("SET_CLASS_DV_ENTRY(");
      pcname();
      ps(", hdr.core_offset, 0);\n");
      ps("SET_CLASS_DV_ENTRY(");
      pcname();
      ps(", hdr.num_slots, ");
      pcname();
      ps("_V->num_slots);\n");
//    pcname();
//    ps("_V->dv = &The_");
//    pcname();
//    ps("_DV.hdr;\n");
//    pcname();
//    ps("_V->dv->class_object = ");
//    pcname();
//    ps("_V;\n");
    // pcname();
    // ps("_V->dv = (struct Obj_DV *)FE->vh->allocate(\n");
    // ps("	sizeof(struct ");
    // pcname();
    // ps("_DV)/sizeof(Slot));\n");
/*
    ps("dv->hdr.primitive = 0;\n");
*/

//     ps("Add_init_queue(Link_");
//     pcname();
//     ps(", dummy_env);\n");
    output_pts_instns();
    ps("}\n");
    fclose(f);
    cname = 0;

/* OLD...
    ps("struct Obj_DV *");
    pcname();
    ps("_DH[] = { (struct Obj_DV *)&");
    pcname();
    ps("_Methods };\n");
    pcname();
    ps("V->dh = ");
    pcname();
    ps("_DH;\n");
    pcname();
    ps("_Methods");
    ps(".type_DV.hdr.class_object");
    ps(" = ");
    pcname();
    ps("V;\n");
    ps("struct ");
    pcname();
    ps("_full_DV ");
    pcname();
    ps("_Methods = {\n");
    class_methods_emit(the_obj);
    ps("   {{ 0, 0, 0, normal_get_address, normal_get_class },\n");
    type_methods_emit(the_obj);
    ps("\n    }\n");
    ps("};\n\n");
*/
	
}

void end_mkr_file_1()
{
    fclose(f);
    rname = 0;
}

void end_rtn_file_1()
{
    // ps("struct Class_s *");
    // prname();
    // ps("_Rtn_ClassV;\n");
    // ps("void Link_");
    // prname();
    // ps("_Rtn_Class(void *dummy)\n{\n");
    // output_pts_instns();
    // ps("}\n");
    ps("static struct ");
    prname();
    ps("_Rtn_Class_class_DV The_");
    prname();
    ps("_Rtn_Class_DV = {\n");
    // ps("0,\n");
    ps("{\n");
    ps("0,0,0,0,0,Normal_get_address\n");
    ps("},\n");
    ps("Normal_get_class,\n");
    if (the_method->iter) iter_methods_emit(the_method, "struct Obj_s *", 0);
    else method_emit(the_method, "struct Obj_s *", 0);
    ps("\n");
    ps("};\n\n");
    ps("void Init_");
    prname();
    ps("_Rtn_Class()\n{\n");
    ps("struct ");
    prname();
    ps("_Rtn_Class_class_DV *dv;\n\n");
    ps("if (");
    prname();
    ps("_Rtn_Class_V != 0) return;\n");
    prname();
    ps("_Rtn_Class_V = NEW_CLASS();\n");
    prname();
    ps("_Rtn_Class_V->num_slots = 0;\n");
    prname();
    ps("_Rtn_Class_V->dhsize = 1;\n");
    prname();
    ps("_Rtn_Class_V->bf = 0;\n");
    prname();
    ps("_Rtn_Class_V->primitive = 0;\n");
    prname();
    ps("_Rtn_Class_V->class_name = \"");
    prname();
    ps("_Rtn_Class");
    ps("\";\n");
    ps("CREATE_DV(");
    prname();
    ps("_Rtn_Class");
    ps(");\n");
    ps("dv = (struct ");
    prname();
    ps("_Rtn_Class_class_DV *) ");
    prname();
    ps("_Rtn_Class_V->dv;\n");
    ps("dv->hdr.head_offset = 0;\n");
    ps("dv->hdr.core_offset = 0;\n");
    ps("dv->hdr.num_slots = 0;\n");
    ps("dv->hdr.bf = 0;\n");
//     prname();
//     ps("_V->dv = &The_");
//     prname();
//     ps("_Rtn_Class_class_DV.hdr;\n");
//     prname();
//     ps("_V->dv->class_object = ");
//     prname();
//     ps("_Rtn_Class_V;\n");
    // ps("        sizeof(struct ");
    // ps("_DV)/sizeof(Slot));\n");
//  ps("dv->hdr.primitive = 0;\n");
/* Broken
    method_emit_1(the_method, "obj", 0);
*/
    //ps("Add_init_queue(Link_");
    //prname();
    //ps("_Rtn_Class, dummy_env);\n");
    output_pts_instns();
    ps("NEW_PROC_OBJ(");
    prname();
    ps("_Rtn_Class_V);\n");
    prname();
    ps("_Rtn_Class_Obj = ");
    prname();
    ps("_Rtn_Class_V->proc;\n");
    ps("}\n");
    fclose(f);
    rname = 0;

/* OLD...
    ps("struct ");
    prname();
    ps("_Rtn_Class_DV ");
    prname();
    ps("_Rtn_Class_Methods = {\n");
    ps("  { 0, 0, STD_FOFFSET, 0, 0,\n");
    ps("    normal_get_address, normal_get_class },\n");
    method_emit(the_method, "obj", 0);
    ps("};\n\n");
    ps("\n#include \"types1/class_class.h\"\n\n");
    ps("DV ");
    prname();
    ps("_Rtn_Class_DH[] = { (DV)&");
    prname();
    ps("_Rtn_Class_Methods };\n");
    prname();
    ps("_Rtn_ClassV->dh = ");
    prname();
    ps("_Rtn_Class_DH;\n");
    prname();
    ps("_Rtn_Class_Methods");
    ps(".super");
    // do_supers(the_obj, ".super");
    ps(".c = ");
    prname();
    ps("_Rtn_ClassV;\n");
*/
}

static void begin_pth_file(string nm);
static void begin_data_file(string nm);
static void begin_extern_file(string nm);
static void end_pth_file();
static void end_data_file();
static void end_extern_file();

void begin_support_files_1(string nm)
{
	th_name = string_charp(nm);

	char *slash_ind = rindex(th_name, '/');
	char *dot_ind = rindex(th_name, '.');
	if (slash_ind > dot_ind) dot_ind = 0;
	int opt_len = 0;
	if (slash_ind) {
		if (dot_ind) opt_len = dot_ind - slash_ind - 1;
		else opt_len = th_name + strlen(th_name) - slash_ind - 1;
		slash_ind++;
		}
	else {
		slash_ind = (char *)th_name;
		if (dot_ind) opt_len = dot_ind - th_name;
		else opt_len = strlen(th_name);
		}

	opt_name = (char *)malloc(opt_len+1);
	strncpy(opt_name, slash_ind, opt_len);
	opt_name[opt_len] = '\0';
	for (int i = 0; i < opt_len; i++) {
		opt_name[i] = toupper(opt_name[i]);
		}
	
	begin_pth_file(nm);
	begin_data_file(nm);
	begin_extern_file(nm);
}

static void pth_type(TypeIntf *tin);
static void pth_rtn(RoutineDef *rd, bool viz);
static void pth_class(ClassDef *cd);
static void data_type(TypeIntf *tin);
static void data_rtn(RoutineDef *rd);
static void data_class(ClassDef *cd);
static void extern_type(TypeIntf *tin);
static void extern_rtn(RoutineDef *rd);
static void extern_class(ClassDef *cd);

void extend_support_files_1(ParseNode *pn)
{
	switch (pn->tag()) {
		case ParseNode::SpecEltT: {
		    SpecElt *spec = (SpecElt *)pn;
		    switch (spec->tag()) {
			case SpecElt::TypeIntfT: {
               	             TypeIntf *tin = (TypeIntf*)spec;
                      	     pth_type(tin);
                      	     data_type(tin);
                      	     extern_type(tin);
		             break;
               		     }
                	case SpecElt::RoutineSpecT: {
                       	     RoutineSpec *rs = (RoutineSpec *)spec;
		             // handle_routine_spec(rs);
               		     break;
                       	     }
			   }
			break;
			}
		case ParseNode::ImplEltT: {
			ImplElt *ie = (ImplElt *)pn;
			switch (ie->tag()) {
		                case ImplElt::RoutineDefT:{
               		         RoutineDef *rd = (RoutineDef *)ie;
				 bool viz = mod_impls_member(rd);
                       		 pth_rtn(rd, viz);
                       		 data_rtn(rd);
                       		 extern_rtn(rd);
		                 break;
               		         }
		                case ImplElt::ClassDefT:{
               		         ClassDef *cd = (ClassDef *)ie;
                       		 pth_class(cd);
                       		 data_class(cd);
                       		 extern_class(cd);
		                 break;
				 }
			    }
			break;
			}
		}
}

void end_support_files_1()
{
	end_pth_file();
	end_data_file();
	end_extern_file();
}

static void create_support_file(string nm, char *extension, char **fname)
{
int err;
char *old_fname;
char *new_fname;
int i,j;

	// Select file name etc. backup old one...
	// if file exists mv to name~
	int extlen = strlen(extension);
	char *slash_ind = rindex(th_name, '/');
	char *ind = rindex(th_name, '.');
	if (slash_ind > ind) ind = 0;
	int len = ind?ind-th_name:strlen(th_name);
	new_fname = (char *)malloc(len+extlen+2);	// len.extlen\0
	strncpy(new_fname, th_name, len);
	new_fname[len] = '.';
	for (i = len+1, j = 0 ; j < extlen; i++, j++) {
		new_fname[i] = extension[j];
		}
	new_fname[len+extlen+1] = '\0';
	old_fname = (char *)malloc(len+extlen+3);  // +~
	strcpy(old_fname, new_fname);
	old_fname[len+extlen+1] = '~';
	old_fname[len+extlen+2] = '\0';
	err = access(new_fname, F_OK);
	if (err == 0) {
		/* file exists */
		err = access(old_fname, F_OK);
		if (err == 0) {
			/* old file exists */
			unlink(old_fname);
			rename(new_fname, old_fname);
			}
		else {
			/* old file does not exist */
			rename(new_fname, old_fname);
			}
		}
	else {
		/* file does not exist */
		}
	*fname = new_fname;
}

static char *pth_name;

static void begin_pth_file(string nm)
{
	create_support_file(nm, "pth", &pth_name);
}

static void pth_type(TypeIntf *tin)
{
    	f = fopen(pth_name, "a");
	pstr(tin->get_id()->get_id());
	ps(" = ");
	ParseNodeList *sprs = tin->get_supers();
	if (sprs) for (Pix p = sprs->first(); p ; sprs->next(p)) {
		SuperInfo *si = (SuperInfo *)(*sprs)(p);
		TypeSpec *ts = si->get_typespec();
		if (ts) {
			string nm = 0;
			switch (ts->tag()) {
				case TypeSpec::SimpleTypeSpecT: {
					nm = ts2nm(ts, tin->get_line());
					break;
					}
				case TypeSpec::ParamTypeSpecT: {
					ParamTypeSpec *pts = (ParamTypeSpec *)ts;
					nm = pts->get_name()->get_name()->get_id();
					break;
					}
				}
			if (nm) pstr(nm);
			ps(" ");
			}
		}
	ps("type\n");
	inc_ind();
        ParseNodeList *ms = tin->get_methods();
	if (ms) for (Pix p = ms->first(); p ; ms->next(p)) {
		RoutineIntf *ri = (RoutineIntf *)(*ms)(p);
		TypeInterface *ti = ri->get_type();
		method m = ti->get_method();
		ptsig(m);
		}
        dec_ind();
	ps("end ");
	pstr(tin->get_id()->get_id());
	ps("\n\n");
	fclose(f);
}

static void pth_rtn(RoutineDef *rd, bool viz)
{
    	f = fopen(pth_name, "a");
	RoutineIntf *ri = rd->get_routineIntf();
	string nm = ri->get_id()->get_id();
	pstr(nm);
	ps("_Rtn_Class = ");
	if (viz) ps (" VISIBLE ");
	ps("class ()\n");
	inc_ind();
	TypeInterface *ti = ri->get_type();
	method m = ti->get_method();
	string save = m->name;
	m->name = string_new("invoke");
	ptsig(m);
	m->name = save;
	dec_ind();
	ps("end ");
	pstr(nm);
	ps("_Rtn_Class\n\n");
	fclose(f);
}

static void pth_class(ClassDef *cd)
{
int pass;
string mname;
fevalue tgm_ret[2];
type t;
objtype ot = 0;
bool doit;

    	f = fopen(pth_name, "a");
	pstr(cd->get_classId()->get_id());
	ps(" = ");
	TypeSpec *ts = cd->get_deftype();
	if (ts) {
		t = ts->get_type()->get_type();
		ot = type_as_objtype(t);
		string nm = 0;
		switch (ts->tag()) {
			case TypeSpec::SimpleTypeSpecT: {
				nm = ts2nm(ts, cd->get_line());
				break;
				}
			case TypeSpec::ParamTypeSpecT: {
				ParamTypeSpec *pts = (ParamTypeSpec *)ts;
				nm = pts->get_name()->get_name()->get_id();
				break;
				}
			}
		if (nm) pstr(nm);
		ps(" ");
		}
	ps("class (");
        ParseNodeList *decls = cd->get_decl();
	// pass0 does ivar decls, pass1 does get/set methods
	int n = 1;
	int last = count_lhs(decls);
        for (pass = 0; pass < 2; pass++) {
            if (pass == 1) inc_ind();
	    if (decls) for (Pix p = decls->first(); p ; decls->next(p)) {
		Decl *d = (Decl *)(*decls)(p);
		switch (d->tag()) {
			case Decl::RegDeclT: {
				if (pass == 1) break;
				RegDecl *rd = (RegDecl *)d;
				TypeInterface *ti = rd->get_type();
				type t = ti->get_type();
				ParseNodeList *ids = rd->get_ids();
				for (Pix p1 = ids->first(); p1 ; ids->next(p1)) {
				    Id *id = (Id *)(*ids)(p1);
				    string nm = id->get_id();
				    ptivar(t, nm);
				    if (n != last) {ps(", "); n++;}
				    }
				break;
				}
			case Decl::ImplDeclT: {
				ImplDecl *imd = (ImplDecl *)d;
				string nm = imd->get_id()->get_id();
				TypeInterface *ti = imd->get_type();
				type t = ti->get_type();
				if (pass == 0) {
				   ptivar(t, nm);
				   if (n != last) {ps(", "); n++;}
				   }
				if (pass == 1) {
				   if (imd->get_get()) {
				      mname = imd->get_get()->get_id();
				      doit = FALSE;
				      if (ot) {
				        RESET_EXC
					getMethod(ot, tgm_ret, mname);
				      	   CATCH {
						   RESET_EXC
						   doit = TRUE;
						   }
					}
				      else doit = TRUE;
				      if (doit) ptgetsig(t, nm, mname, FALSE);
				     }
				   if (imd->get_set()) {
				      mname = imd->get_set()->get_id();
				      doit = FALSE;
				      if (ot) {
				        RESET_EXC
				        getMethod(ot, tgm_ret, mname);
				      	   CATCH {
						   RESET_EXC
						   doit = TRUE;
						   }
					 }
				      else doit = TRUE;
				      if (doit) ptsetsig(t, nm, mname, FALSE);
				     }
				   }
				break;
				}
			}
		}
            if (pass == 0) ps(")\n");
	    }
        ParseNodeList *celts = cd->get_classElts();
	if (celts) for (Pix p = celts->first(); p ; celts->next(p)) {
		ParseNode *n = (*celts)(p);
		switch (n->tag()) {
			case ParseNode::MethodOrOpDefT:{
				// could decorate mop nodes directly in tc
				MethodOrOpDef *mopd = (MethodOrOpDef *)n;
				TypeInterface *ti = 
					mopd->get_routineDef()->get_type();
				method m = ti->get_method();
				mname = m->name;
				doit = FALSE;
				if (ot) {
				  RESET_EXC
				  getMethod(ot, tgm_ret, mname);
				      CATCH {
					   RESET_EXC
					   doit = TRUE;
					   }
				  }
				else doit = TRUE;
				if (doit) ptsig(m);
				}
			}
		}
        dec_ind();
	ps("end ");
	pstr(cd->get_classId()->get_id());
	ps("\n\n");
	fclose(f);
}

static void end_pth_file()
{
	// Not sure there's much to do here...
}

/*	Emit file containing information for builtin data structures */

static char *data_name = 0;
static void begin_data_file(string nm)
{
	create_support_file(nm, "data", &data_name);
    	f = fopen(data_name, "a");
	ps("\n");
/*
	ps("\n#include \"config/vdefs/");
	popt();
	ps(".h\"\n\n");
	ps("#if ");
	popt();
	ps("\n");
*/
	fclose(f);
}

static void data_type(TypeIntf *tin)
{
	tname = string_charp(tin->get_id()->get_id());
    	f = fopen(data_name, "a");
	ptname();
	ps("\t");
	ptname();
	ps ("_V\tFALSE\tWK_");
	ptname();
	ps("_OREF\tInit_");
	ptname();
	ps("\n");
	fclose(f);
}

static void data_rtn(RoutineDef *rd)
{
RoutineIntf* ri = rd->get_routineIntf();
bool mkr = FALSE;

	if (ri->tag() == RoutineIntf::MakeHeaderT) mkr = TRUE;
    	f = fopen(data_name, "a");
	rname = string_charp(rd->get_routineIntf()->get_id()->get_id());
	prname();
	ps ("_Rtn_Class");
	ps("\t");
	prname();
	ps ("_Rtn_Class");
	ps ("_V\tFALSE\tWK_");
	prname();
	ps ("_Rtn_Class");
	ps("_OREF\t");
	if (mkr) ps("0");
	else {
		ps("Init_");
		prname();
		ps ("_Rtn_Class");
		}
	ps("\n");
	fclose(f);
}

static void data_class(ClassDef *cd)
{
    	f = fopen(data_name, "a");
	cname = string_charp(cd->get_classId()->get_id());
	pcname();
	ps("\t");
	pcname();
	ps ("_V\tFALSE\tWK_");
	pcname();
	ps("_OREF\tInit_");
	pcname();
	ps("\n");
	fclose(f);
}


static void end_data_file()
{
	f = fopen(data_name, "a");
	output_pts_data();
/*
	ps("#endif\n");
*/
	ps("\n");
	fclose(f);
}

/*	Emit file containing external declarations	*/

static char *extern_name = 0;
static void begin_extern_file(string nm)
{
	create_support_file(nm, "externs.h", &extern_name);
    	f = fopen(extern_name, "a");
	ps("#ifndef _");
	popt();
	ps("_EXTERNS_H\n");
	ps("#define _");
	popt();
	ps("_EXTERNS_H\n\n");
//	ps("#include \"types1/type_def.h\"\n\n");
	fclose(f);
}

static void extern_type(TypeIntf *tin)
{
    	f = fopen(extern_name, "a");
	ps ("extern struct Objtype_s *");
	ptname();
	ps("_V;\n");
	ps("extern void Init_");
	ptname();
	ps("();\n");
	fclose(f);
}

static void extern_rtn(RoutineDef *rd)
{
RoutineIntf* ri = rd->get_routineIntf();

	// if (ri->tag() == RoutineIntf::MakeHeaderT) return;
    	f = fopen(extern_name, "a");
	ps ("extern struct Class_s *");
	prname();
	ps ("_Rtn_Class");
	ps("_V;\n");
	ps ("extern void Init_");
	prname();
	ps ("_Rtn_Class");
	ps("();\n");
	fclose(f);
}

static void extern_class(ClassDef *cd)
{
    	f = fopen(extern_name, "a");
	ps ("extern struct Class_s *");
	pcname();
	ps("_V;\n");
	ps ("extern void Init_");
	pcname();
	ps("();\n");
	fclose(f);
}

static void end_extern_file()
{
    	f = fopen(extern_name, "a");
	output_pts_decls();
	ps("\n#endif /* _");
	popt();
	ps("_EXTERNS_H */\n");
	fclose(f);
}

// static ImplModule *save_im = NULL;
// 
// void mod_impls_save(ImplModule *im)
// {
// 	save_im = im;
// 	}
// 
// void mod_impls_clear()
// {
// 	save_im = NULL;
// 	}
// 
// static bool mod_impls_member(RoutineDef *rd)
// {
// 	if (!save_im) return FALSE;
// 	RoutineIntf *ri = rd->get_routineIntf();
// 	Id *id = ri->get_id();
// 	const char *rinm = string_charp(id->get_id());
// 	ParseNodeList *exports = save_im->get_exports();
// 	if (exports) for (Pix p = exports->first() ; p ; exports->next(p)) {
// 		Id *ex_id = (Id *)(*exports)(p);
// 		const char *exnm = string_charp(ex_id->get_id());
// 		if (!strcmp(rinm, exnm)) return TRUE;
// 		}
// 	return FALSE;
// 	}
// 
// const char *find_class_that_defines_method(method m)
// {
// type t = get_save_class()->get_type()->get_type();
// fevalue tgm_ret[2];
// objtype ot = type_as_objtype(t);
// 
// 	// loop through class's methods
// 	// if found return class's name
// 	for (int i = 0; i < vec_length(ot->methods_); i++) {
// 		method ithm = UNPV(method, vec_fetch(ot->methods_, i));
// 		if (string_equal(ithm->name, m->name)) {
// 			return string_charp(ot->name);
// 			}
// 		}
// 
// 	// now loop through the superclasses
// 	// return the name of the superclass where m is found...
// 	// check kind to see if it's a class ??!
// 	class_ c = (class_) ot;
// 	for (int j = 0; j < vec_length(c->superclass); j++) {
// 		class_ ithc = UNPV(class_, vec_fetch(c->superclass, j));
// 		ot = type_as_objtype(class_as_type(ithc));
// 		for (int i = 0; i < vec_length(ot->methods_); i++) {
// 			method ithm = UNPV(method, vec_fetch(ot->methods_, i));
// 			if (string_equal(ithm->name, m->name)) {
// 				ot = type_as_objtype(class_as_type(ithc));
// 				return string_charp(ot->name);
// 				}
// 			}
// 		}
// 	return ""; // really shouldn't get here...
// 	}

// This algorithm is simple but incorrect.  Used in Thor1.
void simple_computeBitfields(class_ c)
{
    c->slots = vec_length(c->fields);
    int bfs = 0;
    if (c->slots > 32) cmp_err("bitfield computation incorrect", 200);
    for (int i = 0; i < c->slots; i++) {
	formal f = UNPV(formal, vec_fetch(c->fields, i));
	if (is_vtype(f->t)) continue;
	bfs |= (1 << i);
	}
    c->bitfields = make_vec_Int(1, FALSE);
    vec_store(c->bitfields, 0, PV(bfs));
    }

void new_computeBitfields(int bps, class_ c)
{
int num_slots = 0;
int room_in_slot = bps;
int bfs = 0;
int nfields = vec_length(c->fields);

	// num_slots is incremented when the slot starts being used
	// room_in_slot reflects available bytes in current slot,
	// 	or bps if there is no room in current slot

    	if (c->slots > 32) cmp_err("bitfield computation incorrect", 200);
	for (int i = 0; i < nfields; i++) {
		formal f = UNPV(formal, vec_fetch(c->fields, i));
		if (!is_vtype(f->t)) {
			/* PTR (slot size type) */
			bfs |= 1 << num_slots;
			num_slots++;
			room_in_slot = bps;
			}
		else {
			const char *tnmc = string_charp(simple_type_name
					(type_name(f->t)));
			if (!strcmp("int", tnmc) || !strcmp("null", tnmc)) {
				/* INT (or NULL) (4 byte types) */
				switch (bps) {
				    case 4: {
					num_slots++;
					room_in_slot = bps;
					break;
					}
				    case 8: {
					switch (room_in_slot) {
						case 8: {
							num_slots++;
							room_in_slot -= 4;
							break;
							}
						case 6: {
							room_in_slot -= 4;
							break;
							}
						case 4: {
							room_in_slot = bps;
							break;
							}
						case 2: {
							num_slots++;
							room_in_slot = bps - 4;
							break;
							}
						}
					break;
					}
				    }
				}
			if (!strcmp("char", tnmc) || !strcmp("bool", tnmc)) {
				/* CHAR OR BOOL (2 byte types) */
				switch (bps) {
				    case 4: {
					switch (room_in_slot) {
						case 4: {
							num_slots++;
							room_in_slot -= 2;
							break;
							}
						case 2: {
							room_in_slot = bps;
							break;
							}
						}
					break;
					}
				    case 8: {
					switch (room_in_slot) {
						case 8: {
							num_slots++;
							room_in_slot -= 2;
							break;
							}
						case 6: {
							room_in_slot -= 2;
							break;
							}
						case 4: {
							room_in_slot -= 2;
							break;
							}
						case 2: {
							room_in_slot = bps;
							break;
							}
						}
					break;
					}
				    }
				}
			}
		}
    	c->bitfields = make_vec_Int(1, FALSE);
    	vec_store(c->bitfields, 0, PV(bfs));
	c->slots = num_slots;
	}

