// Copyright 1995 Barbara Liskov

#include "parse.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "types/class_class.h"
#include "client/gen-include-1.h"
#include "cg.h"
#include "string.h"

extern int version;
extern bool emit_iter_prefix();
extern bool inlined_store(type t, Expr *new_prim, ParseNodeList *new_index, 
			ParseNodeList *new_exprs);
extern bool rid_emit(Invoc *inv, RoutineId *rid, int pass,
	Expr **prim, bool *is_supercm,
        bool *is_meth, const char **casting, string *supercnm, string *rtn_nm);
extern void self_obj_emit(const char *casting, bool is_supercm, string supercnm,
                        Expr *prim, bool is_meth, string mkslfnm,
                        string mkslfst, string rtn_nm);
extern void inv_args_emit(Invoc *inv);

extern const char *cname;

static void handle_spec_mod(SpecModule *sm);
static void handle_type_intf(TypeIntf *tin);
static void handle_routine_spec(RoutineSpec *rs);
static void handle_impl_mod(ImplModule *im);
static void handle_class_def(ClassDef *cd, objtype ot);
static void handle_routine_def(RoutineDef *rd);
static void handle_method_def(RoutineDef *rd);
static void handle_routine_intf(RoutineIntf *ri);
static method handle_method_intf(RoutineDef *rd);
void handle_body_1(Body *body);
static void handle_stmt(Stmt *stmt);
static void handle_ivars(ParseNodeList *pnl, objtype ot, ClassDef *cd);
static void handle_mopdef(MethodOrOpDef *mopd);
static void handle_if(IfStmt *ifstmt);
static void handle_decl(DeclStmt *declstmt);
static void handle_ive(InitVarExpr *ivestmt);
static void handle_ivi(InitVarInvoke *ivistmt);
static void handle_aes(AssignExprStmt *aesstmt);
static void handle_inv(InvokeStmt *invstmt);
static void handle_while(WhileStmt *whilestmt);
static void handle_tagc(Tagcase *tagcstmt);
static void handle_typec(Typecase *typecstmt);
static void handle_ret(ReturnStmt *retstmt);
static void handle_yield(Yield *yieldstmt);
static void handle_sig(SignalStmt *sigstmt);
static void handle_exit(Exit *exitstmt);
static void handle_break();
static void handle_cont();
static void handle_resig(ResignalStmt *resigstmt);
static void handle_excpt(ExceptStmt *excptstmt);
static void handle_init(Init *initstmt);
static void handle_declfor(DeclForStmt *declforstmt);
static void handle_for(ForStmt *forstmt);
static void p_yield_switch(method m);

#define DEBUG 0

static string file_name = 0;

void code_generator_1(ParseNodeList *pnl, string nm)
{
    clear_global_pts();
    file_name = nm;
    begin_support_files_1(nm);
    eq_clear();
    if (pnl) for (Pix p = pnl->first(); p; pnl->next(p)) {
        Module *m = (Module *)(*pnl)(p);
	if (DEBUG) m->print(2);
	switch (m->tag()) {
		case Module::SpecModuleT: {
    			SpecModule *sm = (SpecModule *)m;
	 		handle_spec_mod(sm);
			break;
			}
		case Module::ImplModuleT: {
    			ImplModule *im = (ImplModule *)m;
	 		handle_impl_mod(im);
			break;
			}
	 	} // end switch
    }
    end_support_files_1();
    clear_global_pts();
}

static void handle_spec_mod(SpecModule *sm)
{
	ParseNodeList *specs = sm->get_specs();
	if (specs) for (Pix p = specs->first(); p; specs->next(p)) {
            SpecElt *spec = (SpecElt *)(*specs)(p);
	    switch (spec->tag()) {
		case SpecElt::TypeIntfT: {
			TypeIntf *tin = (TypeIntf*)spec;
			handle_type_intf(tin);
			break;
			}
		case SpecElt::RoutineSpecT: {
			RoutineSpec *rs = (RoutineSpec *)spec;
			handle_routine_spec(rs);
			break;
			}
		case SpecElt::SpecEquateT: {
			SpecEquate *seq = (SpecEquate *)spec;
			eq_save(seq->get_equate());
			break;
			}
		}
	    }
	}

static void handle_type_intf(TypeIntf *tin)
{
	TypeInterface *ti = tin->get_type();
	type t = ti->get_type();
	if (t) {
		objtype ot = type_as_objtype(t);
		make_includes_1(ot, NULL, NULL);
		string tname = type_name(t);
	        extend_support_files_1(tin);
		do_type_file_1(string_concat(tname, string_new(".c")),
				tname, ot, tin);
		}
	else {
		if (DEBUG) tin->print(2);
		cmp_err("Unexpected TypeIntf TI in handle_type_intf",
				tin->get_line());
		}
   }

static void handle_routine_spec(RoutineSpec *rs)
{
   }

static void handle_impl_mod(ImplModule *impl_mod)
{
    mod_impls_save(impl_mod);
    ParseNodeList *eqs = impl_mod->get_equates();
    if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
	Equate *eq = (Equate *)(*eqs)(p);
	eq_save(eq);
	}
    ParseNodeList *exports = impl_mod->get_exports();
    ParseNodeList *impls = impl_mod->get_impls();
    if (impls) for (Pix p = impls->first(); p; impls->next(p)) {
	ImplElt *ie = (ImplElt*)(*impls)(p);
	switch (ie->tag()) {
		case ImplElt::ImplEquateT: {
			ImplEquate *ieq = (ImplEquate *)ie;
			eq_save(ieq->get_equate());
			break;
			}
		case ImplElt::RoutineDefT:{
			RoutineDef *rd = (RoutineDef *)ie;
   			RoutineIntf* ri = rd->get_routineIntf();
			string rname = ri->get_id()->get_id();
			bool do_pth = FALSE;
			if (exports) for (Pix p1 = exports->first(); p1; 
						exports->next(p1)) {
				Id *id = (Id *)(*exports)(p1);
				if (string_equal(id->get_id(), rname)) {
					do_pth = TRUE;
					break;
					}
				}
	    		// if (do_pth) 
			extend_support_files_1(ie);
			handle_routine_def(rd);
			break;
			}
		case ImplElt::ClassDefT:{
			ClassDef *cd = (ClassDef *)ie;
	    		extend_support_files_1(ie);
			save_class(cd);
			TypeSpec *df = cd->get_deftype();
			type t = 0;
			objtype ot = 0;
			string tname = 0;
			if (df) {
				t = df->get_type()->get_type();
				ot = type_as_objtype(t);
				tname = type_name(t);
				}
			string cname = cd->get_classId()->get_id();
			begin_class_file_1(string_concat(cname, string_new(".c")),
				tname, cname, ot, cd);
			eq_emit_saved();
			handle_class_def(cd, ot);
			end_class_file_1();
			clear_class();
			break;
			}
		}
	}
    mod_impls_clear();
    }

static void handle_routine_def(RoutineDef *rd)
{
   save_rdef(rd);
   RoutineIntf* ri = rd->get_routineIntf();
   string nm = ri->get_id()->get_id();
   method m = ri->get_type()->get_method();
   switch (ri->tag()) {
	case RoutineIntf::MakeHeaderT: {
		ClassDef *cd = rd->get_cdef();
		save_class(cd);
		string cname = cd->get_classId()->get_id();
   		make_mkr_includes_1(m);
	   	begin_rtn_file_1(string_concat(nm,string_new(".c")), rd, nm, m);
	   	eq_emit_saved();
	   	handle_routine_intf(ri);
	   	ps("{\n");
	   	ps("struct ");
		pstr(cname);
	   	ps("_f_s *Fp_self = SELF_FIELDS(self, ");
		pstr(cname);
	   	ps(");\n");
	   	decl_locals(rd);
	   	decl_temps(rd);
	   	ps("SETUP_SELF(self, ");
		pstr(cname);
	   	ps(");\n");
		ps("MARK_USED_F(Fp_self);\n");
	   	Body* b = rd->get_body();
	   	handle_body_1(b);
	   	do_closing(rd);
		clear_class();
	   	ps("}\n\n");
	   	end_mkr_file_1();
		break;
		}
	case RoutineIntf::ProcHeaderT: {
   		make_rtn_includes_1(m);
	   	begin_rtn_file_1(string_concat(nm,string_new(".c")), rd, nm, m);
	   	eq_emit_saved();
	   	handle_routine_intf(ri);
	   	ps("{\n");
	   	ps("struct ");
	   	prname();
	   	ps("_f_s *Fp_self = SELF_FIELDS(self, ");
	   	prname();
	   	ps(");\n");
	   	decl_locals(rd);
	   	decl_temps(rd);
	   	ps("SETUP_SELF(self, ");
	   	prname();
	   	ps("_Rtn_Class);\n");
		ps("MARK_USED_F(Fp_self);\n");
	   	Body* b = rd->get_body();
	   	handle_body_1(b);
	   	do_closing(rd);
	   	ps("}\n\n");
	   	end_rtn_file_1();
		break;
		}
	case RoutineIntf::IterHeaderT: {
		make_iter_includes_1(m, rd);
		set_iter_active();
	   	begin_rtn_file_1(string_concat(nm,string_new(".c")), rd, nm, m);
	   	eq_emit_saved();
	   	handle_routine_intf(ri);
	   	ps("{\n");
		ps("Pval MT_1;\n");
	   	ps("struct ");
	   	prname();
	   	ps("_f_s *Fp_self = SELF_FIELDS(self, ");
	   	prname();
	   	ps(");\n");
	   	// decl_locals(rd);
	   	// decl_temps(rd);
	   	ps("SETUP_SELF(self, ");
	   	prname();
	   	ps("_Rtn_Class);\n");
		ps("MARK_USED_F(Fp_self);\n");
	        p_yield_switch(m);
	   	Body* b = rd->get_body();
	   	handle_body_1(b);
	   	do_closing(rd);
	   	ps("}\n\n");
	   	end_rtn_file_1();
		clear_iter_active();
		break;
		}
	}
   clear_rdef();
   }

static void handle_method_def(RoutineDef *rd)
{
   method m = handle_method_intf(rd);
   ps("{\n");
   if (m->iter) ps("Pval MT_1;\n");
   ps("struct ");
   pcname();
   ps("_f_s *Fp_self = SELF_FIELDS(self, ");
   pcname();
   ps(");\n");
   if (m->iter) {
	set_iter_active();
   	ps("SETUP_SELF(self, ");
   	pcname();
   	ps(");\n");
        ps("MARK_USED_F(Fp_self);\n");
        p_yield_switch(m);
   	Body* b = rd->get_body();
   	handle_body_1(b);
   	do_closing(rd);
   	ps("}\n\n");
	clear_iter_active();
	}
   else {
   	decl_locals(rd);
   	decl_temps(rd);
   	ps("SETUP_SELF(self, ");
   	pcname();
   	ps(");\n");
        ps("MARK_USED_F(Fp_self);\n");
   	Body* b = rd->get_body();
   	handle_body_1(b);
   	do_closing(rd);
   	ps("}\n\n");
   	}
   }

static void p_yield_switch(method m)
{
    inc_ind();
    ind();
    inc_ind();
    ps("switch (IState->pc) {\n");
    for (int i = 0; i <= get_yields(); i++) {
        ind();
        ps("case ");
        pint(i);
        ps(": goto yield_");
        pint(i);
        ps(";\n");
        }
    dec_ind();
    ind();
    ps("}\n");
    dec_ind();
    ps("yield_0:\n");
    }

static void handle_class_def(ClassDef *cd, objtype deft)
{

   ParseNodeList *decls = cd->get_decl();
   type t = cd->get_type()->get_type();
   objtype ot = type_as_objtype(t);
   // string contents = gen_class_inc(type_as_class(t));
   // make_include(string_concat(ot->name, string_new("_class.h")), contents);
   objtype ot_stripd = stripped_class(ot);
   make_includes_1(ot_stripd, ot, deft);
   handle_ivars(decls, ot, cd);

   ParseNodeList *eqs = cd->get_equates();
   if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
	Equate *eq = (Equate *)(*eqs)(p);
	eq_emit(eq);
	}
   ParseNodeList *celts = cd->get_classElts();
   if (celts) for (Pix p = celts->first(); p; celts->next(p)) {
	ParseNode *pn = (*celts)(p);
	switch (pn->tag()) {
		case ParseNode::EquateT: {
			Equate *eq = (Equate *)pn;
			eq_emit(eq);
			break;
			}
		case ParseNode::MethodOrOpDefT:{
			MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
			fix_clear();
			handle_mopdef(mopd);
			break;
			}
		}
	}
   }

static void handle_routine_intf(RoutineIntf *ri)
{
   method m = ri->get_type()->get_method();
   switch (ri->tag()) {
	case RoutineIntf::MakeHeaderT: {
		pmkrsig_1(m);
		break;
		}
	case RoutineIntf::ProcHeaderT:
   		prsig_1(m);
		break;
	case RoutineIntf::IterHeaderT: {
	        pitersig_1(m, 0);
		break;
		}
	}
   }

static method handle_method_intf(RoutineDef *rd)
{
   RoutineIntf* ri = rd->get_routineIntf();
   method m = ri->get_type()->get_method();
   if (m->iter) {
	type t = get_save_class()->get_type()->get_type();
	make_iter_method_includes_1(type_as_objtype(t), m, rd);
	pitersig_1(m, rd);
	}
   else pmsig_1(m);
   return m;
   }

static void handle_ivars(ParseNodeList *decls, objtype ot, ClassDef *cd)
{
int i;
   objtype ct = (ot->supertypes_ && vec_length(ot->supertypes_)) ?
		type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, 0)))
		: 0 ;
   if (decls) for (Pix p = decls->first(); p; decls->next(p)) {
	Decl *d = (Decl *)(*decls)(p);
	if (d->tag() != Decl::ImplDeclT) continue;
	ImplDecl *imd = (ImplDecl *)d;
	Id *id = imd->get_id();
	string sid = id->get_id();
	Id *imdget = imd->get_get();
	Id *imdset = imd->get_set();
	string gnm = imdget?imdget->get_id():0;
	string snm = imdset?imdset->get_id():0;
   	for (i = 0; i < vec_length(ot->methods_); i++) {
		method m = UNPV(method, vec_fetch(ot->methods_,i));
		if (gnm && string_equal(gnm, m->name)) {
			type t = UNPV(type, vec_fetch(m->returns, 0));
			pmsig_1(m); 
			ps("{\n");
			// ps(" Core_p Cp_self = OBJ_CORE(self);\n");
			// ps(" Field_p Fp_self = FIELDS(Cp_self);\n ");
   			ps("struct ");
   			pcname();
   			ps("_f_s *Fp_self = SELF_FIELDS(self, ");
   			pcname();
   			ps(");\n");	
			pstr(simple_type_name(type_name(t)));
			ps(" MT_0;\n");

			ps("SETUP_SELF(self, ");
			pcname();
			ps(");\n");
   			ps("MARK_USED_F(Fp_self);\n\n");
			if (!cd->get_immutable()) {
			   ps("   PREPARE_READ_F(self, Fp_self);\n");
			   // ps("   MARK_USED_F(Fp_self);\n");
			   }
			if (is_vtype(t)) ps("   GETV_F(MT_0, Fp_self, ");
			else ps("   GETP_IF(MT_0, Fp_self, ");
			pstr(sid);
			ps(", ");
			pcname();	     // self's type
			if (!is_vtype(t)) {
				ps(", ");
				pstr(simple_type_name(type_name(t)));  // field's type
				ps(", ");
				pstr(type2nm(t));  // field's type object
				ps("_V");
				}
			ps(");\n");
			ps("   return MT_0;\n   }\n\n");
			continue;
			}
		if (snm && string_equal(snm, m->name)) {
			formal f = UNPV(formal, vec_fetch(m->arguments, 0));
			pmsig_1(m); 
			ps("{\n");
			// ps(" Core_p Cp_self = OBJ_CORE(self);\n");
			// ps(" Field_p Fp_self = FIELDS(Cp_self);\n");
   			ps("struct ");
   			pcname();
   			ps("_f_s *Fp_self = SELF_FIELDS(self, ");
   			pcname();
   			ps(");\n");
			ps("SETUP_SELF(self, ");
			pcname();
			ps(");\n");
   			ps("MARK_USED_F(Fp_self);\n\n");
			ps("   PREPARE_WRITE_F(self, Fp_self);\n");
			if (!is_vtype(f->t))
			   ps("   PREPARE_PWRITE_F(Fp_self);\n");
			// ps("   MARK_USED_F(Fp_self);\n");
			if (is_vtype(f->t)) ps("   PUTV_F(Fp_self, ");
			else ps("   PUTP_F(Fp_self, ");
			pstr(sid);
			ps(", ");
			pstr(sid);
			ps(", ");
			pcname();
			ps(");\n   }\n\n");
			}
			continue;
		}
	}
   }

static void handle_mopdef(MethodOrOpDef *mopd)
{
  RoutineDef *rd = mopd->get_routineDef();
  save_rdef(rd);
  if (mopd->get_isOp()) handle_routine_def(rd); // is this used??
  else handle_method_def(rd);
  clear_rdef();
  }

void handle_body_1(Body *b)
{
   if (b) {
   inc_ind();
   fix_new_scope();
   ParseNodeList *eqs = b->get_equates();
   if (eqs) for (Pix p = eqs->first(); p; eqs->next(p)) {
	Equate *eq = (Equate *)(*eqs)(p);
	eq_emit(eq);
	}
   ParseNodeList *stmts = b->get_statements();
   if (stmts) for (Pix p = stmts->first(); p; stmts->next(p)) {
	Stmt *stmt = (Stmt *)(*stmts)(p);
	handle_stmt(stmt);
	}
   fix_end_scope();
   dec_ind();
   }
   }

static void handle_stmt(Stmt *stmt)
{
   ps("/* LINE ");
   pint(stmt->get_line());
   if (file_name) {
   	ps(" \"");
   	pstr(file_name);
   	ps("\"");
	}
   ps(" */\n");
   switch (stmt->tag()) {
	case Stmt::DeclStmtT: {
		DeclStmt *declstmt =  (DeclStmt *)stmt;
		handle_decl(declstmt);
		break;
		}
	case Stmt::InitVarExprT: {
		InitVarExpr *ivestmt =  (InitVarExpr *)stmt;
		handle_ive(ivestmt);
		break;
		}
	case Stmt::InitVarInvokeT: {
		InitVarInvoke *ivistmt =  (InitVarInvoke *)stmt;
		handle_ivi(ivistmt);
		break;
		}
	case Stmt::AssignInvokeT: {
		// unused
		break;
		}
	case Stmt::AssignExprStmtT: {
		AssignExprStmt *aesstmt =  (AssignExprStmt *)stmt;
		handle_aes(aesstmt);
		break;
		}
	case Stmt::AssignExprT: {
		// unused
		break;
		}
	case Stmt::InvokeStmtT: {
		InvokeStmt *invstmt =  (InvokeStmt *)stmt;
		handle_inv(invstmt);
		break;
		}
	case Stmt::WhileStmtT: {
		WhileStmt *whilestmt =  (WhileStmt *)stmt;
		handle_while(whilestmt);
		break;
		}
	case Stmt::IfStmtT: {
		IfStmt *ifstmt =  (IfStmt *)stmt;
		handle_if(ifstmt);
		break;
		}
	case Stmt::TagcaseT: {
		Tagcase *tagcstmt =  (Tagcase *)stmt;
		handle_tagc(tagcstmt);
		break;
		}
	case Stmt::TypecaseT: {
		Typecase *typecstmt =  (Typecase *)stmt;
		handle_typec(typecstmt);
		break;
		}
	case Stmt::ReturnStmtT: {
		ReturnStmt *retstmt =  (ReturnStmt *)stmt;
		handle_ret(retstmt);
		break;
		}
	case Stmt::YieldT: {
		Yield *yieldstmt =  (Yield *)stmt;
		handle_yield(yieldstmt);
		break;
		}
	case Stmt::SignalStmtT: {
		SignalStmt *sigstmt =  (SignalStmt *)stmt;
		handle_sig(sigstmt);
		break;
		}
	case Stmt::ExitT: {
		Exit *exitstmt =  (Exit *)stmt;
		handle_exit(exitstmt);
		break;
		}
	case Stmt::BreakT: {
		handle_break();
		break;
		}
	case Stmt::ContinueT: {
		handle_cont();
		break;
		}
	case Stmt::BlockStmtT: {
		BlockStmt *blockstmt =  (BlockStmt *)stmt;
		Body *body = blockstmt->get_body();
		handle_body_1(body);
		break;
		}
	case Stmt::ResignalStmtT: {
		ResignalStmt *resigstmt =  (ResignalStmt *)stmt;
		handle_resig(resigstmt);
		break;
		}
	case Stmt::ExceptStmtT: {
		ExceptStmt *excptstmt =  (ExceptStmt *)stmt;
		handle_excpt(excptstmt);
		break;
		}
	case Stmt::InitT: {
		Init *initstmt =  (Init *)stmt;
		handle_init(initstmt);
		break;
		}
	case Stmt::DeclForStmtT: {
		DeclForStmt *declforstmt =  (DeclForStmt *)stmt;
		handle_declfor(declforstmt);
		break;
		}
	case Stmt::ForStmtT: {
		ForStmt *forstmt =  (ForStmt *)stmt;
		handle_for(forstmt);
		break;
		}
	}
   }

static void handle_if(IfStmt *ifstmt)
{
   Expr *ex = ifstmt->get_expr();
   Expr *ex2 = expr_preprocess(ex);
   ind();
   ps("if(");
   expr_emit(ex2);
   ps(") {\n");
   Body* b = ifstmt->get_body();
   handle_body_1(b);
   ind();
   ps("}\n");
   ParseNodeList *elseifs = ifstmt->get_elseifs();
   if (elseifs) for (Pix p = elseifs->first(); p ; elseifs->next(p)) {
   	ElseIf *ei = (ElseIf *)(*elseifs)(p);
	ind();
	ps("else {\n");
	ind();
   	ex = ei->get_expr();
   	ex2 = expr_preprocess(ex);
   	ps("if(");
	expr_emit(ex2);
	ps(") {\n");
   	b = ei->get_body();
   	handle_body_1(b);
        ps("}\n");
	}
   ind();
   b = ifstmt->get_elsebody();
   if (b) {
   	ps("else {\n");
   	handle_body_1(b);
	ind();
	ps("}");
	}
   int elses = elseifs?elseifs->length():0;
   for (int i = 0; i < elses ; i++) {
   	ps("}");
	}
   if (elses || b) ps("\n");
   }

static void handle_decl(DeclStmt *declstmt)
{
   // nothing to do here...
   }

static void handle_ive(InitVarExpr *ivestmt)
{
   Decl *decl = ivestmt->get_decl();
   Expr *ex = ivestmt->get_expr();
   Expr *ex2 = expr_preprocess(ex);
   type t = get_one_type(ex2->get_type(), 88);
   emit_iter_prefix();
   decl_emit(decl);
   ps(" = ");
   bool needs_cast = assn_cast_site(decl, t);
   bool is_any = anyize(decl, t);
   expr_emit(ex2);
   if (is_any) ps(")");
   if (needs_cast) ps(")");
   ps(";\n");
   }

static void handle_ivi(InitVarInvoke *ivistmt)
{
   ParseNodeList *decls = ivistmt->get_decls();
   Invoc *inv = ivistmt->get_invoc();
   ParseNode *pn = inv_preprocess(inv);
   Decl *d = (Decl*)decls->front();
   RegDecl *rd = (RegDecl*)d;
   ParseNodeList *ids = rd->get_ids();
   Id *id = (Id *)ids->front();
   ind();
   emit_iter_prefix();
   pstr(id->get_id());
   ps(" = ");
   pn_emit(pn);
   ps(";\n");
   pn_check_emit(pn);		// assumes signature is the same
   bool first = TRUE;
   int i = 0;
   for (Pix p = decls->first(); p; decls->next(p)) {
	Decl *d = (Decl *)(*decls)(p);
   	RegDecl *rd = (RegDecl*)d;
	ParseNodeList *ids = rd->get_ids();
	for (Pix q = ids->first(); q; ids->next(q)) {
		if (first) {first = FALSE; continue;}
		type t = get_nth_return_type(i+1);
		Id *id = (Id *)(*ids)(q);
		ind();
   		emit_iter_prefix();
		pstr(id->get_id());
		ps(" = ");
		bool needs_cast = assn_cast_site(d, t);
		bool is_any = anyize(d, t);
		if (is_vtype(t)) ps("PV_as_prim(");
		else ps("PV_as_obj(");
		pstr(simple_type_name(type_name(t)));
		ps(", ");
		emit_iter_prefix();
		ps("__extravals[");
		pint(i);
		ps("])");
		// ps(type2discr(t));
		i++;
		if (is_any) ps(")");
		if (needs_cast) ps(")");
		ps(";\n");
		}
	}
   }

static void aes_2(Expr *exid, Expr *ex, type t, int ith);
static void handle_aes(AssignExprStmt *aesstmt)
{
   Pix p,q;
   ParseNodeList *ids = aesstmt->get_ids();
   ParseNodeList *exprs = aesstmt->get_exprs();
   ParseNodeList *new_exprs = exprs_preprocess(exprs);
   // handle store statement
   // note: a[i], b[i] := 1,3 needs to be suppressed somewhere
   // note: a[i,j,k] shouldn't be allowed somewhere
   Expr *prim = (Expr *)ids->front();
   if (ids->length() == 1 && prim->tag() == Expr::BracketRefT) {
	BracketRef *br = (BracketRef *)(ids->front());
	bool parmd = FALSE;
	Expr *prim = br->get_primary();
	TypeInterface *ti = prim->get_type();
	type t = get_one_type(ti, 96);
	if (t && (type_kind(t) == INSTN_KIND || type_kind(t) == CLASS_INSTN_KIND
			|| type_kind(t) == PARAM_KIND)) parmd = TRUE;
	// check that there's a store method and check for any
	bool do_any = FALSE;
	RESET_EXC
	fevalue tgm_ret[2];
	getMethod(type_as_objtype(t), tgm_ret, string_new("store"));
	CATCH {
		cmp_err("No store method", aesstmt->get_line());
		}
	else {
		method m  = (method) tgm_ret[0].o;
		vec args = m->arguments;
		if (!args) cmp_err("No arguments required for store method",
			aesstmt->get_line());
		else if (vec_length(args) != 2)
			cmp_err("Wrong number of arguments for store method",
				aesstmt->get_line());
		else {
			formal at = UNPV(formal, vec_fetch(args, 1));
			if (at->t == objtype_as_type(Any)) do_any = TRUE;
			}
		}
	// preprocess primary
	Expr *new_prim = expr_preprocess(prim);
	// preprocess index
	ParseNodeList *new_index = exprs_preprocess(br->get_exprs());
	// emit store statement
        if (inlined_store(t, new_prim, new_index, new_exprs)) {}
	else {
		ind();
		ps("(DISPATCH_D(");
		expr_emit(new_prim);
		ps(", store, ");
		pstr(simple_type_name(type_name(t)));
		ps("))(");
		expr_emit(new_prim);
		ps(", ");
		expr_emit((Expr*)new_index->front());
		int i = 0;
		// sort of custom code for store:  could be more general
   		for (q = new_exprs->first(); q; new_exprs->next(q)) {
			ps(", ");
			Expr *ex = (Expr *)(*new_exprs)(q);
			type t = get_one_type(ex->get_type(), 88);
			if (parmd && i == 0) {
				if (is_vtype(t)) ps("Prim_as_PV(");
				else ps("Obj_as_PV(");
				}
			if (do_any) do_any = anyize_it(t);
   			expr_emit(ex);
			if (do_any) ps(")");
			if (parmd && i == 0) ps(")");
			i++;
			}
		ps(");\n");
	    }
	ind();
	ps("if(Exc) ");
	exc_goto_exc(FALSE);
	return;
	}
   // continue with normal cases
   cg_rhs = FALSE;
   ParseNodeList *new_ids = exprs_preprocess(ids);
   cg_rhs = TRUE;
   if (new_ids->length() != new_exprs->length()) {
	// This should be a single invocation on the rhs with mult ret vals.

	// First section handles invocation and assignment to 1st lhs id.
	Expr *exid = (Expr *)new_ids->front();
	Expr *ex = (Expr *)new_exprs->front();
	type t = get_first_type(ex->get_type(), 88);
	if (version == 0 || version == 1)  fix_write(exid);
	else fix_write_1(exid);
	if (version == 0 || version == 1) {
		ind();
		expr_emit(exid);
		ps(" = ");
		bool needs_cast = assn_cast_site(exid, t);
		bool is_any = anyize(exid, t);
   		expr_emit(ex);
		if (is_any) ps(")");
		if (needs_cast) ps(")");
   		ps(";\n");
		}
	else aes_2(exid, ex, t, 0);

	// This section handles getting other results out of extravals into
	// the non-initial lhs ids.
	bool first = TRUE;
	int i = 0;
	for (p = new_ids->first(); p; new_ids->next(p)) {
		if (first) {first = FALSE; continue;}
		Expr *exid = (Expr *)(*new_ids)(p);
		type t = get_nth_return_type(i+1);
		type it = get_one_type(exid->get_type(), 88);
		IdExpr *ide = (exid->tag() == Expr::IdExprT) ? (IdExpr *)exid:0;
		string nm = ide? ide->get_id()->get_id() : 0;
		const char *dummy;
		if (version == 0 || version == 1) fix_write(exid);
		else fix_write_1(exid);
		if (version == 0 || version == 1) {
			ind();
			expr_emit(exid);
			ps(" = ");
			bool needs_cast = assn_cast_site(exid, t);
			bool is_any = anyize(exid, t);
			if (is_vtype(t)) ps("PV_as_prim(");
			else ps("PV_as_obj(");
			pstr(simple_type_name(type_name(t)));
			ps(", ");
			emit_iter_prefix();
			ps("__extravals[");
			pint(i);
			ps("])");
			//ps(type2discr(t));
			if (is_any) ps(")");
			if (needs_cast) ps(")");
			ps(";\n");
			}
		else aes_2(exid, 0, t, i);
		i++;
		}
	return;
	}
   // Straight (multiple) assignment (invocation on rhs handled above)
   for (p = new_ids->first(), q = new_exprs->first(); p;
		new_ids->next(p), new_exprs->next(q)) {
	Expr *exid = (Expr *)(*new_ids)(p);
	Expr *ex = (Expr *)(*new_exprs)(q);
	type t = get_one_type(ex->get_type(), 88);
	if (version == 0 || version == 1) fix_write(exid);
	else fix_write_1(exid);
	if (version == 0 || version == 1) {
   		ind();
   		expr_emit(exid);
   		ps(" = ");
		bool needs_cast = assn_cast_site(exid, t);
		bool is_any = anyize(exid, t);
   		expr_emit(ex);
		if (is_any) ps(")");
		if (needs_cast) ps(")");
   		ps(";\n");
		}
	else aes_2(exid, ex, t, 0);
	}
   }

static void aes_2(Expr *exid, Expr *ex, type t, int ith)
{
type it = get_one_type(exid->get_type(), 88);

	switch (exid->tag()) {
		case Expr::IdExprT: {
			const char *dummy;
			IdExpr *ide = (IdExpr *)exid;
			string nm = ide->get_id()->get_id();
               		if (is_ivar(0, nm, &dummy)) {
                       		ind();
                       		ps("PUT");
                       		if (is_vtype(it)) ps("V");
                       		else ps("P");
                       		ps("_F(Fp_self, ");
                       		pstr(nm);
                       		ps(", ");
                       		if (ex) expr_emit(ex);
				else {
					if (is_vtype(t)) ps("PV_as_prim(");
					else ps("PV_as_obj(");
					pstr(simple_type_name(type_name(t)));
                        		ps(", ");
   	    				emit_iter_prefix();
					ps("__extravals[");
                        		pint(ith);
                        		ps("])");
					}
                       		ps(", ");
                       		pcname();
                       		ps(");\n");
                       		}
			else {
   				ind();
   				expr_emit(exid);
   				ps(" = ");
				bool needs_cast = assn_cast_site(exid,t);
				bool is_any = anyize(exid, t);
   				if (ex) expr_emit(ex);
				else {
					if (is_vtype(t)) ps("PV_as_prim(");
					else ps("PV_as_obj(");
					pstr(simple_type_name(type_name(t)));
                        		ps(", ");
   	    				emit_iter_prefix();
					ps("__extravals[");
                        		pint(ith);
                        		ps("])");
					}
				if (is_any) ps(")");
				if (needs_cast) ps(")");
   				ps(";\n");
				}
			break;
			}
		case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)exid;
			Expr *prim = de->get_primary();
			type pt = get_one_type(prim->get_type(), 88);
			Expr *deid = de->get_id();
			IdExpr *deide = (deid->tag() == Expr::IdExprT) ?
					(IdExpr *)deid: 0;
			string nm = deide? deide->get_id()->get_id():0;
   			ind();
			ps("PUT");
			if (is_vtype(it)) ps("V_D((Core_p)");
			else ps("P_D((Core_p)");
			expr_emit(prim);
			ps(", ");
			pstr(nm);
			ps(", ");
			if (ex) expr_emit(ex);
			else {
				if (is_vtype(t)) ps("PV_as_prim(");
				else ps("PV_as_obj(");
				pstr(simple_type_name(type_name(t)));
                        	ps(", ");
   	    			emit_iter_prefix();
				ps("__extravals[");
                        	pint(ith);
                        	ps("])");
                        	// ps(type2discr(t));
				}
			ps(", ");
			pstr(simple_type_name(type_name(pt)));
   			ps(");\n");
			break;
			}
		}
	}

static void handle_inv(InvokeStmt *invstmt)
{
   Invoc *inv = invstmt->get_invoc();
   ParseNode *pn = inv_preprocess(inv);
   ind();
   switch (pn->tag()) {
	case ParseNode::InvocT: {
   		pn_emit(pn);
   		ps(";\n");
   		pn_check_emit(pn);
		}
	}
   }

static void handle_while(WhileStmt *whilestmt)
{
   loop_enter();
   ind();
   ps("for (;;) {\n");
   Expr *ex = whilestmt->get_expr();
   Expr *ex2 = expr_preprocess(ex);
   ps ("if (!");
   expr_emit(ex2);
   ps(") { break; }\n");
   Body *body = whilestmt->get_body();
   handle_body_1(body);
   ind();
   ps("}\n");
   loop_end_label();
   loop_exit();
   }

static void handle_tagc(Tagcase *tagcstmt)
{
   Body* body = tagcstmt->get_body();
   handle_body_1(body);
   }

static void handle_typec(Typecase *typecstmt)
{
   Expr *ex = typecstmt->get_expr();
   Expr *ex2 = expr_preprocess(ex);
   ParseNodeList *arms = typecstmt->get_typeWhenArms();
   bool first = TRUE;
   if (arms) for (Pix p = arms->first() ; p ; arms->next(p)) {
	TypeWhenArm *arm = (TypeWhenArm *)(*arms)(p);
	ind();
	if (first) first = FALSE;
	else ps("else ");
	ps("if (Instance_of((struct Obj_s *)");
	expr_emit(ex2);
	ps(", ");
	type armt = arm->get_typ()->get_type()->get_type();
	string armtnm = type2nm(armt);
/*
	int armtk = type_kind(armt);
	if (armtk == CLASS_KIND 
		|| armtk == PRIMITIVE_KIND
		|| armtk == CLASS_INSTN_KIND) ps("class_as_type(");
	if (armtk == CLASS_INSTN_KIND) ps("class_instn_as_class(");
*/
	pstr(armtnm);
	ps("_V->theta_obj");
/*
	if (armtk == CLASS_KIND 
		|| armtk == PRIMITIVE_KIND
		|| armtk == CLASS_INSTN_KIND) ps(")");
	if (armtk == CLASS_INSTN_KIND) ps(")");
*/
	ps(")) {\n");
	TypeInterface *ti = ex2->get_type();
	type t = get_one_type(ti, typecstmt->get_line());
	Id *id = arm->get_id();
	if (id) {
	    ind();
   	    emit_iter_prefix();
	    pstr(id->get_id());
	    ps(" = ");
	    if (t && (t == objtype_as_type(Any))) {
	       if (string_equal(armtnm, string_new("null"))) {
	    	    ps("0");
		    }
	       else {
		    bool casting = assn_cast_site(id, NULL);
		    expr_emit(ex2);
/*
		    if (string_equal(armtnm, string_new("int"))) {
			ps("i");
			}
		    else if (string_equal(armtnm, string_new("char"))) {
			ps("c");
			}
		    else if (string_equal(armtnm, string_new("bool"))) {
			ps("b");
			}
		    else if (string_equal(armtnm, string_new("real"))) {
			ps("r");
			}
		    else ps("o");
*/
	 	    if (casting) ps(")");
		    }
	        }
	    else {
		    ps("(");
		    pstr(armtnm);
		    ps(")");
		    expr_emit(ex2);
		    }
	    ps(";\n");
	    }
	handle_body_1(arm->get_body());
	ind();
	ps("}\n");
	}
   Body* body = typecstmt->get_body();
   if (body) {
   	ind();
	ps("else {\n");
   	handle_body_1(body);
	ind();
	ps("}\n");
	}
   }

static void handle_ret(ReturnStmt *retstmt)
{
   if (get_iter_active()) {ind(); ps("return 0;");}
   int size = 0;
   bool is_any;
   ParseNodeList *exprs = retstmt->get_exprs();
   ParseNodeList *final_exprs = exprs_preprocess(exprs);
   if (exprs) size = exprs->length();
   if (size == 0) {ind(); ps("return;\n"); return;} 
   if (size > 1) {
	Pix p = final_exprs->first();
	final_exprs->next(p);	// skip over 1st expr...
	for (int i = 0; i < size-1; i++, final_exprs->next(p)) {
   		ind();
		Expr *expr = (Expr *)(*final_exprs)(p);
		type t = get_one_type(expr->get_type(), 88);
		// char *discr = type2discr(t);
		ps("__retvals[");
		pint(i);
		ps("]");
		// ps(discr);
		ps(" = ");
		if (is_vtype(t)) ps("Prim_as_PV(");
		else ps("Obj_as_PV(");
		// if (discr == "o") ps ("(obj)");
		// if (discr == "a") is_any = anyize_it(t);
		expr_emit(expr);
		// if (is_any) ps(")");
		ps(")");
		ps(";\n");
		}
	}
   ind();
   Expr *final = (Expr *)final_exprs->front();
   ps("return ((");
   string crt = current_return_type();
   pstr(crt);
   ps(")(");
   is_any = !strcmp(string_charp(crt), "any");
   type t = get_one_type(final->get_type(), 88);
   if (is_any) is_any = anyize_it(t);
   expr_emit(final);
   if (is_any) ps(")");
   ps("));\n");
   }

static void handle_yield(Yield *yieldstmt)
{
   ParseNodeList *ylds = yieldstmt->get_exprs();
   ParseNodeList *new_yields = exprs_preprocess(ylds);
   int i = 0;
   for (Pix p = new_yields->first(); p; new_yields->next(p)) {
	Expr *ex = (Expr *)(*new_yields)(p);
	ind();
	ps("IState->ret_");
	pint(i);
	ps(" = ");
	expr_emit(ex);
	ps(";\n");
	i++;
	}
   int this_yield = get_next_yield();
   ind();
   ps("IState->pc = ");
   pint(this_yield);
   ps(";\n");
   ind();
   ps("return 1;\n");
   ps("yield_");
   pint(this_yield);
   ps(":\n");
   }

static void handle_sig(SignalStmt *sigstmt)
{
   ParseNodeList *exprs = sigstmt->get_exprs();
   ParseNodeList *final_exprs = exprs_preprocess(exprs);
   int size = 0;
   if (exprs) size = exprs->length();
   /* vec v = make_vec_simple(Obj, 0); */
   // need to handle values...
   ind();
   Id *id = sigstmt->get_id();
   string nm = id->get_id();
   if (wellknown_exception(nm)) {
	ps("Exc = &Exc_");
	pstr(nm);
	if (get_iter_active()) ps("; return 0;\n");
	else ps("; return;\n");
	}
   else {
	ps("Exc = Exception_new(\"");
	pstr(nm);
	if (get_iter_active()) ps("\"); return 0;\n");
	else ps("\"); return;\n");
	}
   }

static void handle_exit(Exit *exitstmt)
{
   if (!exc_scope_exists()) {
		cmp_err("Attempt to do an exit without an enclosing scope",
			exitstmt->get_line());
		return;
		}
   ind();
   Id *id = exitstmt->get_id();
   string nm = id->get_id();
   if (wellknown_exception(nm)) {
	ps("Exc = &Exc_");
	pstr(nm);
	ps(";\n");
	}
   else {
	ps("Exc = Exception_new(\"");
	pstr(nm);
	ps("\");\n");
	}
   exc_goto_exc(FALSE);
   }

static void handle_break()
{
   loop_goto_end();
   }

static void handle_cont()
{
   ind();
   ps("continue;\n");
   }

static void handle_resig(ResignalStmt *resigstmt)
{
   // enter except scope
   exc_enter();
   Stmt *stmt = resigstmt->get_stmt();
   handle_stmt(stmt);
   exc_goto_end();
   // emit exception handling label
   exc_label();
   ParseNodeList *ids = resigstmt->get_ids();
   for (Pix p = ids->first(); p ; ids->next(p)) {
	Id *id = (Id *)(*ids)(p);
	string nm = id->get_id();
	if (wellknown_exception(nm)) {
		ind();
   		ps("if (Exc == &Exc_");
		pstr(nm);
		if (get_iter_active()) ps(") return 0;\n");
		else ps(") return;\n");
		}
	else {
		ind();
   		ps("if (!strcmp(Exc->name, \"");
		pstr(nm);
		if (get_iter_active()) ps("\")) return 0;\n");
		else ps("\")) return;\n");
		}
	}
   // deal with unhandled exception: goto outer scope or longj
   ind();
   ps("UNHANDLED_EXC();\n");
   // The following is probably correct...
   //      need to test it and check in runtime stuff
   //      before everybody sees it.
   //ps("signal_failure(exc->name);\n");
   // leave except scope
   exc_end_label();	// maybe unnecessary
   exc_exit();
   }

static void handle_excpt(ExceptStmt *excptstmt)
{
   // consider special-casing the situation where there is a single statement
   // enter except scope
   exc_enter();
   Stmt *stmt = excptstmt->get_stmt();
   handle_stmt(stmt);
   // emit goto end of except  (body will have goto's to except label)
   exc_goto_end();
   // emit except label
   exc_label();
   ParseNodeList *arms = excptstmt->get_exWhenArm();
   if (arms) for (Pix p = arms->first(); p ; arms->next(p)) {
	ExWhenArm *ewa = (ExWhenArm *)(*arms)(p);
   	ParseNodeList *ids = ewa->get_names();
	ind();
   	ps("if (");
	bool first = TRUE;
   	for (Pix p1 = ids->first(); p1 ; ids->next(p1)) {
		if (first) first = FALSE;
		else ps(" || ");
		Id *id = (Id *)(*ids)(p1);
		string nm = id->get_id();
		if (wellknown_exception(nm)) {
   			ps("Exc == &Exc_");
			pstr(nm);
			}
		else {
   			ps("(!strcmp(Exc->name, \"");
			pstr(nm);
			ps("\"))");
			}
		}
   	ps(") {\n");
	// do decls...
	ind();
	ps("RESET_EXC;\n");
	Body *b = ewa->get_body();
	handle_body_1(b);
	// go to end of except
	ind();
   	ps("}\n");
      	}
   // emit others handler if any
   Decl *d = excptstmt->get_decl();
   Body *b = excptstmt->get_body();
   if (b) {
	if (d) {
		// handle decl (possibly empty)
		}
	handle_body_1(b);
	}
   else {
   	// deal with unhandled exception: goto outer scope, possibly longjmping
   	//		if there is no outer scope
	}
   // emit end of except label
   exc_end_label();
   // leave except scope
   exc_exit();
   }

static void handle_init(Init *initstmt)
{
   // the NULL should perhaps be something else...
   ClassDef *cd = initstmt->get_cdef();
   cname = string_charp(cd->get_classId()->get_id());
   type t = cd->get_type()->get_type();
   class_ c = type_as_class(t);
   objtype osc = UNPV(objtype, vec_fetch(c->superclass, 0));
   string supercname = osc->name;
   init_emit_1(FALSE, current_return_type(), supercname, string_new("self"),
		initstmt->get_fieldInits(), initstmt->get_invoc());
   Body* body = initstmt->get_body();
   handle_body_1(body);
   cname = NULL;
   ind();
   ps("return;\n");
   }

extern void self_obj_emit(const char *casting, bool is_supercm, string supercnm,
                        Expr *prim, bool is_meth, string mkslfnm,
                        string mkslfst, string rtn_nm);
extern void inv_args_emit(Invoc *inv);

static void handle_declfor(DeclForStmt *declforstmt)
{
   bool fast = opt_declforstmt(declforstmt);
   if (fast) return;
   // cmp_err("This for statement is not supported in version 0.",
   // 		declforstmt->get_line());
   // return;

   loop_enter();
   string tmp = get_next_temp();
   Expr *prim = 0;
   bool is_supercm = FALSE;
   bool is_meth = FALSE;
   const char *casting = 0;
   string supercnm = 0;
   string rtn_nm = 0;
   Invoc *inv = declforstmt->get_invoc();
   Invoc *new_inv = (Invoc *)inv_preprocess(inv);
   ind();
   emit_iter_prefix();
   pstr(tmp);
   ps(" = ");
   rid_emit(new_inv, new_inv->get_routineId(), 0, &prim, &is_supercm, &is_meth,
			&casting, &supercnm, &rtn_nm);
   ps("(");
   self_obj_emit(casting, is_supercm, supercnm, prim, is_meth, 0, 0,
			rtn_nm);
   // changed inv to new_inv 1/7/97 dwc
   inv_args_emit(new_inv);
   // if (new_inv->get_exprs() && new_inv->get_exprs()->length()) ps(", ");
   // exprs_emit(new_inv->get_exprs());
   ps(");\n");
   ind();
   ps("while (");
   rid_emit(new_inv, new_inv->get_routineId(), 1, &prim, &is_supercm, &is_meth,
			&casting, &supercnm, &rtn_nm);
   ps("(");
   self_obj_emit(casting, is_supercm, supercnm, prim, is_meth, 0, 0,
			rtn_nm);
   ps(", ");
   emit_iter_prefix();
   pstr(tmp);
   ps("))");
   ps(" {\n");

   ParseNodeList *decls = declforstmt->get_decls();
   int i = 0;
   for (Pix p = decls->first(); p; decls->next(p)) {
        Decl *d = (Decl *)(*decls)(p);
        RegDecl *rd = (RegDecl*)d;
        ParseNodeList *ids = rd->get_ids();
        for (Pix q = ids->first(); q; ids->next(q)) {
                type t = get_nth_return_type(i);
                Id *id = (Id *)(*ids)(q);
                ind();
		emit_iter_prefix();
                pstr(id->get_id());
                ps(" = ");
                bool needs_cast = assn_cast_site(d, t);
                bool is_any = anyize(d, t);
		if (is_vtype(t)) ps("PV_as_prim(");
		else ps("PV_as_obj(");
		pstr(simple_type_name(type_name(t)));
		ps(", ");
		emit_iter_prefix();
		pstr(tmp);
                ps("->ret_");
                pint(i);
                // ps(type2discr(t));
                i++;
                if (is_any) ps(")");
                if (needs_cast) ps(")");
                ps(");\n");
                }
        }

   
   Body* body = declforstmt->get_body();
   handle_body_1(body);
   ps("}\n");
   loop_end_label();
   loop_exit();
   pn_check_emit(new_inv);
   }

static void handle_for(ForStmt *forstmt)
{
   bool fast = opt_forstmt(forstmt);
   if (fast) return;
   // cmp_err("This for statement is not supported in version 0.",
   // 		forstmt->get_line());
   // return;
   loop_enter();
   string tmp = get_next_temp();
   Expr *prim = 0;
   bool is_supercm = FALSE;
   bool is_meth = FALSE;
   const char *casting = 0;
   string supercnm = 0;
   string rtn_nm = 0;
   Invoc *inv = forstmt->get_invoc();
   Invoc *new_inv = (Invoc *)inv_preprocess(inv);
   ind();
   emit_iter_prefix();
   pstr(tmp);
   ps(" = ");
   rid_emit(new_inv, new_inv->get_routineId(), 0, &prim, &is_supercm, &is_meth,
			&casting, &supercnm, &rtn_nm);
   ps("(");
   self_obj_emit(casting, is_supercm, supercnm, prim, is_meth, 0, 0,
			rtn_nm);
   // changed inv to new_inv 1/7/97 dwc
   inv_args_emit(new_inv);
   // if (new_inv->get_exprs() && new_inv->get_exprs()->length()) ps(", ");
   // exprs_emit(new_inv->get_exprs());
   ps(");\n");
   ind();
   ps("while (");
   rid_emit(new_inv, new_inv->get_routineId(), 1, &prim, &is_supercm, &is_meth,
			&casting, &supercnm, &rtn_nm);
   ps("(");
   self_obj_emit(casting, is_supercm, supercnm, prim, is_meth, 0, 0,
			rtn_nm);
   ps(", ");
   emit_iter_prefix();
   pstr(tmp);
   ps("))");
   ps(" {\n");

   int i = 0;
   ParseNodeList *ids = forstmt->get_ids();
   for (Pix q = ids->first(); q; ids->next(q)) {
	type t = get_nth_return_type(i);
	Id *id = (Id *)(*ids)(q);
	ind();
	emit_iter_prefix();
	pstr(id->get_id());
	ps(" = ");
       	bool needs_cast = assn_cast_site(id, t);
       	bool is_any = anyize(id, t);
	// seems like overkill
	if (is_vtype(t)) ps("PV_as_prim(");
	else ps("PV_as_obj(");
	pstr(simple_type_name(type_name(t)));
	ps(", ");
        emit_iter_prefix();
	pstr(tmp);
	ps("->ret_");
	pint(i);
	// ps(type2discr(t));
	i++;
	if (is_any) ps(")");
	if (needs_cast) ps(")");
	ps(");\n");
	}


   Body* body = forstmt->get_body();
   handle_body_1(body);
   ps("}\n");
   loop_end_label();
   loop_exit();
   pn_check_emit(new_inv);
   }
