// Copyright 1995 Barbara Liskov

// #define YYDEBUG
extern "C" {

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include "types/str.h"
#include <fcntl.h>
#include <stdio.h>

/*
#include "types/vec.h"
#include "types/string_class.h"
#include "gen-include.h"
#include "types/dict.h"
#include "types/any.h"
#include "types/vec_class.h"
#include "types/method.h"
#include "types/class.h"
#include "types/class_class.h"

#include "type_init.h"
#include "runtime/disphdr.h"
#include "runtime/alloc.h"
*/

#include <ctype.h>
#include <stdlib.h>

#include "lx_input.h"
}

#include "compiler.h"
#include "environment.h"
#include "desugar.h"
#include "type_replace.h"
#include "type_chk.h"

extern int cmpyy_debug;
int version = 0;
extern void fix_class_supertypes(ParseNodeList *pnl);
extern void theta_env_init();

int match_ids(Id *i1, Id *i2)
{
    // printf("%lX %lX\n", (char*)i1, (char*)i2);
    string j = i1->get_id();
    string k = i2->get_id();
    // printf("%s %s\n", j->chars, k->chars);
    if (!string_equal(i1->get_id(), i2->get_id())) {
      cmpyy_error("Id's do not match.");
      return -1;
    }
    else return 0;
}

ParseNodeList *trav_null(ParseNodeList *lp)
{
	printf(" here in balmy trav_null\n");
	return(lp);
}

int phase = 0;
int lineno = 1;
static Environment *env = 0;

char *theta_compile(FILE *src, char * nm)
{
    if (!env) theta_env_init();
    file_parse(src);
    if (err_list != NULL) return string_charp(err_list);

    do_phases(parse_tree, COMPILE, string_new(nm));
    exc = EXC_NONE;
    if (err_list != NULL) return (char*)string_charp(err_list);
    else return "ok";
   
}

char *theta_set_version(char *opt)
{
    char v = opt[1];
    if (v == '1') version = 1;
    if (v == '2') version = 2;
    if (!env) theta_env_init();
    return "ok";
}

char * theta_check(FILE *src, char * nm)
{
    if (!env) theta_env_init();
    file_parse(src);
    if (err_list != NULL) return string_charp(err_list);

    do_phases(parse_tree, CHECK, string_new(nm));
    exc = EXC_NONE;
    if (err_list != NULL) return string_charp(err_list);
    else return "ok";
}

char * theta_xcheck(FILE *src, char * nm)
{
    if (!env) theta_env_init();
    file_parse(src);
    if (err_list != NULL) return string_charp(err_list);

    do_phases(parse_tree, XCHECK, string_new(nm));
    exc = EXC_NONE;
    if (err_list != NULL) return string_charp(err_list);
    else return "ok";
}

char * theta_parse(FILE *src, char * nm)
{
    file_parse(src);
    if (err_list != NULL) return string_charp(err_list);
    else return "ok";
}

char *theta_show()
{

    exc = EXC_NONE;
    if (!env) return "none";
    return string_charp(env->unparse());
   
}

char *theta_expunge()
{
    env = 0;
    exc = EXC_NONE;
    return "ok";
   
}

void theta_env_init()
{
  /* Set up basic type environment */
  if (!env) {
	env = my_basic_env();
	string_parse(
		"array_new[t] () returns (array[t])"
		"print (message: string)"
		"vector_fill[t] (size: int, elem: t) returns (vector[t]) signals(negative_size)"
		"any_equal (a1: any, a2: any) returns (bool)"
		"array_new_predict[t] (size: int) returns (array[t])"
		"array_to_sequence[T](a: array[T]) returns (sequence[T])"
		"move_array_to_sequence[T](a: array[T]) returns (sequence[T])"
		"move_array_to_vector[T](a: array[T]) returns (vector[T])"
		"vector_to_sequence[T](v: vector[T]) returns (sequence[T])"
		"vector_to_array[T](v: vector[T]) returns (array[T])"
		"array_to_vector[T](a: array[T]) returns (vector[T])"
		"sequence_create[T](s: sequence[T]) returns (sequence[T])"
		"sequence_to_array[T](s: sequence[T]) returns (array[T])"
		"sequence_to_vector[T](s: sequence[T]) returns (vector[T])"
		);
    	if (err_list != NULL) th_fail("theta_env_init failure #1");
    	do_phases(parse_tree, CHECK, string_empty());
    	if (err_list != NULL) th_fail("theta_env_init failure #2");
	}
}

/* 
   yay for yacc... 
   The parse tree is in the global variable parse_tree.
   The errors are in err_list.
*/

void file_parse(FILE *src)
{

#ifdef YYDEBUG
    cmpyy_debug = TRUE;
#endif
    parse_tree = NULL;
    lineno = 1;
    cmp_start_lex_input_file(src, &lineno);
    if (cmpyy_parse() != 0) {}
    cmp_finish_lex_input();
    exc = EXC_NONE;
    if (err_list != NULL) return;
    if (parse_tree == NULL) cmp_err("no parse tree found", 1);
}

void string_parse(char *s)
{

#ifdef YYDEBUG
    cmpyy_debug = TRUE;
#endif
    parse_tree = NULL;
    lineno = 1;
    cmp_start_lex_input_string(s, &lineno);
    if (cmpyy_parse() != 0) {}
    cmp_finish_lex_input();
    exc = EXC_NONE;
    if (err_list != NULL) return;
    if (parse_tree == NULL) cmp_err("no parse tree found", 1);
}

void do_phases(ParseNodeList *pt, int action, string nm)
{
  ParseNodeList *pnl;

  /*----------- Combine spec elements into a spec module -----------*/

  pnl = collect_specs(pt);

  /*----------- Desugaring -----------------------------------------*/

  pnl = traverse_parsenode_list(pnl, new DesugarObj());
  if (err_list != NULL) return;

  /*----------- Type Replacement (probably obsolete) ----------------*/

  pnl = traverse_parsenode_list(pnl, 
	       new TypeReplaceObj(env, TypeReplaceObj::Replace));
  if (err_list != NULL) return;


  /*----------- Theta 0 compliance check ----------------------------*/

  if (action != XCHECK && version == 0) {
        v0_compliance(pnl);
        if (err_list != NULL) return;
	}


  /*----------- Type Checking ---------------------------------------*/

  TypeCheckObj *tco = new TypeCheckObj(env, TypeCheckObj::Check);
  type_checker(pnl, tco);
  env = tco->get_env();
  if (action == CHECK) return;
  // if (action == XCHECK) return;
  if (err_list) return;

  /*----------- Evaluate Constant Expressions -----------------------*/

  pnl = evaluate_expressions(pnl, tco);

  /*----------- Code Generation -------------------------------------*/

  if (version == 0 || version == 1) code_generator(pnl, nm);
  if (version == 2) code_generator_1(pnl, nm);

}

