/* Copyright 1995 Barbara Liskov */

#ifndef _COMPILER_H
#define _COMPILER_H

#include <stdio.h>
#include "parse.h"
#include "type_chk.h"

extern ParseNodeList *parse_tree;
extern string err_list;

void do_phases(ParseNodeList *pt, int stop, string nm);
void v0_compliance(ParseNodeList*);
ParseNodeList *evaluate_expressions(ParseNodeList *pnl, TypeCheckObj *tco);
ParseNode *evaluate_expression(ParseNode *pn, TypeCheckObj *tco);
void code_generator(ParseNodeList*, string);
void code_generator_1(ParseNodeList*, string);
void type_checker(ParseNodeList *pnl, TypeCheckObj *tco);
ParseNodeList *collect_specs(ParseNodeList *pnl);
void file_parse(FILE *src);
void string_parse(char *s);

/* definitions for stop */
#define CHECK 0
#define COMPILE 1
#define XCHECK 2

#ifdef __cplusplus
extern "C" {
#endif
  extern int cmpyy_parse();

  extern char * theta_set_version(char * opt);
  extern char * theta_compile(FILE *src, char * nm);
  extern char * theta_parse(FILE *src, char * nm);
  extern char * theta_check(FILE *src, char * nm);
  extern char * theta_xcheck(FILE *src, char * nm);
  extern char * theta_show();
  extern char * theta_expunge();

  extern int linenumber; 

  extern int cmpyy_lex();
  extern void cmpyy_error(char *msg);
#ifndef __linux__
  extern char *alloca (int size );
#endif

  
extern int match_ids(Id *i1, Id *i2);

#ifdef __cplusplus
}
#endif

#endif /* _COMPILER_H */
