/* Copyright 1995 Barbara Liskov */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

void
main()
{
  char keyword[80], token[80];
  int num, i, lineno = 0;

  while ((num = scanf("%s %s\n", keyword, token)) == 2) {
    lineno++;
    if (isalpha(keyword[0]) == 0)
	  printf("\"%s\"",keyword);
    else {
      for (i=0; i<strlen(keyword); i++) {
	if (isalpha(keyword[i]))
	  printf("[%c%c]", keyword[i], toupper(keyword[i]));
	else
	  printf("\"%c\"",keyword[i]);
      }
    }
    printf("\t\t{ return %s; }\n", token);
  }
  if (num != EOF) {
    fprintf(stderr, "Incorrect format in keyword file, line %d\n", lineno);
    exit(EXIT_FAILURE);
  }
  exit(EXIT_SUCCESS);
}
