// Copyright 1995 Barbara Liskov

#include "parse.h"
#include "desugar.h"

InvocExpr* make_InvocExpr_1(Expr *op1, Expr *op2, string rator)
{
  Invoc* res = new Invoc(op1->line, new SimpleRoutineId(op1->line, 
		new DotExpr(op1->line, op1, 
		new IdExpr(op1->line, new Id(op1->line, rator)))),
		  new ParseNodeList(op2), NULL, NULL);
  return (new InvocExpr(res->line, res));
}


InvocExpr* make_InvocExpr_0(Expr *op1, string rator)
{
  Invoc* res = new Invoc(op1->line, new SimpleRoutineId(op1->line, 
	new DotExpr(op1->line, op1, 
		new IdExpr(op1->line, new Id(op1->line, rator)))), NULL, NULL,
		NULL);
  // printf(" building with line no.\n");
  return (new InvocExpr(res->line, res));
}


ParseNode* desugar_unary(Unary *u, DesugarObj *d) {
  switch (u->tag()) {

    case Unary::NotT: {
      Expr *op = (Expr *) u->get_op()->traverse(d);

      return make_InvocExpr_0(op, string_new("not"));
    }

    case Unary::MinusT: {
      Expr *op = (Expr *) u->get_op()->traverse(d);

      return make_InvocExpr_0(op, string_new("negate"));
    }
  }
}


ParseNode* desugar_binary(Binary *b, DesugarObj *d) {
  switch (b->tag()) {

    case Binary::PlusT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("add"));
    }

    case Binary::MinusT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("subtract"));
    }

    case Binary::TimesT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("multiply"));
    }

    case Binary::DividesT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("divide"));
    }

    case Binary::ModuloT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("mod"));
    }

    case Binary::PowerT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("power"));
    }

    case Binary::LTT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("lt"));
    }

    case Binary::LTET:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("le"));
    }

    case Binary::GTT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("gt"));
    }

    case Binary::GTET:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("ge"));
    }

    case Binary::EqualT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("equal"));
    }

    case Binary::ConcatT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_1(op1, op2, string_new("concat"));
    }

    case Binary::NLTT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_0(make_InvocExpr_1(op1, op2,
					       string_new("lt")),
			      string_new("not"));
    }

    case Binary::NLTET:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_0(make_InvocExpr_1(op1, op2,
					       string_new("le")),
			      string_new("not"));
    }

    case Binary::NGTET:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_0(make_InvocExpr_1(op1, op2,
					       string_new("ge")),
			      string_new("not"));
    }

    case Binary::NGTT: {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_0(make_InvocExpr_1(op1, op2,
					       string_new("gt")),
			      string_new("not"));
    }

    case Binary::NotEqualT:  {
      Expr *op1 = (Expr *) b->get_op1()->traverse(d);
      Expr *op2 = (Expr *) b->get_op2()->traverse(d);

      return make_InvocExpr_0(make_InvocExpr_1(op1, op2,
					       string_new("equal")),
			      string_new("not"));
    }

    default:
      return NULL;
  }
}


ParseNode* desugar_array_ref(ArrayRef *aref, DesugarObj *d)
{
  Expr *arr = (Expr *) aref->get_primary()->traverse(d);
  Expr *ind = (Expr *) aref->get_expr()->traverse(d);
	  
  return make_InvocExpr_1(arr, ind, string_new("fetch"));
}


ParseNode* DesugarObj::setup(ParseNode *pn)
{
	return NULL;
	}

ParseNode* DesugarObj::xmogrify(ParseNode *pn)
{
  switch (pn->tag()) {

    case ParseNode::ModuleT: {
      Module *m = (Module *) pn;
    
      switch (m->tag()) {
      
	case Module::SpecModuleT: { 
	  break;      
	}

	case Module::ImplModuleT: { 
	  break;	
	}

      }
      break;
    }

    case ParseNode::SpecEltT:  {
      SpecElt *se = (SpecElt *) pn;
    
      switch (se->tag()) {
      
	case SpecElt::RoutineSpecT: { 
	  break;
	}
      
	case SpecElt::TypeIntfT: {
	  break;
	}
      
	case SpecElt::SpecEquateT: {
	  break;
	}
      }
      break;
    }

    case ParseNode::RoutineIntfT: {
      RoutineIntf *ri = (RoutineIntf *) pn;
    
      switch (ri->tag()) {
      
	case RoutineIntf::ProcHeaderT: {
	  break;
	}
     
	case RoutineIntf::IterHeaderT: {
	  break;
	}
      
      }
      break;   
    }

    case ParseNode::SignatureT: {
      Signature *sig = (Signature *) pn;

      switch (sig->tag()) {

	case Signature::ProcSigT: {
	  break;
	}
	case Signature::IterSigT: {
	  break;
	}
      }
      break;    
    }

    case ParseNode::EquateT: {
      Equate *eq = (Equate *) pn;
    
      switch (eq->tag()) {
      
	case Equate::TypeEquateT: {
	  break;
	}
      
	case Equate::ExprEquateT: {
	  break;
	}
      }
      break;    
    }

    case ParseNode::ImplEltT:  {
      ImplElt * ie = (ImplElt *) pn;
    
      switch(ie->tag()) {
	case ImplElt::RoutineDefT: {
	  break;
	}
	
	case ImplElt::ClassDefT: {
	  break;
	}
      }
      break;
    }  

    case ParseNode::InheritT: { 
      break;
    }
    
    case ParseNode::RenamingT: { 
      break;
    }
    
    case ParseNode::ExportT: { 
      break;
    }
  
    case ParseNode::MethodOrOpDefT: { 
      break;
    }
    
    case ParseNode::ParmT: { 
      break;
    }
    
    case ParseNode::FormalT: { 
      break;
    }
    
    case ParseNode::ExceptionT: { 
      break;
    }
    
    case ParseNode::RestrictionT: { 
      break;
    }
    
    case ParseNode::TypeSpecT:  {
      TypeSpec * ts = (TypeSpec *) pn;

      switch (ts->tag()) {

	case TypeSpec::SimpleTypeSpecT: {
	  break;
	}
	case TypeSpec::ParamTypeSpecT: {
	  break;
	}
	case TypeSpec::TaggedTypeSpecT: {
	  break;
	}
	case TypeSpec::RoutineTypeSpecT: {
	  break;
	}
      }
      break;
    }  

    case ParseNode::TypeNameT:  {
      break;
    }

    case ParseNode::ActualParmT:  {
      break;
    }

    case ParseNode::ParmOpT:  {
      break;
    }

    case ParseNode::StmtT:  {
      Stmt * s = (Stmt *) pn;

      switch (s->tag()) {

	case Stmt::InitVarExprT: {
	  break;
	}

	case Stmt::InitVarInvokeT: {
	  break;
	}

	case Stmt::DeclStmtT: {
	  break;
	}

	case Stmt::AssignInvokeT: {
	  break;
	}

	case Stmt::AssignExprStmtT: {
	  break;
	}

	case Stmt::AssignExprT: {
	  break;
	}

	case Stmt::InvokeStmtT: {
	  break;
	}

	case Stmt::WhileStmtT: {
	  break;
	}

	case Stmt::IfStmtT: {
	  break;
	}

	case Stmt::TagcaseT: {
	  break;
	}

	case Stmt::TypecaseT: {
	  break;
	}

	case Stmt::ReturnStmtT: {
	  break;
	}

	case Stmt::YieldT: {
	  break;
	}

	case Stmt::SignalStmtT: {
	  break;
	}

	case Stmt::ExitT: {
	  break;
	}

	case Stmt::BreakT: {
	  break;
	}

	case Stmt::ContinueT: {
	  break;
	}

	case Stmt::BlockStmtT: {
	  break;
	}

	case Stmt::ResignalStmtT: {
	  break;
	}

	case Stmt::ExceptStmtT: {
	  break;
	}

	case Stmt::InitT: {
	  break;
	}

	case Stmt::DeclForStmtT: {
	  break;
	}

	case Stmt::ForStmtT: {
	  break;
	}
	break;
      }
    }
    
    case ParseNode::DeclT: {
      Decl *d = (Decl *) pn;
    
      switch (d->tag()) {
      
	case Decl::RegDeclT: {
	  break;
	}

	case Decl::ImplDeclT: {
	  break;
	}

//	case Decl::VarArgsDeclT: {
//	  break;
//	}
	break;
      }
    }

    case ParseNode::IdOrIvarT:  {
      break;
    }
    
    case ParseNode::BodyT:  {
      break;
    }
    
    case ParseNode::ElseIfT:  {
      break;
    }
    
    case ParseNode::TagWhenArmT:  {
      break;
    }

    case ParseNode::TypeWhenArmT:  {
      break;
    }
    
    case ParseNode::ExWhenArmT:  {
      break;
    }
    
    case ParseNode::OthersHandlerT:  {
      break;
    }
    
    case ParseNode::FieldInitT:  {
      break;
    }

    case ParseNode::ExprT:  {
      Expr *ex = (Expr *) pn;
    
      switch (ex->tag()) {

	case Expr::NilT: {
	  break;
	}

	case Expr::LiteralT: {
	  Literal *l = (Literal *) pn;
	      
	  switch (l->tag()) {
		
	    case Literal::IntLiteralT: {
	      break;
	    }
		
	    case Literal::BoolLiteralT:  {
	      break;
	    }
		
	    case Literal::CharLiteralT:  {
	      break;
	    }

	    case Literal::StringLiteralT:  {
	      break;
	    }

	    case Literal::RealLiteralT: {
	      break;
	    }
	    break;
	  }
	}

	case Expr::InstantiationT: {
	  break;
	}

	case Expr::DotExprT:  {
	  break;
	}

	case Expr::SelfT:  {
	  break;
	}

	case Expr::NewT:  {
	  break;
	}

	case Expr::ArrayRefT:  {
	  ArrayRef *aref = (ArrayRef *) ex;

	  return desugar_array_ref(aref, this);
	}

	case Expr::InvocExprT:  {
	  break;
	}

	case Expr::BindingExprT: {
	  break;
	}

	case Expr::SelectorConstrT:  {
	  break;
	}

	case Expr::ArrayConstrT:  {
	  break;
	}

	case Expr::IdExprT: {
	  break;
	}

	case Expr::BinaryT: {
      
	  Binary *b = (Binary *) ex;
      
	  return desugar_binary(b, this);
	}

	case Expr::UnaryT: {
	  Unary *u = (Unary *) pn;

	  return desugar_unary(u, this);
	}
	break;
      }
    }

    case ParseNode::InvocT:  {
      break;
    }

    case ParseNode::RoutineIdT:  {
      RoutineId * rid = (RoutineId *) pn;

      switch (rid->tag()) {
      
	case RoutineId::SimpleRoutineIdT: {
	  break;
	}

	case RoutineId::ComplexRoutineIdT:  {
	  break;
	}

	case RoutineId::SuperClassRoutineIdT: {
	  break;
	}
	break;
      }
    }

    case ParseNode::BindingT:  {
      break;
    }

    case ParseNode::BindingArgT:  {
      break;
    }
    
    case ParseNode::FieldT:  {
      break;
    }
    
    case ParseNode::SuperInfoT:  {
      break;
    }
    
    case ParseNode::IdT: {
      break;
    }
    
    default: {
      return NULL;
    }
  }
  
  return NULL;
}
