// Copyright 1995 Barbara LiskoV


#include "types/str.h"
#include "parse.h"
#include "type_chk.h"
#include "cg.h"
extern "C" {
#include "types/type.h"
#include "types/class.h"
#include "types/int.h"
extern int int_add_(int x, int y);
extern int int_subtract_(int x, int y);
extern int int_multiply_(int x, int y);
extern int int_divide_(int x, int y);
extern int int_mod_(int x, int y);
extern int int_min_(int x, int y);
extern int int_max_(int x, int y);
extern bool int_lt_(int x, int y);
extern bool int_le_(int x, int y);
extern bool int_equal_(int x, int y);
extern bool int_ge_(int x, int y);
extern bool int_gt_(int x, int y);
extern bool int_similar_(int x, int y);
extern int int_copy_(int x);
extern int int_abs_(int x);
extern int int_negate_(int x);
extern int int_power_(int x, int y);
extern char int_to_char_(int x);
extern string int_unparse(int x);
extern bool bool_not(bool x);
extern bool bool_and(bool x, bool y);
extern bool bool_or(bool x, bool y);
extern bool bool_xor(bool x, bool y);
extern bool bool_equal(bool x, bool y);
extern bool bool_similar(bool x, bool y);
extern bool bool_copy(bool x);
extern string bool_unparse(bool x);
extern bool null_similar(null n1, null n2);
extern bool null_equal(null n1, null n2);
extern null null_copy(null n);
extern string null_unparse(null n);
extern bool char_lt(char x, char y);
extern bool char_le(char x, char y);
extern bool char_equal(char x, char y);
extern bool char_ge(char x, char y);
extern bool char_gt(char x, char y);
extern bool char_similar(char x, char y);
extern char char_copy(char x);
extern string char_unparse(char c);
/* extern string char_to_string(char c); */
#include "types/char.h"
extern int char_to_int(char c);
}

ParseNodeList *eval_pnl(ParseNodeList *pnl);
ParseNode *eval_pn(ParseNode *pn);
Body *eval_body(Body *b);
Equate *eval_equate(Equate *e);
Expr *eval_expr(Expr *e);
ParseNode *eval_inv(Invoc *e);
bool is_lit(Expr *e);
ParseNode *eval_string(const char *name, Expr *prim, ParseNodeList *args);
ParseNode *eval_char(const char *name, Expr *prim, ParseNodeList *args);
ParseNode *eval_bool(const char *name, Expr *prim, ParseNodeList *args);
ParseNode *eval_int(const char *name, Expr *prim, ParseNodeList *args);
ParseNode *eval_null(const char *name, Expr *prim, ParseNodeList *args);
int e2i(Expr *e);
bool e2b(Expr *e);
null e2n(Expr *e);
char e2c(Expr *e);
string e2s(Expr *e);

/* 	
	Evaluates literal expressions.
*/

static TypeCheckObj *tco;

ParseNodeList *evaluate_expressions(ParseNodeList *pnl, TypeCheckObj *gtco)
{
   tco = gtco;
   return eval_pnl(pnl);
   }

ParseNode *evaluate_expression(ParseNode *pn, TypeCheckObj *gtco)
{
   tco = gtco;
   return eval_pn(pn);
   }

ParseNodeList *eval_pnl(ParseNodeList *pnl)
{
   if (!pnl) return pnl;

   ParseNodeList *newpnl = new ParseNodeList();

   for (Pix p = pnl->first(); p ; pnl->next(p)){
	ParseNode *pn = (ParseNode *)(*pnl)(p);
	ParseNode *newpn = eval_pn(pn);
	newpnl->append(newpn);
	}
   return newpnl;
   }

ParseNode *eval_pn(ParseNode *pn)
{
ParseNode *newpn = pn;
int line = pn->get_line();

   if (pn) switch (pn->tag()) {
	case ParseNode::ModuleT: {
		Module *m = (Module *)pn;
		switch (m->tag()) {
			case Module::ImplModuleT: {
				ImplModule *im = (ImplModule *)pn;
				im->set_equates(eval_pnl(im->get_equates()));
				im->set_impls(eval_pnl(im->get_impls()));
				break;
				}
			case Module::SpecModuleT: {
				SpecModule *sm = (SpecModule *)pn;
				sm->set_specs(eval_pnl(sm->get_specs()));
				break;
				}
			}
		break;
		}
	case ParseNode::ImplEltT: {
		ImplElt *ie = (ImplElt *)pn;
		switch (ie->tag()) {
			case ImplElt::RoutineDefT: {
				RoutineDef *rd = (RoutineDef *)pn;
				rd->set_body(eval_body(rd->get_body()));
				break;
				}
			case ImplElt::ClassDefT: {
				ClassDef *cd = (ClassDef *)pn;
				cd->set_equates(eval_pnl(cd->get_equates()));
				cd->set_classElts(eval_pnl(cd->get_classElts()));
				break;
				}
			case ImplElt::ImplEquateT: {
				ImplEquate *ieq = (ImplEquate *)ie;
				ieq->set_equate(eval_equate(ieq->get_equate()));
				break;
				}
			}
		break;
		}
	case ParseNode::SpecEltT: {
		SpecElt *se = (SpecElt *)pn;
		switch (se->tag()) {
//			case SpecElt::TypeIntfT: {
//				TypeIntf *tin = (TypeIntf *)se;
//				// eval_pnl(tin->get_methods());
//				break;
//				}
			case SpecElt::SpecEquateT: {
				SpecEquate *seq = (SpecEquate *)se;
				seq->set_equate(eval_equate(seq->get_equate()));
				break;
				}
			}
		break;
		}
	case ParseNode::MethodOrOpDefT: {
		MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
		mopd->set_routineDef((RoutineDef*)eval_pn(mopd->get_routineDef()));
		break;
		}
	case ParseNode::TagWhenArmT: {
		TagWhenArm *twa = (TagWhenArm *)pn;
		twa->set_body(eval_body(twa->get_body()));
		break;	
		}
	case ParseNode::TypeWhenArmT: {
		TypeWhenArm *twa = (TypeWhenArm *)pn;
		twa->set_body(eval_body(twa->get_body()));
		break;	
		}
	case ParseNode::ExWhenArmT: {
		ExWhenArm *ewa = (ExWhenArm *)pn;
		ewa->set_body(eval_body(ewa->get_body()));
		break;	
		}
	case ParseNode::OthersHandlerT: {
		OthersHandler *oh = (OthersHandler *)pn;
		oh->set_body(eval_body(oh->get_body()));
		break;	
		}
	case ParseNode::ElseIfT: {
		ElseIf *els = (ElseIf *)pn;
		els->set_expr(eval_expr(els->get_expr()));
		els->set_body(eval_body(els->get_body()));
		break;	
		}
	case ParseNode::BodyT: {
		Body *b = (Body *)pn;
		b->set_equates(eval_pnl(b->get_equates()));
		b->set_statements(eval_pnl(b->get_statements()));
		break;	
		}
	case ParseNode::ExprT: {
		Expr *ex = (Expr *)pn;
		switch (ex->tag()) {
		   case Expr::SelectorConstrT: {
			SelectorConstr *sc = (SelectorConstr *)ex;
			sc->set_fields(eval_pnl(sc->get_fields()));
			// not sure if this invoc could happen at compile time
			// Invoc *inv = sc->get_invoc();
			// if (inv) eval_inv(inv);
			break;
			}
		   case Expr::InvocExprT: {
			InvocExpr *inve = (InvocExpr *)ex;
			Invoc *inv = inve->get_invoc();
			ParseNode *n = eval_inv(inv);
			switch (n->tag()) {
				case ParseNode::InvocT: {
					Invoc *newinv = (Invoc*)n;
					inve->set_invoc(newinv);
					break;
					}
				case ParseNode::ExprT: {
					newpn = n;
					break;
					}
				default: {
					cmp_err("expr eval failure 1", line);
					break;
					}
				}
			break;
			}
		   case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			Expr *prim = de->get_primary();
			de->set_primary(eval_expr(prim));
			break;
			}
		   case Expr::ArrayRefT: {
			ArrayRef *ar = (ArrayRef *)ex;
			Expr *arex = ar->get_expr();
			ar->set_expr(eval_expr(arex));
			Expr *prim = ar->get_primary();
			ar->set_primary(eval_expr(prim));
			break;
			}
		   case Expr::UnaryT: {
			Unary *un = (Unary *)ex;
			Expr *op = un->get_op();
			un->set_op(eval_expr(op));
			break;
			}
		   case Expr::BinaryT: {
			Binary *bin = (Binary *)ex;
			Expr *op1 = bin->get_op1();
			bin->set_op1(eval_expr(op1));
			Expr *op2 = bin->get_op2();
			bin->set_op2(eval_expr(op2));
			break;
			}
		   case Expr::BracketRefT: {
			BracketRef *br = (BracketRef *)ex;
			ParseNodeList *brexprs = br->get_exprs();
			br->set_exprs(eval_pnl(brexprs));
			Expr *prim = br->get_primary();
			br->set_primary(eval_expr(prim));
			break;
			}
		   case Expr::ArrayConstrT: {
			ArrayConstr *ac = (ArrayConstr *)ex;
			ac->set_size(eval_expr(ac->get_size()));
			ac->set_exprs(eval_pnl(ac->get_exprs()));
			break;
			}
		   }
		// need to add brace arrayconstr, binding...  
		// to find invocations of stand-alone routines...
		break;
		}
	case ParseNode::FieldInitT: {
		FieldInit *fi = (FieldInit *)pn;
		fi->set_expr(eval_expr(fi->get_expr()));
		break;
		}
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		inv->set_routineId((RoutineId*)eval_pn(inv->get_routineId()));
		inv->set_exprs(eval_pnl(inv->get_exprs()));
		inv->set_lastarg(eval_pnl(inv->get_lastarg()));
		break;
		}
	case ParseNode::RoutineIdT: {
		RoutineId *rid = (RoutineId *)pn;
		switch (rid->tag()) {
			case RoutineId::SimpleRoutineIdT: {
				SimpleRoutineId *srid = (SimpleRoutineId *)rid;
				srid->set_primary(eval_expr(srid->get_primary()));
				break;
				}
			case RoutineId::ComplexRoutineIdT: {
				ComplexRoutineId *crid = (ComplexRoutineId *)rid;
				crid->set_primary(eval_expr(crid->get_primary()));
				// it seems unlikely that the following
				// does anything useful in this pass...
				// crid->set_parms(eval_pnl(crid->get_parms()));
				break;
				}
			}
		break;
		}
	case ParseNode::StmtT: {
		Stmt *stmt = (Stmt *)pn;
		switch (stmt->tag()) {
		   case Stmt::InitVarExprT: {
			InitVarExpr *ive = (InitVarExpr *)stmt;
			ive->set_expr(eval_expr(ive->get_expr()));
			break;
			}
		   case Stmt::InitVarInvokeT: {
			InitVarInvoke *ivi = (InitVarInvoke *)stmt;
			ParseNode *n = eval_inv(ivi->get_invoc());
			switch (n->tag()) {
				case ParseNode::InvocT: {
					ivi->set_invoc((Invoc *)n);
					break;
					}
				case ParseNode::ExprT: {
					newpn = new InitVarExpr(
					   line,
					   (Decl *)ivi->get_decls()->front(),
					   (Expr *)n);
					break;
					}
				default: {
					cmp_err("expr eval failure 2", line);
					break;
					}
				}
			break;
			}
		   case Stmt::AssignExprStmtT: {
			AssignExprStmt *aes = (AssignExprStmt *)stmt;
			aes->set_exprs(eval_pnl(aes->get_exprs()));
			break;
			}
		   case Stmt::DeclForStmtT: {
			DeclForStmt *dfs = (DeclForStmt *)stmt;
			dfs->set_body(eval_body(dfs->get_body()));
			break;
			}
		   case Stmt::ForStmtT: {
			ForStmt *fs = (ForStmt *)stmt;
			fs->set_body(eval_body(fs->get_body()));
			break;
			}
		   case Stmt::ExceptStmtT: {
			ExceptStmt *exs = (ExceptStmt *)stmt;
			exs->set_stmt((Stmt*)eval_pn(exs->get_stmt()));
			exs->set_exWhenArm(eval_pnl(exs->get_exWhenArm()));
			exs->set_body(eval_body(exs->get_body()));
			break;
			}
		   case Stmt::InvokeStmtT: {
			InvokeStmt *invs = (InvokeStmt *)stmt;
			ParseNode *n = eval_inv(invs->get_invoc());
			switch (n->tag()) {
				case ParseNode::InvocT: {
					invs->set_invoc((Invoc *)n);
					break;
					}
				case ParseNode::ExprT: {
					// maybe the user should be warned???
					newpn = new BlockStmt(line,
						   new Body(line,
						        new ParseNodeList(),
							new ParseNodeList()));
					break;
					}
				default: {
					cmp_err("expr eval failure 3", line);
					break;
					}
				}
			break;
			}
		   case Stmt::WhileStmtT: {
			WhileStmt *wh = (WhileStmt *)stmt;
			wh->set_expr(eval_expr(wh->get_expr()));
			wh->set_body(eval_body(wh->get_body()));
			break;
			}
		   case Stmt::IfStmtT: {
			IfStmt *ifst = (IfStmt *)stmt;
			ifst->set_expr(eval_expr(ifst->get_expr()));
			ifst->set_body(eval_body(ifst->get_body()));
			ifst->set_elseifs(eval_pnl(ifst->get_elseifs()));
			ifst->set_elsebody(eval_body(ifst->get_elsebody()));
			break;
			}
		   case Stmt::TypecaseT: {
			Typecase *tp = (Typecase *)stmt;
			tp->set_expr(eval_expr(tp->get_expr()));
			tp->set_typeWhenArms(eval_pnl(tp->get_typeWhenArms()));
			tp->set_body(eval_body(tp->get_body()));
			break;
			}
		   case Stmt::TagcaseT: {
			Tagcase *tg = (Tagcase *)stmt;
			tg->set_expr(eval_expr(tg->get_expr()));
			tg->set_tagWhenArms(eval_pnl(tg->get_tagWhenArms()));
			tg->set_body(eval_body(tg->get_body()));
			break;
			}
		   case Stmt::InitT: {
			Init *init = (Init *)stmt;
			init->set_fieldInits(eval_pnl(init->get_fieldInits()));
			Invoc *inv = init->get_invoc();
			if (inv) {
			    ParseNode *n = eval_inv(init->get_invoc());
			    switch (n->tag()) {
				case ParseNode::InvocT: {
					init->set_invoc((Invoc *)n);
					break;
					}
				case ParseNode::ExprT: {
					// maybe the user should be warned???
					init->set_invoc(NULL);
					break;
					}
				default: {
					cmp_err("expr eval failure 4", line);
					break;
					}
				}
			     }
			init->set_body(eval_body(init->get_body()));
			break;
			}
		   case Stmt::BlockStmtT: {
			BlockStmt *b = (BlockStmt *)stmt;
			b->set_body(eval_body(b->get_body()));
			break;	
			}
		   case Stmt::ResignalStmtT: {
			ResignalStmt *rs = (ResignalStmt *)stmt;
			rs->set_stmt((Stmt*)eval_pn(rs->get_stmt()));
			break;	
			}
		   case Stmt::ReturnStmtT: {
			ReturnStmt *rt = (ReturnStmt *)stmt;
			rt->set_exprs(eval_pnl(rt->get_exprs()));
			break;	
			}
		   case Stmt::YieldT: {
			Yield *y = (Yield *)stmt;
			y->set_exprs(eval_pnl(y->get_exprs()));
			break;	
			}
		   case Stmt::SignalStmtT: {
			SignalStmt *s = (SignalStmt *)stmt;
			s->set_exprs(eval_pnl(s->get_exprs()));
			break;	
			}
		   case Stmt::ExitT: {
			Exit *s = (Exit *)stmt;
			s->set_exprs(eval_pnl(s->get_exprs()));
			break;	
			}
		   }
		break;
		}
	}
   return newpn;
   }

Body *eval_body(Body *b)
{
	if (!b) return b;
	ParseNodeList *equates = b->get_equates();
	ParseNodeList *statements = b->get_statements();
	ParseNodeList *nequates = NULL;
	ParseNodeList *nstatements = NULL;
	if (equates) nequates = eval_pnl(equates);
	if (statements) nstatements = eval_pnl(statements);
	return new Body(b->get_line(), nequates, nstatements);
	}

Equate *eval_equate(Equate *e)
{
	switch (e->tag()) {
		case Equate::ExprEquateT: {
			ExprEquate *eeq = (ExprEquate*)e;
			eeq->set_expr(eval_expr(eeq->get_expr()));
			break;
			}
		// Don't do anything for type equates...
		}
	return e;
	}

Stmt *eval_stmt(Stmt *s)
{
	ParseNode *n = eval_pn(s);
	switch (n->tag()) {
		case ParseNode::StmtT: {
			Stmt *ns = (Stmt*)n;
			return ns;
			}
		default: {
			cmp_err("expr eval failure 5", s->get_line());
			n->print(1);
			return s;
			}
		}
	}

Expr *eval_expr(Expr *e)
{
	ParseNode *n = eval_pn(e);
	switch (n->tag()) {
		case ParseNode::ExprT: {
			Expr *ne = (Expr*)n;
			return ne;
			}
		default: {
			cmp_err("expr eval failure 6", e->get_line());
			e->print(1);
			return e;
			}
		}
	}

ParseNode *eval_inv(Invoc *inv)
{
const char *name;
type t = 0;
Expr *prim;

	ParseNode *n = eval_pn(inv);
	// preprocess the invocation...
	// this will evaluate the arguments and the routine id too.
	Invoc *inv2 = (Invoc*)n;

	// inv2 is our best answer, unless the evaluation actually happens.

	// check that the args are literals...
	ParseNodeList *args = inv2->get_exprs();
	if (args) for (Pix p = args->first(); p ; args->next(p)) {
		Expr *e = (Expr*)(*args)(p);
		if (! is_lit(e) ) return inv2;
		}

	// see if the routine id is a dot expr and dig out type of
	// 	controlling variable.
	RoutineId *rid = inv2->get_routineId();
	switch (rid->tag()) {
		case RoutineId::SimpleRoutineIdT: {
			SimpleRoutineId *srid = (SimpleRoutineId *)rid;
			Expr *sprim = srid->get_primary();
			if (sprim->tag() != Expr::DotExprT) return inv2;
			DotExpr *de = (DotExpr *)sprim;
			Expr *deidx = de->get_id();
			if (deidx->tag() == Expr::SuperIdT) return inv2;
			IdExpr *deid = (IdExpr*)deidx;
			name = string_charp(deid->get_id()->get_id());
			prim = de->get_primary();
			if (!is_lit(prim)) return inv2;
			t = get_one_type(prim->get_type(), 22);
			if (!t) return inv2;
			break;
			}
		default: {
			return inv2;
			}
		}

	// now all the args are literals and the method id is in name.
	// and the type of the controlling variable is in t.

	ParseNode *pn;
	if (t == class_as_type(Int)) {
		pn = eval_int(name, prim, args);
		}
	else if (t == class_as_type(Bool)) {
		pn = eval_bool(name, prim, args);
		}
	else if (t == class_as_type(Char)) {
		pn = eval_char(name, prim, args);
		}
	else if (t == class_as_type(String)) {
		pn = eval_string(name, prim, args);
		}
	else if (t == class_as_type(Null)) {
		pn = eval_null(name, prim, args);
		}
	if (pn) return pn;
	return inv2;
	}

bool is_lit(Expr *e)
{
	switch (e->tag()) {
		case Expr::LiteralT: {
			return TRUE;
			}
		case Expr::NilT: {
			return TRUE;
			}
		return FALSE;
		}
	return FALSE;
	}

ParseNode *eval_int(const char *name, Expr *prim, ParseNodeList *args)
{
	RESET_EXC;
	if (!strcmp(name, "add")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_add_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "subtract")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_subtract_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "multiply")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_multiply_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "divide")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_divide_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "mod")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_mod_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "min")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_min_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "max")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		int res = int_max_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "lt")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_lt_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "le")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_le_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "equal")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_equal_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "ge")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_ge_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "gt")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_gt_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "similar")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr*)args->front());
		CATCH {return NULL;}
		bool res = int_similar_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *il = new BoolLiteral(res);
		il->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return il;
		}
	else if (!strcmp(name, "copy")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int res = int_copy_(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "abs")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int res = int_abs_(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "negate")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int res = int_negate_(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "power")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		int op2 = e2i((Expr *)args->front());
		CATCH {return NULL;}
		int res = int_power_(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		IntLiteral *il = new IntLiteral(res);
		il->type_ = tco->env->look_up(string_const("int"))->get_type();
		return il;
		}
	else if (!strcmp(name, "to_char")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		char res = int_to_char_(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		CharLiteral *il = new CharLiteral(res);
		il->type_ = tco->env->look_up(string_const("char"))->get_type();
		return il;
		}
	else if (!strcmp(name, "unparse")) {
		int op1 = e2i(prim);
		CATCH {return NULL;}
		string res = int_unparse(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		StringLiteral *sl = new StringLiteral(res);
		sl->type_ = tco->env->look_up(string_const("string"))->get_type();
		return sl;
		}

	return NULL;
	}

ParseNode *eval_bool(const char *name, Expr *prim, ParseNodeList *args)
{
	RESET_EXC;
	if (!strcmp(name, "not")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool res = bool_not(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "and")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool op2 = e2b((Expr*)args->front());
		CATCH {return NULL;}
		bool res = bool_and(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "or")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool op2 = e2b((Expr*)args->front());
		CATCH {return NULL;}
		bool res = bool_or(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "xor")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool op2 = e2b((Expr*)args->front());
		CATCH {return NULL;}
		bool res = bool_xor(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "equal")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool op2 = e2b((Expr*)args->front());
		CATCH {return NULL;}
		bool res = bool_equal(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "similar")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool op2 = e2b((Expr*)args->front());
		CATCH {return NULL;}
		bool res = bool_similar(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "copy")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		bool res = bool_copy(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "unparse")) {
		bool op1 = e2b(prim);
		CATCH {return NULL;}
		string res = bool_unparse(op1);
		CATCH { exc = &exc_not_possible; return NULL; }
		StringLiteral *sl = new StringLiteral(res);
		sl->type_ = tco->env->look_up(string_const("string"))->get_type();
		return sl;
		}
	return NULL;
	}

ParseNode *eval_char(const char *name, Expr *prim, ParseNodeList *args)
{
	RESET_EXC;
	if (!strcmp(name, "equal")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                char op2 = e2c((Expr*)args->front());
                CATCH {return NULL;}
                bool res = char_equal(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        if (!strcmp(name, "similar")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                char op2 = e2c((Expr*)args->front());
                CATCH {return NULL;}
                bool res = char_similar(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
	else if (!strcmp(name, "lt")) {
		char op1 = e2c(prim);
		CATCH {return NULL;}
		char op2 = e2c((Expr*)args->front());
		CATCH {return NULL;}
		bool res = char_lt(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "le")) {
		char op1 = e2c(prim);
		CATCH {return NULL;}
		char op2 = e2c((Expr*)args->front());
		CATCH {return NULL;}
		bool res = char_le(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "ge")) {
		char op1 = e2c(prim);
		CATCH {return NULL;}
		char op2 = e2c((Expr*)args->front());
		CATCH {return NULL;}
		bool res = char_ge(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "gt")) {
		char op1 = e2c(prim);
		CATCH {return NULL;}
		char op2 = e2c((Expr*)args->front());
		CATCH {return NULL;}
		bool res = char_gt(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
	else if (!strcmp(name, "similar")) {
		char op1 = e2c(prim);
		CATCH {return NULL;}
		char op2 = e2c((Expr*)args->front());
		CATCH {return NULL;}
		bool res = char_similar(op1, op2);
		CATCH { exc = &exc_not_possible; return NULL; }
		BoolLiteral *bl = new BoolLiteral(res);
		bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
		return bl;
		}
        else if (!strcmp(name, "copy")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                char res = char_copy(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                CharLiteral *cl = new CharLiteral(res);
                cl->type_ = tco->env->look_up(string_const("char"))->get_type();
                return cl;
		}
        else if (!strcmp(name, "to_int")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                int res = char_to_int(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                IntLiteral *il = new IntLiteral(res);
                il->type_ = tco->env->look_up(string_const("int"))->get_type();
                return il;
                }
        else if (!strcmp(name, "to_string")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                string res = char_to_string(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        else if (!strcmp(name, "unparse")) {
                char op1 = e2c(prim);
                CATCH {return NULL;}
                string res = char_unparse(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
	return NULL;
	}

ParseNode *eval_string(const char *name, Expr *prim, ParseNodeList *args)
{
	RESET_EXC;
        if (!strcmp(name, "equal")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_equal(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        if (!strcmp(name, "similar")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_similar(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        if (!strcmp(name, "first")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                int op2 = e2i((Expr*)args->front());
                CATCH {return NULL;}
                string res = string_first(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        if (!strcmp(name, "rest")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                int op2 = e2i((Expr*)args->front());
                CATCH {return NULL;}
                string res = string_rest(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        if (!strcmp(name, "concat")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                string res = string_concat(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        if (!strcmp(name, "append")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                char op2 = e2c((Expr*)args->front());
                CATCH {return NULL;}
                string res = string_append(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        if (!strcmp(name, "extract")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                int op2 = e2i((Expr*)args->front());
                CATCH {return NULL;}
                int op3 = e2i((Expr*)args->rear());
                CATCH {return NULL;}
                string res = string_extract(op1, op2, op3);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        if (!strcmp(name, "fetch")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                int op2 = e2i((Expr*)args->front());
                CATCH {return NULL;}
                char res = string_fetch(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                CharLiteral *cl = new CharLiteral(res);
                cl->type_ = tco->env->look_up(string_const("char"))->get_type();
                return cl;
                }
        else if (!strcmp(name, "copy")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string res = string_copy(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }
        else if (!strcmp(name, "length")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                int res = string_length(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                IntLiteral *il = new IntLiteral(res);
                il->type_ = tco->env->look_up(string_const("int"))->get_type();
                return il;
                }
        else if (!strcmp(name, "empty")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                bool res = string_empty_(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        else if (!strcmp(name, "unparse")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string res = string_unparse(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type(
);
                return sl;
                }
        else if (!strcmp(name, "lt")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_lt(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        else if (!strcmp(name, "le")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_le(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        else if (!strcmp(name, "ge")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_ge(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        else if (!strcmp(name, "gt")) {
                string op1 = e2s(prim);
                CATCH {return NULL;}
                string op2 = e2s((Expr*)args->front());
                CATCH {return NULL;}
                bool res = string_gt(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }

	return NULL;
	}

ParseNode *eval_null(const char *name, Expr *prim, ParseNodeList *args)
{
	RESET_EXC;
        if (!strcmp(name, "equal")) {
                null op1 = e2n(prim);
                CATCH {return NULL;}
                null op2 = e2n((Expr*)args->front());
                CATCH {return NULL;}
                bool res = null_equal(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        if (!strcmp(name, "similar")) {
                null op1 = e2n(prim);
                CATCH {return NULL;}
                null op2 = e2n((Expr*)args->front());
                CATCH {return NULL;}
                bool res = null_similar(op1, op2);
                CATCH { exc = &exc_not_possible; return NULL; }
                BoolLiteral *bl = new BoolLiteral(res);
                bl->type_ = tco->env->look_up(string_const("bool"))->get_type();
                return bl;
                }
        else if (!strcmp(name, "copy")) {
                null op1 = e2n(prim);
                CATCH {return NULL;}
                null res = null_copy(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                Expr *nl = new Expr(Expr::NilT);
                nl->type_ = tco->env->look_up(string_const("null"))->get_type();
                return nl;
                }
        else if (!strcmp(name, "unparse")) {
                null op1 = e2n(prim);
                CATCH {return NULL;}
                string res = null_unparse(op1);
                CATCH { exc = &exc_not_possible; return NULL; }
                StringLiteral *sl = new StringLiteral(res);
                sl->type_ = tco->env->look_up(string_const("string"))->get_type();
                return sl;
                }

	return NULL;
	}

int e2i(Expr *e)
{
int line = e->get_line();

	switch (e->tag()) {
		case Expr::LiteralT: {
			Literal *l = (Literal*)e;
			switch (l->tag()) {
				case Literal::IntLiteralT: {
					IntLiteral *il = (IntLiteral *)l;
					return il->get_i();
					}
				}
			}
		}
	cmp_err("missing integer literal", line);
	exc = &exc_not_possible;
	}

bool e2b(Expr *e)
{
int line = e->get_line();

        switch (e->tag()) {
                case Expr::LiteralT: {
                        Literal *l = (Literal*)e;
                        switch (l->tag()) {
                                case Literal::BoolLiteralT: {
                                        BoolLiteral *bl = (BoolLiteral *)l;
                                        return bl->get_b();
                                        }
                                }
                        }
                }
        cmp_err("missing bool literal", line);
        exc = &exc_not_possible;
        }

null e2n(Expr *e)
{
int line = e->get_line();

        switch (e->tag()) {
                case Expr::NilT: {
			return 0;
                        }
                }
        cmp_err("missing null literal", line);
        exc = &exc_not_possible;
        }

char e2c(Expr *e)
{
int line = e->get_line();

        switch (e->tag()) {
                case Expr::LiteralT: {
                        Literal *l = (Literal*)e;
                        switch (l->tag()) {
                                case Literal::CharLiteralT: {
                                        CharLiteral *cl = (CharLiteral *)l;
                                        return cl->get_c();
                                        }
                                }
                        }
                }
        cmp_err("missing char literal", line);
        exc = &exc_not_possible;
        }

string e2s(Expr *e)
{
int line = e->get_line();

        switch (e->tag()) {
                case Expr::LiteralT: {
                        Literal *l = (Literal*)e;
                        switch (l->tag()) {
                                case Literal::StringLiteralT: {
                                        StringLiteral *sl = (StringLiteral *)l;
                                        return sl->get_s();
                                        }
                                }
                        }
                }
        cmp_err("missing string literal", line);
        exc = &exc_not_possible;
        }

